/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class RitualEffectAnimalGrowth
extends RitualEffect {
    public static final int breedingCost = 50;
    public static final int reductusDrain = 1;
    public static final int virtusDrain = 10;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (world.getWorldTime() % 20L != 0L) {
            return;
        }
        double range = 2.0;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)x, (double)((double)y + 1.0), (double)z, (double)(x + 1), (double)(y + 3), (double)(z + 1)).expand(range, 0.0, range);
        List list = world.getEntitiesWithinAABB(EntityAgeable.class, axisalignedbb);
        int entityCount = 0;
        boolean flag = false;
        if (currentEssence < this.getCostPerRefresh() * list.size()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            boolean hasReductus = this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 1, false);
            for (EntityAgeable entity : list) {
                if (entity.getGrowingAge() < 0) {
                    entity.addGrowth(5);
                    ++entityCount;
                    continue;
                }
                if (!(hasReductus = hasReductus && this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 1, false)) || !(entity instanceof EntityAnimal) || entity.getGrowingAge() <= 0) continue;
                EntityAnimal animal = (EntityAnimal)entity;
                entity.setGrowingAge(Math.max(0, animal.getGrowingAge() - 40));
                this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 1, true);
                ++entityCount;
            }
            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh() * entityCount);
        }
        boolean hasVirtus = this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, false);
        if (hasVirtus && SoulNetworkHandler.canSyphonFromOnlyNetwork(owner, 50)) {
            List animalList = world.getEntitiesWithinAABB(EntityAnimal.class, axisalignedbb);
            TileEntity tile = world.getTileEntity(x, y + 1, z);
            IInventory inventory = null;
            if (tile instanceof IInventory) {
                inventory = (IInventory)tile;
            } else {
                tile = world.getTileEntity(x, y - 1, z);
                if (tile instanceof IInventory) {
                    inventory = (IInventory)tile;
                }
            }
            if (inventory != null) {
                block1: for (EntityAnimal entityAnimal : animalList) {
                    if (entityAnimal.isInLove() || entityAnimal.isChild() || entityAnimal.getGrowingAge() > 0) continue;
                    hasVirtus = hasVirtus && this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, false);
                    boolean hasLP = SoulNetworkHandler.canSyphonFromOnlyNetwork(owner, 50);
                    for (int i = 0; i < inventory.getSizeInventory(); ++i) {
                        ItemStack stack = inventory.getStackInSlot(i);
                        if (stack == null || !entityAnimal.isBreedingItem(stack)) continue;
                        inventory.decrStackSize(i, 1);
                        entityAnimal.func_146082_f(null);
                        this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, true);
                        SoulNetworkHandler.syphonFromNetwork(owner, 50);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostAnimalGrowth[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> animalGrowthRitual = new ArrayList<RitualComponent>();
        animalGrowthRitual.add(new RitualComponent(0, 0, 2, 5));
        animalGrowthRitual.add(new RitualComponent(2, 0, 0, 5));
        animalGrowthRitual.add(new RitualComponent(0, 0, -2, 5));
        animalGrowthRitual.add(new RitualComponent(-2, 0, 0, 5));
        animalGrowthRitual.add(new RitualComponent(0, 0, 1, 1));
        animalGrowthRitual.add(new RitualComponent(1, 0, 0, 1));
        animalGrowthRitual.add(new RitualComponent(0, 0, -1, 1));
        animalGrowthRitual.add(new RitualComponent(-1, 0, 0, 1));
        animalGrowthRitual.add(new RitualComponent(1, 0, 2, 3));
        animalGrowthRitual.add(new RitualComponent(-1, 0, 2, 3));
        animalGrowthRitual.add(new RitualComponent(1, 0, -2, 3));
        animalGrowthRitual.add(new RitualComponent(-1, 0, -2, 3));
        animalGrowthRitual.add(new RitualComponent(2, 0, 1, 4));
        animalGrowthRitual.add(new RitualComponent(2, 0, -1, 4));
        animalGrowthRitual.add(new RitualComponent(-2, 0, 1, 4));
        animalGrowthRitual.add(new RitualComponent(-2, 0, -1, 4));
        return animalGrowthRitual;
    }
}

