/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RitualEffectCrafting
extends RitualEffect {
    public static final boolean limitToSingleStack = true;
    public static final int potentiaDrain = 2;
    public static final int virtusDrain = 2;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        boolean hasPotentia = this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 2, false);
        if (world.getWorldTime() % (long)(hasPotentia ? 1 : 4) != 0L) {
            return;
        }
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            NBTTagCompound tag = ritualStone.getCustomRitualTag();
            if (tag == null) {
                ritualStone.setCustomRitualTag(new NBTTagCompound());
                tag = ritualStone.getCustomRitualTag();
            }
            boolean lastFailed = tag.getBoolean("didLastCraftFail");
            int slotDesignation = tag.getInteger("slotDesignation");
            if (lastFailed) {
                tag.setInteger("slotDesignation", ++slotDesignation);
                tag.setBoolean("didLastCraftFail", false);
            }
            int direction = ritualStone.getDirection();
            boolean canContinue = false;
            ItemStack[] recipe = new ItemStack[9];
            InventoryCrafting inventory = new InventoryCrafting(new Container(){

                public boolean canInteractWith(EntityPlayer player) {
                    return false;
                }
            }, 3, 3);
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    ItemStack invStack;
                    int gridSpace = (i + 1) * 3 + (j + 1);
                    Int3 pos = this.getSlotPositionForDirection(gridSpace, direction);
                    TileEntity inv = world.getTileEntity(x + pos.xCoord, y + pos.yCoord, z + pos.zCoord);
                    if (!(inv instanceof IInventory) || ((IInventory)inv).getSizeInventory() <= slotDesignation || !((IInventory)inv).isItemValidForSlot(slotDesignation, ((IInventory)inv).getStackInSlot(slotDesignation)) || (invStack = ((IInventory)inv).getStackInSlot(slotDesignation)) == null) continue;
                    inventory.setInventorySlotContents(gridSpace, invStack);
                    recipe[gridSpace] = invStack;
                    canContinue = true;
                }
            }
            if (!canContinue) {
                tag.setInteger("slotDesignation", 0);
                return;
            }
            ItemStack returnStack = CraftingManager.getInstance().findMatchingRecipe(inventory, world);
            if (returnStack == null) {
                tag.setBoolean("didLastCraftFail", true);
            } else {
                boolean hasVirtus;
                boolean addOutputToInputs = hasVirtus = this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 2, false);
                IInventory outputInv = null;
                ArrayList<IInventory> invList = new ArrayList<IInventory>();
                TileEntity northEntity = world.getTileEntity(x, y - 1, z - 2);
                TileEntity southEntity = world.getTileEntity(x, y - 1, z + 2);
                TileEntity eastEntity = world.getTileEntity(x + 2, y - 1, z);
                TileEntity westEntity = world.getTileEntity(x - 2, y - 1, z);
                switch (direction) {
                    case 1: {
                        if (!(southEntity instanceof IInventory)) {
                            return;
                        }
                        outputInv = (IInventory)southEntity;
                        if (northEntity instanceof IInventory) {
                            invList.add((IInventory)northEntity);
                        }
                        if (eastEntity instanceof IInventory) {
                            invList.add((IInventory)eastEntity);
                        }
                        if (!(westEntity instanceof IInventory)) break;
                        invList.add((IInventory)westEntity);
                        break;
                    }
                    case 2: {
                        if (!(westEntity instanceof IInventory)) {
                            return;
                        }
                        outputInv = (IInventory)westEntity;
                        if (northEntity instanceof IInventory) {
                            invList.add((IInventory)northEntity);
                        }
                        if (eastEntity instanceof IInventory) {
                            invList.add((IInventory)eastEntity);
                        }
                        if (!(southEntity instanceof IInventory)) break;
                        invList.add((IInventory)southEntity);
                        break;
                    }
                    case 3: {
                        if (!(northEntity instanceof IInventory)) {
                            return;
                        }
                        outputInv = (IInventory)northEntity;
                        if (eastEntity instanceof IInventory) {
                            invList.add((IInventory)eastEntity);
                        }
                        if (southEntity instanceof IInventory) {
                            invList.add((IInventory)southEntity);
                        }
                        if (!(westEntity instanceof IInventory)) break;
                        invList.add((IInventory)westEntity);
                        break;
                    }
                    case 4: {
                        if (!(eastEntity instanceof IInventory)) {
                            return;
                        }
                        outputInv = (IInventory)eastEntity;
                        if (northEntity instanceof IInventory) {
                            invList.add((IInventory)northEntity);
                        }
                        if (southEntity instanceof IInventory) {
                            invList.add((IInventory)southEntity);
                        }
                        if (!(westEntity instanceof IInventory)) break;
                        invList.add((IInventory)westEntity);
                    }
                }
                if (outputInv != null) {
                    if (!SpellHelper.canInsertStackFullyIntoInventory(returnStack, outputInv, ForgeDirection.DOWN, true, returnStack.getMaxStackSize())) {
                        tag.setBoolean("didLastCraftFail", true);
                        return;
                    }
                    if (addOutputToInputs) {
                        invList.add(outputInv);
                    }
                    HashMap syphonMap = new HashMap();
                    for (int n = 0; n < recipe.length; ++n) {
                        ItemStack recipeStack = recipe[n];
                        if (recipeStack == null) continue;
                        boolean isItemTaken = false;
                        block9: for (int i = 0; i < invList.size() && !isItemTaken; ++i) {
                            IInventory inputInv = (IInventory)invList.get(i);
                            if (inputInv == null) continue;
                            for (int j = 0; j < inputInv.getSizeInventory(); ++j) {
                                ItemStack invItem;
                                if (!inputInv.isItemValidForSlot(j, recipeStack) || (invItem = inputInv.getStackInSlot(j)) == null || !this.areItemsEqualForCrafting(recipeStack, invItem)) continue;
                                inventory.setInventorySlotContents(n, invItem);
                                HashMap<Integer, Integer> slotMap = (HashMap<Integer, Integer>)syphonMap.get(i);
                                if (slotMap == null) {
                                    slotMap = new HashMap<Integer, Integer>();
                                    syphonMap.put(i, slotMap);
                                }
                                if (slotMap.containsKey(j)) {
                                    int syphoned = (Integer)slotMap.get(j);
                                    if (invItem.stackSize - syphoned <= 0) continue;
                                    slotMap.put(j, syphoned + 1);
                                    isItemTaken = true;
                                    continue block9;
                                }
                                slotMap.put(j, 1);
                                isItemTaken = true;
                                continue block9;
                            }
                        }
                        if (isItemTaken) continue;
                        tag.setBoolean("didLastCraftFail", true);
                        return;
                    }
                    SpellHelper.insertStackIntoInventory(CraftingManager.getInstance().findMatchingRecipe(inventory, world), outputInv, ForgeDirection.DOWN);
                    for (Map.Entry entry1 : syphonMap.entrySet()) {
                        IInventory inputInv = (IInventory)invList.get((Integer)entry1.getKey());
                        for (Map.Entry entry2 : ((Map)entry1.getValue()).entrySet()) {
                            ItemStack drainedStack = inputInv.getStackInSlot(((Integer)entry2.getKey()).intValue());
                            Item item = drainedStack.getItem();
                            if (item.hasContainerItem(drainedStack)) {
                                inputInv.setInventorySlotContents(((Integer)entry2.getKey()).intValue(), item.getContainerItem(drainedStack));
                                continue;
                            }
                            drainedStack.stackSize -= ((Integer)entry2.getValue()).intValue();
                            if (drainedStack.stackSize > 0) continue;
                            inputInv.setInventorySlotContents(((Integer)entry2.getKey()).intValue(), null);
                        }
                    }
                    if (addOutputToInputs && syphonMap.containsKey(invList.size())) {
                        this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 2, true);
                    }
                    SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
                    if (hasPotentia) {
                        this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 2, true);
                    }
                    world.markBlockForUpdate(x, y - 1, z + 2);
                    world.markBlockForUpdate(x, y - 1, z - 2);
                    world.markBlockForUpdate(x + 2, y - 1, z);
                    world.markBlockForUpdate(x - 2, y - 1, z);
                }
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostCrafting[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> autoCraftingRitual = new ArrayList<RitualComponent>();
        this.addCornerRunes(autoCraftingRitual, 1, 1, 3);
        this.addParallelRunes(autoCraftingRitual, 1, 1, 3);
        autoCraftingRitual.add(new RitualComponent(0, 1, 0, 4));
        this.addOffsetRunes(autoCraftingRitual, 1, 2, -1, 2);
        this.addCornerRunes(autoCraftingRitual, 1, -1, 2);
        autoCraftingRitual.add(new RitualComponent(-1, -1, 0, 3));
        autoCraftingRitual.add(new RitualComponent(1, -1, 0, 3));
        autoCraftingRitual.add(new RitualComponent(0, -1, -1, 3));
        autoCraftingRitual.add(new RitualComponent(0, -1, 0, 2));
        autoCraftingRitual.add(new RitualComponent(0, -1, 1, 1));
        return autoCraftingRitual;
    }

    public boolean areItemsEqualForCrafting(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.getItem() == stack2.getItem() && !stack1.getItem().getHasSubtypes() || stack1.getItemDamage() == stack2.getItemDamage();
    }

    public boolean areItemStacksEqualWithWildcard(ItemStack recipeStack, ItemStack comparedStack) {
        return recipeStack.isItemEqual(comparedStack) || recipeStack.getItemDamage() == Short.MAX_VALUE && recipeStack.getItem() == comparedStack.getItem();
    }

    public Int3 getSlotPositionForDirection(int slot, int direction) {
        int x = slot % 3 - 1;
        int z = slot / 3 - 1;
        switch (direction) {
            case 1: {
                return new Int3(x, 2, z);
            }
            case 2: {
                return new Int3(z, 2, -x);
            }
            case 3: {
                return new Int3(-x, 2, -z);
            }
            case 4: {
                return new Int3(-z, 2, x);
            }
        }
        return new Int3(0, 0, 0);
    }
}

