/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RitualEffectCrushing
extends RitualEffect {
    public static final int crystallosDrain = 10;
    public static final int orbisTerraeDrain = 10;
    public static final int potentiaDrain = 10;
    public static final int virtusDrain = 10;
    public static final int incendiumDrain = 10;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        int z;
        int y;
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        if (world.getWorldTime() % 10L != 5L) {
            return;
        }
        int x = ritualStone.getXCoord();
        TileEntity tile = world.getTileEntity(x, (y = ritualStone.getYCoord()) + 1, z = ritualStone.getZCoord());
        if (!(tile instanceof IInventory)) {
            return;
        }
        IInventory tileEntity = (IInventory)tile;
        if (tileEntity.getSizeInventory() <= 0) {
            return;
        }
        boolean hasRoom = false;
        for (int i = 0; i < tileEntity.getSizeInventory(); ++i) {
            if (tileEntity.getStackInSlot(i) != null) continue;
            hasRoom = true;
            break;
        }
        if (!hasRoom) {
            return;
        }
        boolean hasCrystallos = this.canDrainReagent(ritualStone, ReagentRegistry.crystallosReagent, 10, false);
        boolean hasOrbisTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 10, false);
        boolean hasPotentia = this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 10, false);
        boolean hasVirtus = this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, false);
        boolean hasIncendium = this.canDrainReagent(ritualStone, ReagentRegistry.incendiumReagent, 10, false);
        boolean isSilkTouch = hasCrystallos;
        int fortuneLevel = 0;
        if (hasOrbisTerrae) {
            ++fortuneLevel;
        }
        if (hasPotentia) {
            ++fortuneLevel;
        }
        if (hasVirtus) {
            ++fortuneLevel;
        }
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            for (int j = -3; j < 0; ++j) {
                for (int i = -1; i <= 1; ++i) {
                    for (int k = -1; k <= 1; ++k) {
                        Block block = world.getBlock(x + i, y + j, z + k);
                        int meta = world.getBlockMetadata(x + i, y + j, z + k);
                        if (block.getBlockHardness(world, x + i, y + j, z + k) == -1.0f || block == null || world.isAirBlock(x + i, y + j, z + k) || block.equals(ModBlocks.ritualStone) || block.equals(ModBlocks.blockMasterStone) || SpellHelper.isBlockFluid(block)) continue;
                        if (isSilkTouch && block.canSilkHarvest(world, null, x + i, y + j, z + k, meta)) {
                            ItemStack item = new ItemStack(block, 1, meta);
                            ItemStack copyStack = ItemStack.copyItemStack((ItemStack)item);
                            SpellHelper.insertStackIntoInventory(copyStack, tileEntity, ForgeDirection.DOWN);
                            if (copyStack.stackSize > 0) {
                                world.spawnEntityInWorld((Entity)new EntityItem(world, (double)x + 0.4, (double)(y + 2), (double)z + 0.5, copyStack));
                            }
                            if (hasCrystallos) {
                                this.canDrainReagent(ritualStone, ReagentRegistry.crystallosReagent, 10, true);
                            }
                        } else {
                            ArrayList itemDropList = block.getDrops(world, x + i, y + j, z + k, meta, fortuneLevel);
                            if (itemDropList != null) {
                                int invSize = tileEntity.getSizeInventory();
                                for (ItemStack item : itemDropList) {
                                    hasIncendium = hasIncendium && this.canDrainReagent(ritualStone, ReagentRegistry.incendiumReagent, 10, false);
                                    ItemStack copyStack = ItemStack.copyItemStack((ItemStack)item);
                                    if (this.usesIncendium(copyStack)) {
                                        copyStack = this.transformToNewItem(copyStack, hasIncendium, false);
                                        this.canDrainReagent(ritualStone, ReagentRegistry.incendiumReagent, 10, true);
                                    }
                                    SpellHelper.insertStackIntoInventory(copyStack, tileEntity, ForgeDirection.DOWN);
                                    if (copyStack.stackSize <= 0) continue;
                                    world.spawnEntityInWorld((Entity)new EntityItem(world, (double)x + 0.4, (double)(y + 2), (double)z + 0.5, copyStack));
                                }
                                if (hasOrbisTerrae) {
                                    this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 10, true);
                                }
                                if (hasPotentia) {
                                    this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 10, true);
                                }
                                if (hasVirtus) {
                                    this.canDrainReagent(ritualStone, ReagentRegistry.virtusReagent, 10, true);
                                }
                            }
                        }
                        world.setBlockToAir(x + i, y + j, z + k);
                        world.playSoundEffect((double)(x + i), (double)(y + j), (double)(z + k), "mob.endermen.portal", 1.0f, 1.0f);
                        SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
                        return;
                    }
                }
            }
        }
    }

    private boolean usesIncendium(ItemStack stack) {
        Block block;
        Item item;
        return stack != null && (item = stack.getItem()) instanceof ItemBlock && ((block = ((ItemBlock)item).field_150939_a) == Blocks.cobblestone || block == Blocks.stone);
    }

    private ItemStack transformToNewItem(ItemStack stack, boolean hasIncendium, boolean hasCrepitous) {
        if (stack != null) {
            ItemStack copyStack = ItemStack.copyItemStack((ItemStack)stack);
            int stackSize = copyStack.stackSize;
            Item item = stack.getItem();
            if (item instanceof ItemBlock) {
                Block block = ((ItemBlock)item).field_150939_a;
                if (hasIncendium && (block == Blocks.cobblestone || block == Blocks.stone)) {
                    copyStack = new ItemStack(Blocks.netherrack, stackSize, 0);
                }
            }
            return copyStack;
        }
        return stack;
    }

    public boolean isSilkTouch(World world, int x, int y, int z) {
        int index = 0;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                Block block;
                int index1 = Math.abs(i);
                int index2 = Math.abs(j);
                if ((index1 != 2 || index2 != 2 && index2 != 1) && (index1 != 1 || index2 != 2) || (block = world.getBlock(x + i, y + 1, z + j)) != Blocks.gold_block) continue;
                ++index;
            }
        }
        return index >= 12;
    }

    public int getFortuneLevel(World world, int x, int y, int z) {
        int index = 0;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                Block block;
                int index1 = Math.abs(i);
                int index2 = Math.abs(j);
                if ((index1 != 2 || index2 != 2 && index2 != 1) && (index1 != 1 || index2 != 2) || (block = world.getBlock(x + i, y + 1, z + j)) != Blocks.emerald_block && block != Blocks.diamond_block) continue;
                ++index;
            }
        }
        if (index >= 12) {
            return 3;
        }
        if (index >= 8) {
            return 2;
        }
        if (index >= 4) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostCrusher[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> crushingRitual = new ArrayList<RitualComponent>();
        crushingRitual.add(new RitualComponent(0, 0, 1, 3));
        crushingRitual.add(new RitualComponent(1, 0, 0, 3));
        crushingRitual.add(new RitualComponent(0, 0, -1, 3));
        crushingRitual.add(new RitualComponent(-1, 0, 0, 3));
        crushingRitual.add(new RitualComponent(2, 0, 0, 2));
        crushingRitual.add(new RitualComponent(0, 0, 2, 2));
        crushingRitual.add(new RitualComponent(-2, 0, 0, 2));
        crushingRitual.add(new RitualComponent(0, 0, -2, 2));
        crushingRitual.add(new RitualComponent(2, 0, 2, 5));
        crushingRitual.add(new RitualComponent(2, 0, -2, 5));
        crushingRitual.add(new RitualComponent(-2, 0, 2, 5));
        crushingRitual.add(new RitualComponent(-2, 0, -2, 5));
        crushingRitual.add(new RitualComponent(2, 1, 0, 4));
        crushingRitual.add(new RitualComponent(-2, 1, 0, 4));
        crushingRitual.add(new RitualComponent(0, 1, 2, 4));
        crushingRitual.add(new RitualComponent(0, 1, -2, 4));
        return crushingRitual;
    }
}

