/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class RitualEffectFlight
extends RitualEffect {
    public static final int aetherDrain = 10;
    public static final int reductusDrain = 5;
    public static final int reagentCooldown = 50;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        int range = 20;
        int verticalRange = 30;
        AxisAlignedBB axis = AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).expand((double)range, (double)verticalRange, (double)range);
        axis.maxY = 256.0;
        axis.minY = 0.0;
        List entities = world.getEntitiesWithinAABB(EntityPlayer.class, axis);
        int entityCount = 0;
        boolean hasAether = this.canDrainReagent(ritualStone, ReagentRegistry.aetherReagent, 10, false);
        boolean hasReductus = this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 5, false);
        for (EntityPlayer entity : entities) {
            ++entityCount;
        }
        if (currentEssence < this.getCostPerRefresh() * entityCount) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            entityCount = 0;
            EntityPlayer ownerEntity = SpellHelper.getPlayerForUsername(owner);
            for (EntityPlayer entity : entities) {
                if (hasReductus && entity != ownerEntity) continue;
                entity.addPotionEffect(new PotionEffect(AlchemicalWizardry.customPotionFlight.id, hasAether ? 600 : 20, 0));
                ++entityCount;
            }
            if (entityCount > 0 && world.getWorldTime() % 50L == 0L) {
                if (hasAether) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.aetherReagent, 10, true);
                }
                if (hasReductus) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 5, true);
                }
            }
            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh() * entityCount);
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostCondor[1];
    }

    @Override
    public int getInitialCooldown() {
        return 1;
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        int i;
        ArrayList<RitualComponent> flightRitual = new ArrayList<RitualComponent>();
        flightRitual.add(new RitualComponent(1, 0, 0, 5));
        flightRitual.add(new RitualComponent(-1, 0, 0, 5));
        flightRitual.add(new RitualComponent(0, 0, 1, 5));
        flightRitual.add(new RitualComponent(0, 0, -1, 5));
        flightRitual.add(new RitualComponent(2, 0, 2, 4));
        flightRitual.add(new RitualComponent(-2, 0, 2, 4));
        flightRitual.add(new RitualComponent(-2, 0, -2, 4));
        flightRitual.add(new RitualComponent(2, 0, -2, 4));
        flightRitual.add(new RitualComponent(1, 0, 3, 3));
        flightRitual.add(new RitualComponent(0, 0, 3, 3));
        flightRitual.add(new RitualComponent(-1, 0, 3, 3));
        flightRitual.add(new RitualComponent(1, 0, -3, 3));
        flightRitual.add(new RitualComponent(0, 0, -3, 3));
        flightRitual.add(new RitualComponent(-1, 0, -3, 3));
        flightRitual.add(new RitualComponent(3, 0, 1, 3));
        flightRitual.add(new RitualComponent(3, 0, 0, 3));
        flightRitual.add(new RitualComponent(3, 0, -1, 3));
        flightRitual.add(new RitualComponent(-3, 0, 1, 3));
        flightRitual.add(new RitualComponent(-3, 0, 0, 3));
        flightRitual.add(new RitualComponent(-3, 0, -1, 3));
        flightRitual.add(new RitualComponent(-3, 0, -4, 1));
        flightRitual.add(new RitualComponent(-4, 0, -3, 1));
        flightRitual.add(new RitualComponent(-3, 0, 4, 1));
        flightRitual.add(new RitualComponent(4, 0, -3, 1));
        flightRitual.add(new RitualComponent(3, 0, -4, 1));
        flightRitual.add(new RitualComponent(-4, 0, 3, 1));
        flightRitual.add(new RitualComponent(3, 0, 4, 1));
        flightRitual.add(new RitualComponent(4, 0, 3, 1));
        flightRitual.add(new RitualComponent(-1, 1, 0, 2));
        flightRitual.add(new RitualComponent(1, 1, 0, 2));
        flightRitual.add(new RitualComponent(0, 1, -1, 2));
        flightRitual.add(new RitualComponent(0, 1, 1, 2));
        flightRitual.add(new RitualComponent(-2, 1, 0, 0));
        flightRitual.add(new RitualComponent(2, 1, 0, 0));
        flightRitual.add(new RitualComponent(0, 1, -2, 0));
        flightRitual.add(new RitualComponent(0, 1, 2, 0));
        flightRitual.add(new RitualComponent(-4, 1, 0, 0));
        flightRitual.add(new RitualComponent(4, 1, 0, 0));
        flightRitual.add(new RitualComponent(0, 1, -4, 0));
        flightRitual.add(new RitualComponent(0, 1, 4, 0));
        flightRitual.add(new RitualComponent(-5, 1, 0, 4));
        flightRitual.add(new RitualComponent(5, 1, 0, 4));
        flightRitual.add(new RitualComponent(0, 1, -5, 4));
        flightRitual.add(new RitualComponent(0, 1, 5, 4));
        flightRitual.add(new RitualComponent(5, 0, 0, 5));
        flightRitual.add(new RitualComponent(-5, 0, 0, 5));
        flightRitual.add(new RitualComponent(0, 0, 5, 5));
        flightRitual.add(new RitualComponent(0, 0, -5, 5));
        for (i = 2; i <= 4; ++i) {
            flightRitual.add(new RitualComponent(-i, 2, 0, 3));
            flightRitual.add(new RitualComponent(i, 2, 0, 3));
            flightRitual.add(new RitualComponent(0, 2, -i, 3));
            flightRitual.add(new RitualComponent(0, 2, i, 3));
        }
        flightRitual.add(new RitualComponent(2, 4, 1, 2));
        flightRitual.add(new RitualComponent(1, 4, 2, 2));
        flightRitual.add(new RitualComponent(-2, 4, 1, 2));
        flightRitual.add(new RitualComponent(1, 4, -2, 2));
        flightRitual.add(new RitualComponent(2, 4, -1, 2));
        flightRitual.add(new RitualComponent(-1, 4, 2, 2));
        flightRitual.add(new RitualComponent(-2, 4, -1, 2));
        flightRitual.add(new RitualComponent(-1, 4, -2, 2));
        flightRitual.add(new RitualComponent(2, 4, 2, 4));
        flightRitual.add(new RitualComponent(-2, 4, 2, 4));
        flightRitual.add(new RitualComponent(2, 4, -2, 4));
        flightRitual.add(new RitualComponent(-2, 4, -2, 4));
        flightRitual.add(new RitualComponent(-4, 2, -4, 2));
        flightRitual.add(new RitualComponent(4, 2, 4, 2));
        flightRitual.add(new RitualComponent(4, 2, -4, 2));
        flightRitual.add(new RitualComponent(-4, 2, 4, 2));
        for (i = -1; i <= 1; ++i) {
            flightRitual.add(new RitualComponent(3, 4, i, 3));
            flightRitual.add(new RitualComponent(-3, 4, i, 3));
            flightRitual.add(new RitualComponent(i, 4, 3, 3));
            flightRitual.add(new RitualComponent(i, 4, -3, 3));
        }
        return flightRitual;
    }
}

