/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RitualEffectItemSuction
extends RitualEffect {
    public static final int reductusDrain = 1;
    public static final int timeDelayMin = 60;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        int z;
        int y;
        int x;
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        TileEntity tile = world.getTileEntity(x = ritualStone.getXCoord(), (y = ritualStone.getYCoord()) + 1, z = ritualStone.getZCoord());
        if (!(tile instanceof IInventory)) {
            return;
        }
        IInventory tileEntity = (IInventory)tile;
        if (tileEntity.getSizeInventory() <= 0) {
            return;
        }
        if (currentEssence < this.getCostPerRefresh() * 100) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            List<EntityItem> itemDropList = SpellHelper.getItemsInRange(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, 10.0, 10.0);
            boolean hasReductus = this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 1, false);
            int count = 0;
            if (itemDropList != null) {
                int invSize = tileEntity.getSizeInventory();
                for (EntityItem itemEntity : itemDropList) {
                    boolean bl = hasReductus = hasReductus && this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 1, false);
                    if (hasReductus) {
                        if (itemEntity.age < 60) continue;
                    }
                    ItemStack item = itemEntity.getEntityItem();
                    ItemStack copyStack = itemEntity.getEntityItem().copy();
                    int pastAmount = copyStack.stackSize;
                    ItemStack newStack = SpellHelper.insertStackIntoInventory(copyStack, tileEntity, ForgeDirection.DOWN);
                    if (newStack == null || newStack.stackSize >= pastAmount) continue;
                    ++count;
                    if (newStack.stackSize <= 0) {
                        itemEntity.setDead();
                        itemEntity.getEntityItem().stackSize = newStack.stackSize;
                    }
                    if (newStack.stackSize > 0) {
                        itemEntity.getEntityItem().stackSize = newStack.stackSize;
                    }
                    if (!hasReductus) continue;
                    this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 1, true);
                }
            }
            if (count > 0) {
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh() * Math.min(count, 100));
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostZephyr[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> suctionRitual = new ArrayList<RitualComponent>();
        suctionRitual.add(new RitualComponent(2, 0, 0, 4));
        suctionRitual.add(new RitualComponent(-2, 0, 0, 4));
        suctionRitual.add(new RitualComponent(0, 0, 2, 4));
        suctionRitual.add(new RitualComponent(0, 0, -2, 4));
        suctionRitual.add(new RitualComponent(1, 1, 1, 4));
        suctionRitual.add(new RitualComponent(1, 1, -1, 4));
        suctionRitual.add(new RitualComponent(-1, 1, 1, 4));
        suctionRitual.add(new RitualComponent(-1, 1, -1, 4));
        suctionRitual.add(new RitualComponent(1, -1, 0, 4));
        suctionRitual.add(new RitualComponent(-1, -1, 0, 4));
        suctionRitual.add(new RitualComponent(0, -1, 1, 4));
        suctionRitual.add(new RitualComponent(0, -1, -1, 4));
        return suctionRitual;
    }
}

