/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.common.omega.OmegaParadigm;
import WayofTime.alchemicalWizardry.common.omega.OmegaRegistry;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.world.World;

public class RitualEffectOmegaStalling
extends RitualEffect {
    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        int levels;
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (world.getWorldTime() % 20L != 0L) {
            return;
        }
        TileEntity tile = world.getTileEntity(x, y + 5, z);
        if (tile instanceof TileEntityBeacon && (levels = ((TileEntityBeacon)tile).getLevels()) >= 4) {
            int horizontalRadius = 100;
            int verticalRadius = 100;
            List<EntityPlayer> playerList = SpellHelper.getPlayersInRange(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, horizontalRadius, verticalRadius);
            for (EntityPlayer player : playerList) {
                Reagent reagent;
                OmegaParadigm parad;
                if (!SoulNetworkHandler.canSyphonFromOnlyNetwork(owner, this.getCostPerRefresh()) || (parad = OmegaRegistry.getParadigmForReagent(reagent = APISpellHelper.getPlayerReagentType(player))) == null) continue;
                float costOffset = parad.getCostPerTickOfUse(player);
                parad.setOmegaStalling(player, 100);
                SoulNetworkHandler.syphonFromNetwork(owner, (int)((float)this.getCostPerRefresh() * Math.min(costOffset, 1.0f)));
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostStalling[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> omegaRitual = new ArrayList<RitualComponent>();
        this.addCornerRunes(omegaRitual, 1, 0, 2);
        this.addOffsetRunes(omegaRitual, 2, 1, 0, 5);
        this.addParallelRunes(omegaRitual, 4, 0, 1);
        this.addParallelRunes(omegaRitual, 5, 0, 3);
        this.addCornerRunes(omegaRitual, 4, 0, 4);
        this.addOffsetRunes(omegaRitual, 3, 4, 0, 4);
        this.addParallelRunes(omegaRitual, 5, 1, 1);
        this.addParallelRunes(omegaRitual, 5, 2, 3);
        this.addParallelRunes(omegaRitual, 4, 3, 1);
        this.addParallelRunes(omegaRitual, 4, 4, 1);
        this.addParallelRunes(omegaRitual, 3, 5, 0);
        this.addParallelRunes(omegaRitual, 2, 5, 2);
        this.addParallelRunes(omegaRitual, 1, 5, 6);
        this.addOffsetRunes(omegaRitual, 5, 3, 1, 1);
        this.addOffsetRunes(omegaRitual, 6, 3, 1, 5);
        this.addOffsetRunes(omegaRitual, 6, 4, 1, 2);
        this.addOffsetRunes(omegaRitual, 6, 5, 1, 0);
        this.addCornerRunes(omegaRitual, 4, 2, 2);
        this.addCornerRunes(omegaRitual, 4, 3, 4);
        this.addCornerRunes(omegaRitual, 4, 4, 4);
        this.addOffsetRunes(omegaRitual, 4, 3, 2, 0);
        this.addCornerRunes(omegaRitual, 3, 5, 3);
        this.addOffsetRunes(omegaRitual, 2, 3, 5, 4);
        return omegaRitual;
    }
}

