/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.earth;

import WayofTime.alchemicalWizardry.api.spell.MeleeSpellCenteredWorldEffect;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MeleeEnvironmentalEarth
extends MeleeSpellCenteredWorldEffect {
    public MeleeEnvironmentalEarth(int power, int potency, int cost) {
        super(power, potency, cost);
        this.setRange(3 * power + 2);
    }

    @Override
    public void onCenteredWorldEffect(EntityPlayer player, World world, int posX, int posY, int posZ) {
        int radius = this.potencyUpgrades;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    ItemStack stack;
                    ItemStack dustStack;
                    if (world.isAirBlock(posX + i, posY + j, posZ + k) || world.getTileEntity(posX + i, posY + j, posZ + k) != null || (dustStack = SpellHelper.getDustForOre(stack = new ItemStack(world.getBlock(posX + i, posY + j, posZ + k), 1, world.getBlockMetadata(posX + i, posY + j, posZ + k)))) == null) continue;
                    dustStack.stackSize *= 3;
                    world.spawnEntityInWorld((Entity)new EntityItem(world, (double)posX, (double)posY, (double)posZ, dustStack));
                    world.setBlockToAir(posX + i, posY + j, posZ + k);
                }
            }
        }
    }
}

