/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.wind;

import WayofTime.alchemicalWizardry.api.spell.ExtrapolatedMeleeEntityEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class MeleeOffensiveWind
extends ExtrapolatedMeleeEntityEffect {
    public MeleeOffensiveWind(int power, int potency, int cost) {
        super(power, potency, cost);
        this.setRange(3.0f + 0.3f * (float)potency);
        this.setRadius(2.0f + 0.3f * (float)potency);
        this.setMaxNumberHit(potency + 1);
    }

    @Override
    protected boolean entityEffect(World world, Entity entity, EntityPlayer player) {
        double wantedVel = 1.0 + 1.0 * (double)this.powerUpgrades;
        if (entity instanceof EntityLivingBase) {
            double dist = Math.sqrt(entity.getDistanceToEntity((Entity)player));
            double xVel = wantedVel * (entity.posX - player.posX) / dist;
            double yVel = wantedVel * (entity.posY - player.posY + 0.5) / dist;
            double zVel = wantedVel * (entity.posZ - player.posZ) / dist;
            entity.motionX = xVel;
            entity.motionY = yVel;
            entity.motionZ = zVel;
            return true;
        }
        return false;
    }
}

