/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipeRegistry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.bloodAltarUpgrade.AltarUpgradeComponent;
import WayofTime.alchemicalWizardry.common.bloodAltarUpgrade.UpgradedAltars;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEInventory;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TEAltar
extends TEInventory
implements IFluidTank,
IFluidHandler,
IBloodAltar {
    public static final int sizeInv = 1;
    private int resultID = 0;
    private int resultDamage = 0;
    private int upgradeLevel = 0;
    protected FluidStack fluid = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    public int capacity = 10000;
    private boolean isActive = false;
    private int liquidRequired;
    private boolean canBeFilled;
    private int consumptionRate = 0;
    private int drainRate = 0;
    private float consumptionMultiplier = 0.0f;
    private float efficiencyMultiplier = 0.0f;
    private float sacrificeEfficiencyMultiplier;
    private float selfSacrificeEfficiencyMultiplier;
    private float capacityMultiplier = 1.0f;
    private float orbCapacityMultiplier;
    private float dislocationMultiplier;
    private int accelerationUpgrades;
    private boolean isUpgraded = false;
    private boolean isResultBlock = false;
    private int bufferCapacity = 1000;
    protected FluidStack fluidOutput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    protected FluidStack fluidInput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    private int progress = 0;
    private int lockdownDuration = 0;
    private int demonBloodDuration = 0;
    private int cooldownAfterCrafting = 500;

    public TEAltar() {
        super(1);
    }

    public int fillMainTank(int amount) {
        int filledAmount = Math.min(this.capacity - this.fluid.amount, amount);
        this.fluid.amount += filledAmount;
        return filledAmount;
    }

    public int getRSPowerOutput() {
        return 5;
    }

    @Override
    public void addToDemonBloodDuration(int dur) {
        this.demonBloodDuration += dur;
    }

    @Override
    public boolean hasDemonBlood() {
        return this.demonBloodDuration > 0;
    }

    @Override
    public void decrementDemonBlood() {
        this.demonBloodDuration = Math.max(0, this.demonBloodDuration - 1);
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        this.resultID = par1NBTTagCompound.getInteger("resultID");
        this.resultDamage = par1NBTTagCompound.getInteger("resultDamage");
        if (!par1NBTTagCompound.hasKey("Empty")) {
            FluidStack fluidIn;
            FluidStack fluidOut;
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)par1NBTTagCompound);
            if (fluid != null) {
                this.setMainFluid(fluid);
            }
            if ((fluidOut = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, par1NBTTagCompound.getInteger("outputAmount"))) != null) {
                this.setOutputFluid(fluidOut);
            }
            if ((fluidIn = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, par1NBTTagCompound.getInteger("inputAmount"))) != null) {
                this.setInputFluid(fluidIn);
            }
        }
        this.upgradeLevel = par1NBTTagCompound.getInteger("upgradeLevel");
        this.isActive = par1NBTTagCompound.getBoolean("isActive");
        this.liquidRequired = par1NBTTagCompound.getInteger("liquidRequired");
        this.canBeFilled = par1NBTTagCompound.getBoolean("canBeFilled");
        this.isUpgraded = par1NBTTagCompound.getBoolean("isUpgraded");
        this.consumptionRate = par1NBTTagCompound.getInteger("consumptionRate");
        this.drainRate = par1NBTTagCompound.getInteger("drainRate");
        this.consumptionMultiplier = par1NBTTagCompound.getFloat("consumptionMultiplier");
        this.efficiencyMultiplier = par1NBTTagCompound.getFloat("efficiencyMultiplier");
        this.selfSacrificeEfficiencyMultiplier = par1NBTTagCompound.getFloat("selfSacrificeEfficiencyMultiplier");
        this.sacrificeEfficiencyMultiplier = par1NBTTagCompound.getFloat("sacrificeEfficiencyMultiplier");
        this.capacityMultiplier = par1NBTTagCompound.getFloat("capacityMultiplier");
        this.orbCapacityMultiplier = par1NBTTagCompound.getFloat("orbCapacityMultiplier");
        this.dislocationMultiplier = par1NBTTagCompound.getFloat("dislocationMultiplier");
        this.capacity = par1NBTTagCompound.getInteger("capacity");
        this.bufferCapacity = par1NBTTagCompound.getInteger("bufferCapacity");
        this.progress = par1NBTTagCompound.getInteger("progress");
        this.isResultBlock = par1NBTTagCompound.getBoolean("isResultBlock");
        this.lockdownDuration = par1NBTTagCompound.getInteger("lockdownDuration");
        this.accelerationUpgrades = par1NBTTagCompound.getInteger("accelerationUpgrades");
        this.demonBloodDuration = par1NBTTagCompound.getInteger("demonBloodDuration");
        this.cooldownAfterCrafting = par1NBTTagCompound.getInteger("cooldownAfterCrafting");
    }

    public void setMainFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setOutputFluid(FluidStack fluid) {
        this.fluidOutput = fluid;
    }

    public void setInputFluid(FluidStack fluid) {
        this.fluidInput = fluid;
    }

    @Override
    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("resultID", this.resultID);
        par1NBTTagCompound.setInteger("resultDamage", this.resultDamage);
        if (this.fluid != null) {
            this.fluid.writeToNBT(par1NBTTagCompound);
        } else {
            par1NBTTagCompound.setString("Empty", "");
        }
        if (this.fluidOutput != null) {
            par1NBTTagCompound.setInteger("outputAmount", this.fluidOutput.amount);
        }
        if (this.fluidInput != null) {
            par1NBTTagCompound.setInteger("inputAmount", this.fluidInput.amount);
        }
        par1NBTTagCompound.setInteger("upgradeLevel", this.upgradeLevel);
        par1NBTTagCompound.setBoolean("isActive", this.isActive);
        par1NBTTagCompound.setInteger("liquidRequired", this.liquidRequired);
        par1NBTTagCompound.setBoolean("canBeFilled", this.canBeFilled);
        par1NBTTagCompound.setBoolean("isUpgraded", this.isUpgraded);
        par1NBTTagCompound.setInteger("consumptionRate", this.consumptionRate);
        par1NBTTagCompound.setInteger("drainRate", this.drainRate);
        par1NBTTagCompound.setFloat("consumptionMultiplier", this.consumptionMultiplier);
        par1NBTTagCompound.setFloat("efficiencyMultiplier", this.efficiencyMultiplier);
        par1NBTTagCompound.setFloat("sacrificeEfficiencyMultiplier", this.sacrificeEfficiencyMultiplier);
        par1NBTTagCompound.setFloat("selfSacrificeEfficiencyMultiplier", this.selfSacrificeEfficiencyMultiplier);
        par1NBTTagCompound.setBoolean("isResultBlock", this.isResultBlock);
        par1NBTTagCompound.setFloat("capacityMultiplier", this.capacityMultiplier);
        par1NBTTagCompound.setFloat("orbCapacityMultiplier", this.orbCapacityMultiplier);
        par1NBTTagCompound.setFloat("dislocationMultiplier", this.dislocationMultiplier);
        par1NBTTagCompound.setInteger("capacity", this.capacity);
        par1NBTTagCompound.setInteger("progress", this.progress);
        par1NBTTagCompound.setInteger("bufferCapacity", this.bufferCapacity);
        par1NBTTagCompound.setInteger("lockdownDuration", this.lockdownDuration);
        par1NBTTagCompound.setInteger("accelerationUpgrades", this.accelerationUpgrades);
        par1NBTTagCompound.setInteger("demonBloodDuration", this.demonBloodDuration);
        par1NBTTagCompound.setInteger("cooldownAfterCrafting", this.cooldownAfterCrafting);
    }

    @Override
    public String getInventoryName() {
        return "TEAltar";
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getCurrentBlood() {
        return this.getFluidAmount();
    }

    @Override
    public int getTier() {
        return this.upgradeLevel;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public float getSacrificeMultiplier() {
        return this.sacrificeEfficiencyMultiplier;
    }

    @Override
    public float getSelfSacrificeMultiplier() {
        return this.selfSacrificeEfficiencyMultiplier;
    }

    @Override
    public float getOrbMultiplier() {
        return this.orbCapacityMultiplier;
    }

    @Override
    public float getDislocationMultiplier() {
        return this.dislocationMultiplier;
    }

    @Override
    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        TEAltar tile = this;
        if (resource == null) {
            return 0;
        }
        if (resource.getFluidID() != new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 1).getFluidID()) {
            return 0;
        }
        if (!doFill) {
            if (this.fluidInput == null) {
                return Math.min(this.bufferCapacity, resource.amount);
            }
            if (!this.fluidInput.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.bufferCapacity - this.fluidInput.amount, resource.amount);
        }
        if (this.fluidInput == null) {
            this.fluidInput = new FluidStack(resource, Math.min(this.bufferCapacity, resource.amount));
            if (tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluidInput, tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord, (IFluidTank)this));
            }
            return this.fluidInput.amount;
        }
        if (!this.fluidInput.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.bufferCapacity - this.fluidInput.amount;
        if (resource.amount < filled) {
            this.fluidInput.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluidInput.amount = this.bufferCapacity;
        }
        if (tile != null) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluidInput, tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord, (IFluidTank)this));
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluidOutput == null) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluidOutput.amount < drained) {
            drained = this.fluidOutput.amount;
        }
        FluidStack stack = new FluidStack(this.fluidOutput, drained);
        if (doDrain) {
            this.fluidOutput.amount -= drained;
            if (this.fluidOutput.amount <= 0) {
                this.fluidOutput = null;
            }
            if (this != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluidOutput, this.worldObj, this.xCoord, this.yCoord, this.zCoord, (IFluidTank)this));
            }
        }
        if (this.fluidOutput == null) {
            this.fluidOutput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
        }
        if (this.worldObj != null) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        return stack;
    }

    public void updateEntity() {
        this.decrementDemonBlood();
        if (this.hasDemonBlood() && !this.worldObj.isRemote) {
            SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 1, this.xCoord, this.yCoord, this.zCoord);
        }
        if (this.lockdownDuration > 0) {
            --this.lockdownDuration;
        }
        if (this.worldObj.isRemote) {
            return;
        }
        if (!this.worldObj.isRemote && this.worldObj.getWorldTime() % 20L == 0L) {
            Block block = this.worldObj.getBlock(this.xCoord + 1, this.yCoord, this.zCoord);
            block.onNeighborBlockChange(this.worldObj, this.xCoord + 1, this.yCoord, this.zCoord, block);
            block = this.worldObj.getBlock(this.xCoord - 1, this.yCoord, this.zCoord);
            block.onNeighborBlockChange(this.worldObj, this.xCoord - 1, this.yCoord, this.zCoord, block);
            block = this.worldObj.getBlock(this.xCoord, this.yCoord + 1, this.zCoord);
            block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord, block);
            block = this.worldObj.getBlock(this.xCoord, this.yCoord - 1, this.zCoord);
            block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord - 1, this.zCoord, block);
            block = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord + 1);
            block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord, this.zCoord + 1, block);
            block = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord - 1);
            block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord, this.zCoord - 1, block);
            if (AlchemicalWizardry.lockdownAltar) {
                List<EntityPlayer> list = SpellHelper.getPlayersInRange(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 15.0, 15.0);
                for (EntityPlayer player : list) {
                    PotionEffect regenEffect = player.getActivePotionEffect(Potion.regeneration);
                    if (regenEffect == null || regenEffect.getAmplifier() < 2) continue;
                    this.lockdownDuration += 20;
                }
            }
        }
        if (this.worldObj.getWorldTime() % (long)Math.max(20 - this.accelerationUpgrades, 1) == 0L) {
            int syphonMax = (int)(20.0f * this.dislocationMultiplier);
            int fluidInputted = 0;
            int fluidOutputted = 0;
            fluidInputted = Math.min(syphonMax, -this.fluid.amount + this.capacity);
            fluidInputted = Math.min(this.fluidInput.amount, fluidInputted);
            this.fluid.amount += fluidInputted;
            this.fluidInput.amount -= fluidInputted;
            fluidOutputted = Math.min(syphonMax, this.bufferCapacity - this.fluidOutput.amount);
            fluidOutputted = Math.min(this.fluid.amount, fluidOutputted);
            this.fluidOutput.amount += fluidOutputted;
            this.fluid.amount -= fluidOutputted;
        }
        if (this.worldObj.getWorldTime() % 100L == 0L && (this.isActive || this.cooldownAfterCrafting <= 0)) {
            this.startCycle();
        }
        if (!this.isActive) {
            if (this.cooldownAfterCrafting > 0) {
                --this.cooldownAfterCrafting;
            }
            return;
        }
        if (this.getStackInSlot(0) == null) {
            return;
        }
        int worldTime = (int)(this.worldObj.getWorldTime() % 24000L);
        if (this.worldObj.isRemote) {
            return;
        }
        if (!this.canBeFilled) {
            if (this.fluid != null && this.fluid.amount >= 1) {
                int stackSize = this.getStackInSlot((int)0).stackSize;
                int liquidDrained = Math.min((int)(this.upgradeLevel >= 2 ? (float)this.consumptionRate * (1.0f + this.consumptionMultiplier) : (float)this.consumptionRate), this.fluid.amount);
                if (liquidDrained > this.liquidRequired * stackSize - this.progress) {
                    liquidDrained = this.liquidRequired * stackSize - this.progress;
                }
                this.fluid.amount -= liquidDrained;
                this.progress += liquidDrained;
                if (worldTime % 4 == 0) {
                    SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 1, this.xCoord, this.yCoord, this.zCoord);
                }
                if (this.progress >= this.liquidRequired * stackSize) {
                    ItemStack result = AltarRecipeRegistry.getItemForItemAndTier(this.getStackInSlot(0), this.upgradeLevel);
                    if (result != null) {
                        result.stackSize *= stackSize;
                    }
                    this.setInventorySlotContents(0, result);
                    this.progress = 0;
                    for (int i = 0; i < 8; ++i) {
                        SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 4, (float)this.xCoord + 0.5f, (float)this.yCoord + 1.0f, (float)this.zCoord + 0.5f);
                    }
                    this.isActive = false;
                }
            } else if (this.progress > 0) {
                this.progress -= (int)(this.efficiencyMultiplier * (float)this.drainRate);
                if (worldTime % 2 == 0) {
                    SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 2, this.xCoord, this.yCoord, this.zCoord);
                }
            }
        } else {
            ItemStack returnedItem = this.getStackInSlot(0);
            if (!(returnedItem.getItem() instanceof IBloodOrb)) {
                return;
            }
            IBloodOrb item = (IBloodOrb)returnedItem.getItem();
            NBTTagCompound itemTag = returnedItem.getTagCompound();
            if (itemTag == null) {
                return;
            }
            String ownerName = itemTag.getString("ownerName");
            if (ownerName.equals("")) {
                return;
            }
            if (this.fluid != null && this.fluid.amount >= 1) {
                int liquidDrained = Math.min((int)(this.upgradeLevel >= 2 ? (float)this.consumptionRate * (1.0f + this.consumptionMultiplier) : (float)this.consumptionRate), this.fluid.amount);
                int drain = SoulNetworkHandler.addCurrentEssenceToMaximum(ownerName, liquidDrained, (int)((float)item.getMaxEssence() * this.orbCapacityMultiplier));
                this.fluid.amount -= drain;
                if (worldTime % 4 == 0) {
                    SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 3, this.xCoord, this.yCoord, this.zCoord);
                }
            }
        }
        if (this.worldObj != null) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public void setActive() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void sacrificialDaggerCall(int amount, boolean isSacrifice) {
        if (!isSacrifice && this.lockdownDuration > 0) {
            int amt = (int)Math.min((float)(this.bufferCapacity - this.fluidInput.amount), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount);
            this.fluidInput.amount += amt;
        } else {
            this.fluid.amount = (int)((float)this.fluid.amount + Math.min((float)(this.capacity - this.fluid.amount), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount));
        }
    }

    public Packet getDescriptionPacket() {
        return NewPacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData, int[] fluidData, int capacity) {
        if (intData == null) {
            return;
        }
        if (intData.length == 3) {
            for (int i = 0; i < 1; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.getItemById((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
        FluidStack flMain = new FluidStack(fluidData[0], fluidData[1]);
        FluidStack flIn = new FluidStack(fluidData[2], fluidData[3]);
        FluidStack flOut = new FluidStack(fluidData[4], fluidData[5]);
        this.setMainFluid(flMain);
        this.setInputFluid(flIn);
        this.setOutputFluid(flOut);
        this.capacity = capacity;
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[3];
        int pos = 0;
        for (ItemStack is : this.inv) {
            if (is != null) {
                sortList[pos++] = Item.getIdFromItem((Item)is.getItem());
                sortList[pos++] = is.getItemDamage();
                sortList[pos++] = is.stackSize;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    @Override
    public void startCycle() {
        if (this.worldObj != null) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        this.checkAndSetAltar();
        if (this.fluid == null || this.fluid.amount <= 0) {
            return;
        }
        if (!this.isActive) {
            this.progress = 0;
        }
        if (AltarRecipeRegistry.isRequiredItemValid(this.getStackInSlot(0), this.upgradeLevel)) {
            AltarRecipe recipe = AltarRecipeRegistry.getAltarRecipeForItemAndTier(this.getStackInSlot(0), this.upgradeLevel);
            this.isActive = true;
            this.liquidRequired = recipe.getLiquidRequired();
            this.canBeFilled = recipe.getCanBeFilled();
            this.consumptionRate = recipe.getConsumptionRate();
            this.drainRate = recipe.drainRate;
            return;
        }
        this.isActive = false;
    }

    public void checkAndSetAltar() {
        boolean checkUpgrade = true;
        int upgradeState = UpgradedAltars.isAltarValid(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        if (upgradeState <= 1) {
            this.upgradeLevel = 1;
            this.isUpgraded = false;
            this.consumptionMultiplier = 0.0f;
            this.efficiencyMultiplier = 1.0f;
            this.sacrificeEfficiencyMultiplier = 0.0f;
            this.selfSacrificeEfficiencyMultiplier = 0.0f;
            this.capacityMultiplier = 1.0f;
            this.orbCapacityMultiplier = 1.0f;
            this.dislocationMultiplier = 1.0f;
            this.accelerationUpgrades = 0;
            return;
        }
        AltarUpgradeComponent upgrades = UpgradedAltars.getUpgrades(this.worldObj, this.xCoord, this.yCoord, this.zCoord, upgradeState);
        if (upgrades == null) {
            this.upgradeLevel = 1;
            this.isUpgraded = false;
            this.consumptionMultiplier = 0.0f;
            this.efficiencyMultiplier = 1.0f;
            this.sacrificeEfficiencyMultiplier = 0.0f;
            this.selfSacrificeEfficiencyMultiplier = 0.0f;
            this.capacityMultiplier = 1.0f;
            this.orbCapacityMultiplier = 1.0f;
            this.dislocationMultiplier = 1.0f;
            this.upgradeLevel = upgradeState;
            this.accelerationUpgrades = 0;
            return;
        }
        this.isUpgraded = checkUpgrade;
        this.upgradeLevel = upgradeState;
        this.consumptionMultiplier = (float)(0.2 * (double)upgrades.getSpeedUpgrades());
        this.efficiencyMultiplier = (float)Math.pow(0.85, upgrades.getSpeedUpgrades());
        this.sacrificeEfficiencyMultiplier = (float)(0.1 * (double)upgrades.getSacrificeUpgrades());
        this.selfSacrificeEfficiencyMultiplier = (float)(0.1 * (double)upgrades.getSelfSacrificeUpgrades());
        this.capacityMultiplier = (float)(1.0 * Math.pow(1.1, upgrades.getBetterCapacitiveUpgrades()) + 0.2 * (double)upgrades.getAltarCapacitiveUpgrades());
        this.dislocationMultiplier = (float)Math.pow(1.2, upgrades.getDisplacementUpgrades());
        this.orbCapacityMultiplier = (float)(1.0 + 0.02 * (double)upgrades.getOrbCapacitiveUpgrades());
        this.capacity = (int)(10000.0f * this.capacityMultiplier);
        this.bufferCapacity = (int)(1000.0f * this.capacityMultiplier);
        this.accelerationUpgrades = upgrades.getAccelerationUpgrades();
        if (this.fluid.amount > this.capacity) {
            this.fluid.amount = this.capacity;
        }
        if (this.fluidOutput.amount > this.bufferCapacity) {
            this.fluidOutput.amount = this.bufferCapacity;
        }
        if (this.fluidInput.amount > this.bufferCapacity) {
            this.fluidInput.amount = this.bufferCapacity;
        }
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        resource = resource.copy();
        int totalUsed = 0;
        int used = this.fill(resource, doFill);
        resource.amount -= used;
        this.startCycle();
        return totalUsed += used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.fluidOutput)) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        return this.drain(maxEmpty, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fluidInput != null && this.fluid.getFluid().equals(this.fluidInput.getFluid());
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTank compositeTank = new FluidTank(this.capacity);
        compositeTank.setFluid(this.fluid);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public int[] buildFluidList() {
        int[] sortList = new int[6];
        if (this.fluid == null) {
            sortList[0] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[1] = 0;
        } else {
            sortList[0] = this.fluid.getFluidID();
            sortList[1] = this.fluid.amount;
        }
        if (this.fluidInput == null) {
            sortList[2] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[3] = 0;
        } else {
            sortList[2] = this.fluidInput.getFluidID();
            sortList[3] = this.fluidInput.amount;
        }
        if (this.fluidOutput == null) {
            sortList[4] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[5] = 0;
        } else {
            sortList[4] = this.fluidOutput.getFluidID();
            sortList[5] = this.fluidOutput.amount;
        }
        return sortList;
    }

    public void sendChatInfoToPlayer(EntityPlayer player) {
        player.addChatMessage((IChatComponent)new ChatComponentTranslation(String.format("message.altar.currentessence", new Object[0]), new Object[]{this.fluid.amount}));
        player.addChatMessage((IChatComponent)new ChatComponentTranslation(String.format("message.altar.currenttier", new Object[0]), new Object[]{UpgradedAltars.isAltarValid(this.worldObj, this.xCoord, this.yCoord, this.zCoord)}));
        player.addChatMessage((IChatComponent)new ChatComponentTranslation(String.format("message.altar.capacity", new Object[0]), new Object[]{this.getCapacity()}));
    }

    public void sendMoreChatInfoToPlayer(EntityPlayer player) {
        if (this.getStackInSlot(0) != null) {
            int stackSize = this.getStackInSlot((int)0).stackSize;
            player.addChatMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocal((String)"message.altar.progress") + " " + this.progress + "LP/" + this.liquidRequired * stackSize + "LP"));
            player.addChatMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocal((String)"message.altar.consumptionrate") + " " + (int)((float)this.consumptionRate * (1.0f + this.consumptionMultiplier)) + "LP/t"));
        }
        player.addChatMessage((IChatComponent)new ChatComponentTranslation(String.format("message.altar.currentessence", new Object[0]), new Object[]{this.fluid.amount}));
        player.addChatMessage((IChatComponent)new ChatComponentTranslation(String.format("message.altar.inputtank", new Object[0]), new Object[]{this.fluidInput.amount}));
        player.addChatMessage((IChatComponent)new ChatComponentTranslation(String.format("message.altar.outputtank", new Object[0]), new Object[]{this.fluidOutput.amount}));
    }

    @Override
    public void requestPauseAfterCrafting(int amount) {
        if (this.isActive) {
            this.cooldownAfterCrafting = amount;
        }
    }
}

