/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.common.spell.simple.HomSpell;
import WayofTime.alchemicalWizardry.common.spell.simple.HomSpellRegistry;
import WayofTime.alchemicalWizardry.common.tileEntity.TEAltar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.world.World;

public class TEHomHeart
extends TileEntity {
    public boolean canCastSpell(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return true;
    }

    public int getCostForSpell() {
        HomSpell spell = this.getSpell();
        if (spell != null) {
            switch (this.getModifiedParadigm()) {
                case 0: {
                    return spell.getOffensiveRangedEnergy();
                }
                case 1: {
                    return spell.getOffensiveMeleeEnergy();
                }
                case 2: {
                    return spell.getDefensiveEnergy();
                }
                case 3: {
                    return spell.getEnvironmentalEnergy();
                }
            }
        }
        return 0;
    }

    public int castSpell(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        HomSpell spell = this.getSpell();
        if (spell != null) {
            switch (this.getModifiedParadigm()) {
                case 0: {
                    spell.onOffensiveRangedRightClick(par1ItemStack, par2World, par3EntityPlayer);
                    return spell.getOffensiveRangedEnergy();
                }
                case 1: {
                    spell.onOffensiveMeleeRightClick(par1ItemStack, par2World, par3EntityPlayer);
                    return spell.getOffensiveMeleeEnergy();
                }
                case 2: {
                    spell.onDefensiveRightClick(par1ItemStack, par2World, par3EntityPlayer);
                    return spell.getDefensiveEnergy();
                }
                case 3: {
                    spell.onEnvironmentalRightClick(par1ItemStack, par2World, par3EntityPlayer);
                    return spell.getEnvironmentalEnergy();
                }
            }
        }
        return 0;
    }

    public HomSpell getSpell() {
        HomSpell spell;
        ItemStack itemStack;
        TileEntity tileEntity = this.worldObj.getTileEntity(this.xCoord - 1, this.yCoord, this.zCoord);
        if (tileEntity instanceof TEAltar && (itemStack = ((TEAltar)tileEntity).getStackInSlot(0)) != null && (spell = HomSpellRegistry.getSpellForItemStack(itemStack)) != null) {
            return spell;
        }
        tileEntity = this.worldObj.getTileEntity(this.xCoord + 1, this.yCoord, this.zCoord);
        if (tileEntity instanceof TEAltar && (itemStack = ((TEAltar)tileEntity).getStackInSlot(0)) != null && (spell = HomSpellRegistry.getSpellForItemStack(itemStack)) != null) {
            return spell;
        }
        tileEntity = this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord - 1);
        if (tileEntity instanceof TEAltar && (itemStack = ((TEAltar)tileEntity).getStackInSlot(0)) != null && (spell = HomSpellRegistry.getSpellForItemStack(itemStack)) != null) {
            return spell;
        }
        tileEntity = this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord + 1);
        if (tileEntity instanceof TEAltar && (itemStack = ((TEAltar)tileEntity).getStackInSlot(0)) != null && (spell = HomSpellRegistry.getSpellForItemStack(itemStack)) != null) {
            return spell;
        }
        return null;
    }

    public int getModifiedParadigm() {
        TileEntity tileEntity = this.worldObj.getTileEntity(this.xCoord, this.yCoord + 1, this.zCoord);
        if (tileEntity instanceof TileEntitySkull) {
            int skullType = ((TileEntitySkull)tileEntity).func_145904_a();
            switch (skullType) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
            }
        }
        return -1;
    }
}

