/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public abstract class TEInventory
extends TileEntity
implements IInventory {
    protected ItemStack[] inv;

    public TEInventory(int size) {
        this.inv = new ItemStack[size];
    }

    public int getSizeInventory() {
        return this.inv.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv[slot];
    }

    public ItemStack decrStackSize(int slot, int amt) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            if (stack.stackSize <= amt) {
                this.setInventorySlotContents(slot, null);
            } else {
                stack = stack.splitStack(amt);
                if (stack.stackSize == 0) {
                    this.setInventorySlotContents(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
    }

    public abstract String getInventoryName();

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this && player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) < 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.setByte("Slot", (byte)i);
            this.inv[i].writeToNBT(stackTag);
            invList.appendTag((NBTBase)stackTag);
        }
        tag.setTag("Inventory", (NBTBase)invList);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        NBTTagList invList = tag.getTagList("Inventory", 10);
        for (int i = 0; i < invList.tagCount(); ++i) {
            NBTTagCompound stackTag = invList.getCompoundTagAt(i);
            byte slot = stackTag.getByte("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)stackTag);
        }
    }

    public void clear() {
        this.inv = new ItemStack[this.inv.length];
    }
}

