/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.api.summoningRegistry.SummoningRegistry;
import WayofTime.alchemicalWizardry.api.summoningRegistry.SummoningRegistryComponent;
import WayofTime.alchemicalWizardry.common.IDemon;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.PlinthComponent;
import WayofTime.alchemicalWizardry.common.items.EnergyBattery;
import WayofTime.alchemicalWizardry.common.tileEntity.TEInventory;
import WayofTime.alchemicalWizardry.common.tileEntity.TEPedestal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

public class TEPlinth
extends TEInventory {
    public static final int sizeInv = 1;
    private boolean isActive = false;
    private boolean paradigm;
    private ItemStack[] ring1Inv = new ItemStack[6];
    private ItemStack[] ring2Inv = new ItemStack[6];
    private ItemStack[] ring3Inv = new ItemStack[6];
    private int progressInterval = 50;
    private int progress = 0;
    public static List<PlinthComponent> pedestalPositions = new ArrayList<PlinthComponent>();

    public TEPlinth() {
        super(1);
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        NBTTagList ring1TagList = par1NBTTagCompound.getTagList("ring1Inv", 10);
        for (int i = 0; i < ring1TagList.tagCount(); ++i) {
            NBTTagCompound tag = ring1TagList.getCompoundTagAt(i);
            byte slot = tag.getByte("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.ring1Inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag);
        }
        NBTTagList ring2TagList = par1NBTTagCompound.getTagList("ring2Inv", 10);
        for (int i = 0; i < ring2TagList.tagCount(); ++i) {
            NBTTagCompound tag = ring2TagList.getCompoundTagAt(i);
            byte slot = tag.getByte("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.ring2Inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag);
        }
        NBTTagList ring3TagList = par1NBTTagCompound.getTagList("ring3Inv", 10);
        for (int i = 0; i < ring3TagList.tagCount(); ++i) {
            NBTTagCompound tag = ring3TagList.getCompoundTagAt(i);
            byte slot = tag.getByte("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.ring3Inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag);
        }
        this.progress = par1NBTTagCompound.getInteger("progress");
        this.progressInterval = par1NBTTagCompound.getInteger("progressInterval");
        this.isActive = par1NBTTagCompound.getBoolean("isActive");
    }

    @Override
    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        NBTTagList ring1ItemList = new NBTTagList();
        for (int i = 0; i < this.ring1Inv.length; ++i) {
            if (this.ring1Inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.setByte("Slot", (byte)i);
            this.ring1Inv[i].writeToNBT(tag);
            ring1ItemList.appendTag((NBTBase)tag);
        }
        par1NBTTagCompound.setTag("ring1Inv", (NBTBase)ring1ItemList);
        NBTTagList ring2ItemList = new NBTTagList();
        for (int i = 0; i < this.ring2Inv.length; ++i) {
            if (this.ring2Inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.setByte("Slot", (byte)i);
            this.ring2Inv[i].writeToNBT(tag);
            ring2ItemList.appendTag((NBTBase)tag);
        }
        par1NBTTagCompound.setTag("ring2Inv", (NBTBase)ring1ItemList);
        NBTTagList ring3ItemList = new NBTTagList();
        for (int i = 0; i < this.ring3Inv.length; ++i) {
            if (this.ring3Inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.setByte("Slot", (byte)i);
            this.ring3Inv[i].writeToNBT(tag);
            ring3ItemList.appendTag((NBTBase)tag);
        }
        par1NBTTagCompound.setTag("ring3Inv", (NBTBase)ring1ItemList);
        par1NBTTagCompound.setInteger("progress", this.progress);
        par1NBTTagCompound.setInteger("progressInterval", this.progressInterval);
        par1NBTTagCompound.setBoolean("isActive", this.isActive);
    }

    @Override
    public String getInventoryName() {
        return "TEPlinth";
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (!this.isActive()) {
            if (this.getStackInSlot(0) != null && this.getStackInSlot(0).getItem() instanceof EnergyBattery) {
                int bloodOrbLevel = ((EnergyBattery)this.getStackInSlot(0).getItem()).getOrbLevel();
                if (SummoningRegistry.isRecipeValid(bloodOrbLevel, this.composeItemsForRingAndParadigm(1, true), this.composeItemsForRingAndParadigm(2, true), this.composeItemsForRingAndParadigm(3, true))) {
                    SummoningRegistryComponent src = SummoningRegistry.getRegistryComponent(bloodOrbLevel, this.composeItemsForRingAndParadigm(1, true), this.composeItemsForRingAndParadigm(2, true), this.composeItemsForRingAndParadigm(3, true));
                    this.isActive = true;
                    this.paradigm = true;
                    this.progress = 0;
                    this.ring1Inv = src.getRingRecipeForRing(1);
                    this.ring2Inv = src.getRingRecipeForRing(2);
                    this.ring3Inv = src.getRingRecipeForRing(3);
                } else if (SummoningRegistry.isRecipeValid(bloodOrbLevel, this.composeItemsForRingAndParadigm(1, false), this.composeItemsForRingAndParadigm(2, false), this.composeItemsForRingAndParadigm(3, false))) {
                    SummoningRegistryComponent src = SummoningRegistry.getRegistryComponent(bloodOrbLevel, this.composeItemsForRingAndParadigm(1, false), this.composeItemsForRingAndParadigm(2, false), this.composeItemsForRingAndParadigm(3, false));
                    this.isActive = true;
                    this.paradigm = false;
                    this.progress = 0;
                    this.ring1Inv = src.getRingRecipeForRing(1);
                    this.ring2Inv = src.getRingRecipeForRing(2);
                    this.ring3Inv = src.getRingRecipeForRing(3);
                } else {
                    this.isActive = false;
                    this.progress = 0;
                }
            }
        } else if (this.getStackInSlot(0) != null && this.getStackInSlot(0).getItem() instanceof EnergyBattery) {
            int bloodOrbLevel;
            EntityLivingBase entity;
            if (this.progress % this.progressInterval == 0) {
                ItemStack itemStack;
                int ring = this.progress / this.progressInterval / 6 + 1;
                int slot = this.progress / this.progressInterval % 6;
                switch (ring) {
                    case 1: {
                        itemStack = this.ring1Inv[slot];
                        break;
                    }
                    case 2: {
                        itemStack = this.ring2Inv[slot];
                        break;
                    }
                    case 3: {
                        itemStack = this.ring3Inv[slot];
                        break;
                    }
                    default: {
                        itemStack = null;
                    }
                }
                if (itemStack == null) {
                    this.progress += this.progressInterval;
                } else if (this.deleteItemStackInRing(ring, itemStack)) {
                    ++this.progress;
                }
            } else {
                ++this.progress;
            }
            if (this.progress >= this.progressInterval * 18 && (entity = SummoningRegistry.getEntity(this.worldObj, bloodOrbLevel = ((EnergyBattery)this.getStackInSlot(0).getItem()).getOrbLevel(), this.ring1Inv, this.ring2Inv, this.ring3Inv)) != null) {
                entity.setPosition((double)this.xCoord + 0.5, (double)(this.yCoord + 1), (double)this.zCoord + 0.5);
                this.worldObj.spawnEntityInWorld((Entity)entity);
                if (entity instanceof IDemon) {
                    ((IDemon)entity).setSummonedConditions();
                }
                this.worldObj.createExplosion((Entity)entity, entity.posX, entity.posY, entity.posZ, 3.0f, false);
                this.isActive = false;
                this.progress = 0;
                if (this.worldObj != null) {
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
            }
        }
    }

    public void deleteItemsInRing(int ring) {
        if (this.paradigm) {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.worldObj.getTileEntity(this.xCoord + pc.xOffset, this.yCoord + pc.yOffset, this.zCoord + pc.zOffset)) instanceof TEPedestal)) continue;
                ((TEPedestal)tileEntity).setInventorySlotContents(0, null);
                this.worldObj.markBlockForUpdate(this.xCoord + pc.xOffset, this.yCoord + pc.yOffset, this.zCoord + pc.zOffset);
                ++i;
            }
        } else {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.worldObj.getTileEntity(this.xCoord + pc.zOffset, this.yCoord + pc.yOffset, this.zCoord + pc.xOffset)) instanceof TEPedestal)) continue;
                ((TEPedestal)tileEntity).setInventorySlotContents(0, null);
                this.worldObj.markBlockForUpdate(this.xCoord + pc.zOffset, this.yCoord + pc.yOffset, this.zCoord + pc.xOffset);
                ++i;
            }
        }
    }

    public boolean deleteItemStackInRing(int ring, ItemStack itemStack) {
        if (itemStack == null) {
            return true;
        }
        if (this.paradigm) {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.worldObj.getTileEntity(this.xCoord + pc.xOffset, this.yCoord + pc.yOffset, this.zCoord + pc.zOffset)) instanceof TEPedestal)) continue;
                ItemStack possibleItem = ((TEPedestal)tileEntity).getStackInSlot(0);
                if (possibleItem == null) {
                    ++i;
                    continue;
                }
                boolean test = false;
                if (possibleItem.getItem() instanceof ItemBlock) {
                    if (itemStack.getItem() instanceof ItemBlock) {
                        test = true;
                    }
                } else if (!(itemStack.getItem() instanceof ItemBlock)) {
                    test = true;
                }
                if (test && itemStack.getItem() == possibleItem.getItem() && (itemStack.getItemDamage() == possibleItem.getItemDamage() || itemStack.getItemDamage() == Short.MAX_VALUE)) {
                    ((TEPedestal)tileEntity).decrStackSize(0, 1);
                    if (((TEPedestal)tileEntity).getStackInSlot(0) != null && ((TEPedestal)tileEntity).getStackInSlot((int)0).stackSize == 0) {
                        ((TEPedestal)tileEntity).setInventorySlotContents(0, null);
                    }
                    ((TEPedestal)tileEntity).onItemDeletion();
                    this.worldObj.markBlockForUpdate(this.xCoord + pc.xOffset, this.yCoord + pc.yOffset, this.zCoord + pc.zOffset);
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.worldObj.getTileEntity(this.xCoord + pc.zOffset, this.yCoord + pc.yOffset, this.zCoord + pc.xOffset)) instanceof TEPedestal)) continue;
                ItemStack possibleItem = ((TEPedestal)tileEntity).getStackInSlot(0);
                if (possibleItem == null) {
                    ++i;
                    continue;
                }
                boolean test = false;
                if (possibleItem.getItem() instanceof ItemBlock) {
                    if (itemStack.getItem() instanceof ItemBlock) {
                        test = true;
                    }
                } else if (!(itemStack.getItem() instanceof ItemBlock)) {
                    test = true;
                }
                if (test && itemStack.getItem() == possibleItem.getItem() && (itemStack.getItemDamage() == possibleItem.getItemDamage() || itemStack.getItemDamage() == Short.MAX_VALUE)) {
                    ((TEPedestal)tileEntity).decrStackSize(0, 1);
                    ((TEPedestal)tileEntity).onItemDeletion();
                    this.worldObj.markBlockForUpdate(this.xCoord + pc.zOffset, this.yCoord + pc.yOffset, this.zCoord + pc.zOffset);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public ItemStack[] composeItemsForRingAndParadigm(int ring, boolean paradigm) {
        ItemStack[] composed = new ItemStack[6];
        if (paradigm) {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.worldObj.getTileEntity(this.xCoord + pc.xOffset, this.yCoord + pc.yOffset, this.zCoord + pc.zOffset)) instanceof TEPedestal)) continue;
                composed[i] = ((TEPedestal)tileEntity).getStackInSlot(0);
                ++i;
            }
        } else {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.worldObj.getTileEntity(this.xCoord + pc.zOffset, this.yCoord + pc.yOffset, this.zCoord + pc.xOffset)) instanceof TEPedestal)) continue;
                composed[i] = ((TEPedestal)tileEntity).getStackInSlot(0);
                ++i;
            }
        }
        return composed;
    }

    public void setActive() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Packet getDescriptionPacket() {
        return NewPacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData) {
        if (intData == null) {
            return;
        }
        if (intData.length == 3) {
            for (int i = 0; i < 1; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.getItemById((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[3];
        int pos = 0;
        for (ItemStack is : this.inv) {
            if (is != null) {
                sortList[pos++] = Item.getIdFromItem((Item)is.getItem());
                sortList[pos++] = is.getItemDamage();
                sortList[pos++] = is.stackSize;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    public static void initialize() {
        pedestalPositions.add(new PlinthComponent(1, 0, -2, 1));
        pedestalPositions.add(new PlinthComponent(2, 0, 0, 1));
        pedestalPositions.add(new PlinthComponent(1, 0, 2, 1));
        pedestalPositions.add(new PlinthComponent(-1, 0, -2, 1));
        pedestalPositions.add(new PlinthComponent(-2, 0, 0, 1));
        pedestalPositions.add(new PlinthComponent(-1, 0, 2, 1));
        pedestalPositions.add(new PlinthComponent(3, 1, -5, 2));
        pedestalPositions.add(new PlinthComponent(6, 1, 0, 2));
        pedestalPositions.add(new PlinthComponent(3, 1, 5, 2));
        pedestalPositions.add(new PlinthComponent(-3, 1, -5, 2));
        pedestalPositions.add(new PlinthComponent(-6, 1, 0, 2));
        pedestalPositions.add(new PlinthComponent(-3, 1, 5, 2));
        pedestalPositions.add(new PlinthComponent(0, 2, -9, 3));
        pedestalPositions.add(new PlinthComponent(7, 2, -4, 3));
        pedestalPositions.add(new PlinthComponent(7, 2, 4, 3));
        pedestalPositions.add(new PlinthComponent(0, 2, 9, 3));
        pedestalPositions.add(new PlinthComponent(-7, 2, -4, 3));
        pedestalPositions.add(new PlinthComponent(-7, 2, 4, 3));
    }
}

