/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.api.ColourAndCoords;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.IReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.alchemy.energy.TileSegmentedReagentHandler;
import WayofTime.alchemicalWizardry.common.entity.projectile.EntityParticleBeam;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TEReagentConduit
extends TileSegmentedReagentHandler {
    public List<ColourAndCoords> destinationList = new LinkedList<ColourAndCoords>();
    public Map<Reagent, List<Int3>> reagentTargetList = new HashMap<Reagent, List<Int3>>();
    public Map<Reagent, Integer> reagentTankDesignationList = new HashMap<Reagent, Integer>();
    public int tickRate = 20;
    int hasChanged = 0;
    public boolean affectedByRedstone = true;
    public int maxConnextions = 5;
    public int renderCount = 0;

    public TEReagentConduit() {
        this(2, 2000);
    }

    public TEReagentConduit(int numberOfTanks, int size) {
        super(numberOfTanks, size);
    }

    public Int3 getColour() {
        int[] redMap = new int[this.tanks.length];
        int[] greenMap = new int[this.tanks.length];
        int[] blueMap = new int[this.tanks.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            ReagentContainer container = this.tanks[i];
            if (container == null || container.getReagent() == null) continue;
            Reagent reagent = container.getReagent().reagent;
            redMap[i] = reagent.getColourRed();
            greenMap[i] = reagent.getColourGreen();
            blueMap[i] = reagent.getColourBlue();
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 0; i < this.tanks.length; ++i) {
            red += redMap[i];
            green += greenMap[i];
            blue += blueMap[i];
        }
        return new Int3(red /= this.tanks.length, green /= this.tanks.length, blue /= this.tanks.length);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("hasChanged", this.hasChanged);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.destinationList.size(); ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            tagList.appendTag((NBTBase)this.destinationList.get(i).writeToNBT(savedTag));
        }
        tag.setTag("destinationList", (NBTBase)tagList);
        NBTTagList reagentTagList = new NBTTagList();
        for (Map.Entry<Reagent, List<Int3>> entry : this.reagentTargetList.entrySet()) {
            NBTTagCompound savedTag = new NBTTagCompound();
            savedTag.setString("reagent", ReagentRegistry.getKeyForReagent(entry.getKey()));
            NBTTagList coordinateTagList = new NBTTagList();
            for (Int3 coord : entry.getValue()) {
                NBTTagCompound coordinateTag = new NBTTagCompound();
                coord.writeToNBT(coordinateTag);
                coordinateTagList.appendTag((NBTBase)coordinateTag);
            }
            savedTag.setTag("coordinateList", (NBTBase)coordinateTagList);
            reagentTagList.appendTag((NBTBase)savedTag);
        }
        tag.setTag("reagentTargetList", (NBTBase)reagentTagList);
        NBTTagList tankDesignationList = new NBTTagList();
        for (Map.Entry<Reagent, Integer> entry : this.reagentTankDesignationList.entrySet()) {
            NBTTagCompound savedTag = new NBTTagCompound();
            savedTag.setString("reagent", ReagentRegistry.getKeyForReagent(entry.getKey()));
            savedTag.setInteger("integer", entry.getValue().intValue());
            tankDesignationList.appendTag((NBTBase)savedTag);
        }
        tag.setTag("tankDesignationList", (NBTBase)tankDesignationList);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.hasChanged = tag.getInteger("hasChanged");
        NBTTagList tagList = tag.getTagList("destinationList", 10);
        this.destinationList = new LinkedList<ColourAndCoords>();
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound savedTag = tagList.getCompoundTagAt(i);
            this.destinationList.add(ColourAndCoords.readFromNBT(savedTag));
        }
        this.reagentTargetList = new HashMap<Reagent, List<Int3>>();
        NBTTagList reagentTagList = tag.getTagList("reagentTargetList", 10);
        for (int i = 0; i < reagentTagList.tagCount(); ++i) {
            NBTTagCompound savedTag = reagentTagList.getCompoundTagAt(i);
            Reagent reagent = ReagentRegistry.getReagentForKey(savedTag.getString("reagent"));
            LinkedList<Int3> coordList = new LinkedList<Int3>();
            NBTTagList coordinateList = savedTag.getTagList("coordinateList", 10);
            for (int j = 0; j < coordinateList.tagCount(); ++j) {
                coordList.add(Int3.readFromNBT(coordinateList.getCompoundTagAt(j)));
            }
            this.reagentTargetList.put(reagent, coordList);
        }
        this.reagentTankDesignationList = new HashMap<Reagent, Integer>();
        NBTTagList tankDesignationList = tag.getTagList("tankDesignationList", 10);
        for (int i = 0; i < tankDesignationList.tagCount(); ++i) {
            NBTTagCompound savedTag = tankDesignationList.getCompoundTagAt(i);
            this.reagentTankDesignationList.put(ReagentRegistry.getReagentForKey(savedTag.getString("reagent")), new Integer(savedTag.getInteger("integer")));
        }
    }

    public void readClientNBT(NBTTagCompound tag) {
        NBTTagList tagList = tag.getTagList("destinationList", 10);
        this.destinationList = new LinkedList<ColourAndCoords>();
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound savedTag = tagList.getCompoundTagAt(i);
            this.destinationList.add(ColourAndCoords.readFromNBT(savedTag));
        }
        NBTTagList reagentTagList = tag.getTagList("reagentTanks", 10);
        int size = reagentTagList.tagCount();
        this.tanks = new ReagentContainer[size];
        for (int i = 0; i < size; ++i) {
            NBTTagCompound savedTag = reagentTagList.getCompoundTagAt(i);
            this.tanks[i] = ReagentContainer.readFromNBT(savedTag);
        }
    }

    public void writeClientNBT(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.destinationList.size(); ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            tagList.appendTag((NBTBase)this.destinationList.get(i).writeToNBT(savedTag));
        }
        tag.setTag("destinationList", (NBTBase)tagList);
        NBTTagList reagentTagList = new NBTTagList();
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.tanks[i] != null) {
                this.tanks[i].writeToNBT(savedTag);
            }
            reagentTagList.appendTag((NBTBase)savedTag);
        }
        tag.setTag("reagentTanks", (NBTBase)reagentTagList);
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote) {
            if (this.hasChanged > 1) {
                this.hasChanged = 1;
            } else if (this.hasChanged == 1) {
                this.hasChanged = 0;
            }
            if (this.worldObj.getWorldTime() % 100L == 99L) {
                this.updateColourList();
            }
            if (this.affectedByRedstone && this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord)) {
                return;
            }
            int totalTransfered = 0;
            block0: for (Map.Entry<Reagent, List<Int3>> entry : this.reagentTargetList.entrySet()) {
                for (Int3 coord : entry.getValue()) {
                    int amount;
                    int z;
                    int y;
                    int x;
                    TileEntity tile;
                    int amountLeft;
                    if (totalTransfered >= this.tickRate) continue block0;
                    ReagentStack maxDrainAmount = this.drain(ForgeDirection.UNKNOWN, new ReagentStack(entry.getKey(), this.tickRate - totalTransfered), false);
                    if (maxDrainAmount == null || (amountLeft = maxDrainAmount.amount) <= 0 || !((tile = this.worldObj.getTileEntity(x = this.xCoord + coord.xCoord, y = this.yCoord + coord.yCoord, z = this.zCoord + coord.zCoord)) instanceof IReagentHandler) || (amount = Math.min(((IReagentHandler)tile).fill(ForgeDirection.UNKNOWN, maxDrainAmount, false), amountLeft)) <= 0) continue;
                    amountLeft -= amount;
                    totalTransfered += amount;
                    ReagentStack stack = this.drain(ForgeDirection.UNKNOWN, new ReagentStack(entry.getKey(), amount), true);
                    ((IReagentHandler)tile).fill(ForgeDirection.UNKNOWN, stack, true);
                }
            }
        } else {
            if (this.affectedByRedstone && this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord)) {
                return;
            }
            ++this.renderCount;
            if (this.worldObj.getWorldTime() % 100L != 0L) {
                return;
            }
            this.sendPlayerStuffs();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendPlayerStuffs() {
        Minecraft mc = Minecraft.getMinecraft();
        EntityClientPlayerMP player = mc.thePlayer;
        WorldClient world = mc.theWorld;
        if (SpellHelper.canPlayerSeeAlchemy((EntityPlayer)player)) {
            for (ColourAndCoords colourSet : this.destinationList) {
                if (!(this.worldObj.getTileEntity(this.xCoord + colourSet.xCoord, this.yCoord + colourSet.yCoord, this.zCoord + colourSet.zCoord) instanceof IReagentHandler)) continue;
                EntityParticleBeam beam = new EntityParticleBeam(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
                double velocity = Math.sqrt(Math.pow(colourSet.xCoord, 2.0) + Math.pow(colourSet.yCoord, 2.0) + Math.pow(colourSet.zCoord, 2.0));
                double wantedVel = 0.3;
                beam.setVelocity(wantedVel * (double)colourSet.xCoord / velocity, wantedVel * (double)colourSet.yCoord / velocity, wantedVel * (double)colourSet.zCoord / velocity);
                beam.setColour((float)colourSet.colourRed / 255.0f, (float)colourSet.colourGreen / 255.0f, (float)colourSet.colourBlue / 255.0f);
                beam.setDestination(this.xCoord + colourSet.xCoord, this.yCoord + colourSet.yCoord, this.zCoord + colourSet.zCoord);
                this.worldObj.spawnEntityInWorld((Entity)beam);
            }
        }
    }

    public void updateColourList() {
        if (this.worldObj.isRemote) {
            return;
        }
        List<ColourAndCoords> newList = this.compileListForReagentTargets(this.reagentTargetList);
        if (newList != null && !newList.equals(this.destinationList)) {
            this.destinationList = newList;
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public List<ColourAndCoords> compileListForReagentTargets(Map<Reagent, List<Int3>> map) {
        LinkedList<ColourAndCoords> list = new LinkedList<ColourAndCoords>();
        for (Map.Entry<Reagent, List<Int3>> entry : map.entrySet()) {
            Reagent reagent;
            if (entry.getValue() == null || (reagent = entry.getKey()) == null) continue;
            List<Int3> coords = entry.getValue();
            for (Int3 coord : coords) {
                if (coord == null) continue;
                list.add(new ColourAndCoords(reagent.getColourRed(), reagent.getColourGreen(), reagent.getColourBlue(), reagent.getColourIntensity(), coord.xCoord, coord.yCoord, coord.zCoord));
            }
        }
        return list;
    }

    public boolean addDestinationViaOffset(int red, int green, int blue, int intensity, int xOffset, int yOffset, int zOffset) {
        if (xOffset == 0 && yOffset == 0 && zOffset == 0) {
            return false;
        }
        this.destinationList.add(new ColourAndCoords(red, green, blue, intensity, xOffset, yOffset, zOffset));
        return true;
    }

    public boolean addDestinationViaActual(int red, int green, int blue, int intensity, int x, int y, int z) {
        return this.addDestinationViaOffset(red, green, blue, intensity, x - this.xCoord, y - this.yCoord, z - this.zCoord);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeClientNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 90210, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readClientNBT(packet.func_148857_g());
    }

    public boolean addReagentDestinationViaOffset(Reagent reagent, int xOffset, int yOffset, int zOffset) {
        int totalConnections = 0;
        for (Map.Entry<Reagent, List<Int3>> entry : this.reagentTargetList.entrySet()) {
            if (entry.getValue() == null) continue;
            totalConnections += entry.getValue().size();
        }
        if (totalConnections >= this.maxConnextions) {
            return false;
        }
        if (xOffset == 0 && yOffset == 0 && zOffset == 0) {
            return false;
        }
        Int3 newCoord = new Int3(xOffset, yOffset, zOffset);
        if (this.reagentTargetList.containsKey(reagent)) {
            List<Int3> coordList = this.reagentTargetList.get(reagent);
            if (coordList == null) {
                LinkedList<Int3> newCoordList = new LinkedList<Int3>();
                newCoordList.add(newCoord);
                this.reagentTargetList.put(reagent, newCoordList);
            } else {
                coordList.add(newCoord);
            }
            return true;
        }
        LinkedList<Int3> newCoordList = new LinkedList<Int3>();
        newCoordList.add(newCoord);
        this.reagentTargetList.put(reagent, newCoordList);
        return true;
    }

    public boolean addReagentDestinationViaActual(Reagent reagent, int x, int y, int z) {
        return this.addReagentDestinationViaOffset(reagent, x - this.xCoord, y - this.yCoord, z - this.zCoord);
    }

    public boolean removeReagentDestinationViaOffset(Reagent reagent, int xOffset, int yOffset, int zOffset) {
        List<Int3> coords;
        if (this.reagentTargetList.containsKey(reagent) && (coords = this.reagentTargetList.get(reagent)) != null) {
            Int3 reference = new Int3(xOffset, yOffset, zOffset);
            return coords.remove(reference);
        }
        return false;
    }

    public boolean removeReagentDestinationViaActual(Reagent reagent, int x, int y, int z) {
        return this.removeReagentDestinationViaOffset(reagent, x - this.xCoord, y - this.yCoord, z - this.zCoord);
    }

    @Override
    public int fill(ForgeDirection from, ReagentStack resource, boolean doFill) {
        if (doFill && !this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.hasChanged = 2;
        }
        return super.fill(from, resource, doFill);
    }

    @Override
    public ReagentStack drain(ForgeDirection from, ReagentStack resource, boolean doDrain) {
        if (doDrain && !this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.hasChanged = 2;
        }
        return super.drain(from, resource, doDrain);
    }
}

