/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.ModBlocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TESpectralBlock
extends TileEntity {
    private int ticksRemaining = 0;

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        this.ticksRemaining = par1NBTTagCompound.getInteger("ticksRemaining");
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("ticksRemaining", this.ticksRemaining);
    }

    public void updateEntity() {
        super.updateEntity();
        --this.ticksRemaining;
        if (this.ticksRemaining <= 0) {
            this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public static boolean createSpectralBlockAtLocation(World world, int x, int y, int z, int duration) {
        if (!world.isAirBlock(x, y, z)) {
            return false;
        }
        world.setBlock(x, y, z, ModBlocks.spectralBlock);
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TESpectralBlock) {
            ((TESpectralBlock)tile).setDuration(duration);
            return true;
        }
        return false;
    }

    public void setDuration(int dur) {
        this.ticksRemaining = dur;
    }

    public void resetDuration(int dur) {
        if (this.ticksRemaining < dur) {
            this.ticksRemaining = dur;
        }
    }
}

