/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.block.BlockTeleposer;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.items.TelepositionFocus;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEInventory;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TETeleposer
extends TEInventory {
    public static final int sizeInv = 1;
    private int resultID = 0;
    private int resultDamage = 0;
    private int previousInput = 0;
    private boolean isActive = false;

    public TETeleposer() {
        super(1);
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        this.resultID = par1NBTTagCompound.getInteger("resultID");
        this.resultDamage = par1NBTTagCompound.getInteger("resultDamage");
        this.isActive = par1NBTTagCompound.getBoolean("isActive");
        this.previousInput = par1NBTTagCompound.getInteger("previousInput");
    }

    @Override
    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("resultID", this.resultID);
        par1NBTTagCompound.setInteger("resultDamage", this.resultDamage);
        par1NBTTagCompound.setBoolean("isActive", this.isActive);
        par1NBTTagCompound.setInteger("previousInput", this.previousInput);
    }

    @Override
    public String getInventoryName() {
        return "TETeleposer";
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    public void updateEntity() {
        ItemStack focus;
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        int currentInput = this.worldObj.getBlockPowerInput(this.xCoord, this.yCoord, this.zCoord);
        if (this.previousInput == 0 && currentInput != 0 && (focus = this.getStackInSlot(0)) != null && focus.getItem() instanceof TelepositionFocus) {
            TelepositionFocus focusItem = (TelepositionFocus)focus.getItem();
            int xf = focusItem.xCoord(focus);
            int yf = focusItem.yCoord(focus);
            int zf = focusItem.zCoord(focus);
            World worldF = focusItem.getWorld(focus);
            int damage = (int)(0.5 * Math.sqrt((this.xCoord - xf) * (this.xCoord - xf) + (this.yCoord - yf + 1) * (this.yCoord - yf + 1) + (this.zCoord - zf) * (this.zCoord - zf)));
            int focusLevel = focusItem.getFocusLevel();
            int transportCount = 0;
            int entityCount = 0;
            if (worldF != null && worldF.getTileEntity(xf, yf, zf) instanceof TETeleposer && !worldF.getTileEntity(xf, yf, zf).equals((Object)this)) {
                int d0 = focusLevel - 1;
                AxisAlignedBB axisalignedbb1 = AxisAlignedBB.getBoundingBox((double)((double)this.xCoord - 0.5), (double)((double)this.yCoord + (double)d0 + 0.5), (double)((double)this.zCoord - 0.5), (double)((double)this.xCoord + 0.5), (double)((double)this.yCoord + 1.5 + (double)d0), (double)((double)this.zCoord + 0.5)).expand((double)d0, (double)d0, (double)d0);
                axisalignedbb1.maxY = Math.min((double)this.worldObj.getHeight(), (double)(this.yCoord + 2 + d0 + d0));
                List list1 = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb1);
                for (EntityLivingBase entityplayer1 : list1) {
                    ++entityCount;
                }
                AxisAlignedBB axisalignedbb2 = AxisAlignedBB.getBoundingBox((double)((double)xf - 0.5), (double)((double)(yf + d0) + 0.5), (double)((double)zf - 0.5), (double)((double)xf + 0.5), (double)((double)yf + 1.5 + (double)d0), (double)((double)zf + 0.5)).expand((double)d0, (double)d0, (double)d0);
                List list2 = worldF.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb2);
                for (EntityLivingBase entityplayer2 : list2) {
                    ++entityCount;
                }
                if (EnergyItems.canSyphonInContainer(focus, damage * (focusLevel * 2 - 1) * (focusLevel * 2 - 1) * (focusLevel * 2 - 1) + damage * entityCount)) {
                    Iterator iterator2;
                    Iterator iterator1;
                    EntityLivingBase entityplayer2;
                    EntityLivingBase entityplayer1;
                    for (int k = 0; k <= focusLevel * 2 - 2; ++k) {
                        for (int i = -(focusLevel - 1); i <= focusLevel - 1; ++i) {
                            for (int j = -(focusLevel - 1); j <= focusLevel - 1; ++j) {
                                if (!BlockTeleposer.swapBlocks((Object)this, this.worldObj, worldF, this.xCoord + i, this.yCoord + 1 + k, this.zCoord + j, xf + i, yf + 1 + k, zf + j)) continue;
                                ++transportCount;
                            }
                        }
                    }
                    if (!worldF.equals(this.worldObj)) {
                        entityCount = 0;
                    }
                    SoulNetworkHandler.syphonFromNetwork(focus, damage * transportCount + damage * entityCount);
                    if (worldF.equals(this.worldObj)) {
                        iterator1 = list1.iterator();
                        iterator2 = list2.iterator();
                        while (iterator1.hasNext()) {
                            entityplayer1 = (EntityLivingBase)iterator1.next();
                            entityplayer1.worldObj = worldF;
                            entityplayer1.setPositionAndUpdate(entityplayer1.posX - (double)this.xCoord + (double)xf, entityplayer1.posY - (double)this.yCoord + (double)yf, entityplayer1.posZ - (double)this.zCoord + (double)zf);
                        }
                        while (iterator2.hasNext()) {
                            entityplayer2 = (EntityLivingBase)iterator2.next();
                            entityplayer2.worldObj = worldF;
                            entityplayer2.setPositionAndUpdate(entityplayer2.posX + (double)this.xCoord - (double)xf, entityplayer2.posY + (double)this.yCoord - (double)yf, entityplayer2.posZ + (double)this.zCoord - (double)zf);
                        }
                    } else {
                        iterator1 = list1.iterator();
                        iterator2 = list2.iterator();
                        while (iterator1.hasNext()) {
                            entityplayer1 = (EntityLivingBase)iterator1.next();
                            SpellHelper.teleportEntityToDim(this.worldObj, worldF.provider.dimensionId, entityplayer1.posX - (double)this.xCoord + (double)xf, entityplayer1.posY - (double)this.yCoord + (double)yf, entityplayer1.posZ - (double)this.zCoord + (double)zf, (Entity)entityplayer1);
                        }
                        while (iterator2.hasNext()) {
                            entityplayer2 = (EntityLivingBase)iterator2.next();
                            SpellHelper.teleportEntityToDim(worldF, this.worldObj.provider.dimensionId, entityplayer2.posX + (double)this.xCoord - (double)xf, entityplayer2.posY + (double)this.yCoord - (double)yf, entityplayer2.posZ + (double)this.zCoord - (double)zf, (Entity)entityplayer2);
                        }
                    }
                }
            }
        }
        this.previousInput = currentInput;
    }

    public void setActive() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Packet getDescriptionPacket() {
        return NewPacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData) {
        if (intData == null) {
            return;
        }
        if (intData.length == 3) {
            for (int i = 0; i < 1; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.getItemById((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[3];
        int pos = 0;
        for (ItemStack is : this.inv) {
            if (is != null) {
                sortList[pos++] = Item.getIdFromItem((Item)is.getItem());
                sortList[pos++] = is.getItemDamage();
                sortList[pos++] = is.stackSize;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return itemstack.getItem() instanceof TelepositionFocus;
    }
}

