/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tweaker;

import WayofTime.alchemicalWizardry.api.harvest.HarvestRegistry;
import WayofTime.alchemicalWizardry.api.harvest.IHarvestHandler;
import WayofTime.alchemicalWizardry.common.harvest.GenericItemStackHarvestHandler;
import WayofTime.alchemicalWizardry.common.tweaker.MTHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.HarvestMoon")
public class HarvestMoon {
    @ZenMethod
    public static void addHarvestable(IItemStack block, IItemStack seed) {
        HarvestMoon.addHarvestable(block, block.getDamage(), seed);
    }

    @ZenMethod
    public static void addHarvestable(IItemStack block, int meta, IItemStack seed) {
        ItemStack seedStack = MTHelper.toStack(seed);
        Block plantBlock = Block.getBlockFromItem((Item)MTHelper.toStack(block).getItem());
        if (plantBlock == null || plantBlock == Blocks.air || seedStack == null || !(seedStack.getItem() instanceof IPlantable)) {
            throw new IllegalArgumentException("Invalid Harvest Block or Seed");
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(plantBlock, meta, seedStack));
    }

    private static class Add
    implements IUndoableAction {
        private IHarvestHandler handler;
        private String name;

        public Add(Block block, int meta, ItemStack seed) {
            this.handler = new GenericItemStackHarvestHandler(block, meta, seed);
            this.name = seed.getDisplayName();
        }

        public void apply() {
            HarvestRegistry.registerHarvestHandler(this.handler);
        }

        public boolean canUndo() {
            return HarvestRegistry.handlerList != null;
        }

        public void undo() {
            HarvestRegistry.handlerList.remove(this.handler);
        }

        public String describe() {
            return "Adding Harvest Moon Support for " + this.name;
        }

        public String describeUndo() {
            return "Removing Harvest Moon Support for " + this.name;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

