/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.actions;

import minetweaker.IUndoableAction;
import net.minecraft.item.ItemStack;

public class SetStackmaxDamageAction
implements IUndoableAction {
    private final ItemStack stack;
    private final int damage;
    private final int oldDamage;

    public SetStackmaxDamageAction(ItemStack stack, int damage) {
        this.stack = stack;
        this.damage = damage;
        this.oldDamage = stack.getMaxDamage();
    }

    @Override
    public void apply() {
        SetStackmaxDamageAction.set(this.stack, this.damage);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        SetStackmaxDamageAction.set(this.stack, this.oldDamage);
    }

    @Override
    public String describe() {
        return "Setting max damage of  " + this.stack.getDisplayName() + " to " + this.damage;
    }

    @Override
    public String describeUndo() {
        return "Reverting max damage of " + this.stack.getDisplayName() + " to " + this.oldDamage;
    }

    private static void set(ItemStack stack, int damage) {
        stack.getItem().setMaxDamage(damage);
    }

    @Override
    public Object getOverrideKey() {
        return null;
    }
}

