/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.item;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import minetweaker.MineTweakerAPI;
import minetweaker.api.block.IBlock;
import minetweaker.api.data.DataMap;
import minetweaker.api.data.IData;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemDefinition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientItem;
import minetweaker.api.item.IngredientOr;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.api.player.IPlayer;
import minetweaker.mc1710.actions.SetBlockHardnessAction;
import minetweaker.mc1710.actions.SetStackSizeAction;
import minetweaker.mc1710.actions.SetStackmaxDamageAction;
import minetweaker.mc1710.actions.SetTranslationAction;
import minetweaker.mc1710.block.MCItemBlock;
import minetweaker.mc1710.data.NBTConverter;
import minetweaker.mc1710.item.MCItemDefinition;
import minetweaker.mc1710.liquid.MCLiquidStack;
import minetweaker.util.ArrayUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class MCItemStack
implements IItemStack {
    private final ItemStack stack;
    private final List<IItemStack> items;
    private IData tag = null;
    private boolean wildcardSize;

    public MCItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack.copy();
        this.items = Collections.singletonList(this);
    }

    public MCItemStack(ItemStack itemStack, boolean wildcardSize) {
        this(itemStack);
        this.wildcardSize = wildcardSize;
    }

    private MCItemStack(ItemStack itemStack, IData tag) {
        if (itemStack == null) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        this.stack = itemStack;
        this.items = Collections.singletonList(this);
        this.tag = tag;
    }

    private MCItemStack(ItemStack itemStack, IData tag, boolean wildcardSize) {
        this.stack = itemStack;
        this.items = Collections.singletonList(this);
        this.tag = tag;
        this.wildcardSize = wildcardSize;
    }

    @Override
    public IItemDefinition getDefinition() {
        return new MCItemDefinition(Item.itemRegistry.getNameForObject((Object)this.stack.getItem()), this.stack.getItem());
    }

    @Override
    public String getName() {
        return this.stack.getUnlocalizedName();
    }

    @Override
    public String getDisplayName() {
        return this.stack.getDisplayName();
    }

    @Override
    public void setDisplayName(String name) {
        MineTweakerAPI.apply(new SetTranslationAction(this.getName() + ".name", name));
    }

    @Override
    public void setMaxDamage(int damage) {
        MineTweakerAPI.apply(new SetStackmaxDamageAction(this.stack, damage));
    }

    @Override
    public int getMaxStackSize() {
        return this.stack.getMaxStackSize();
    }

    @Override
    public void setMaxStackSize(int size) {
        MineTweakerAPI.apply(new SetStackSizeAction((ItemStack)this.getInternal(), size));
    }

    @Override
    public float getBlockHardness() {
        return ((Float)ReflectionHelper.getPrivateValue(Block.class, (Object)Block.getBlockFromItem((Item)this.stack.getItem()), (String[])new String[]{"blockHardness"})).floatValue();
    }

    @Override
    public void setBlockHardness(float hardness) {
        MineTweakerAPI.apply(new SetBlockHardnessAction(this.stack, hardness));
    }

    @Override
    public int getDamage() {
        return this.stack.getItemDamage();
    }

    @Override
    public IData getTag() {
        if (this.tag == null) {
            if (this.stack.stackTagCompound == null) {
                return DataMap.EMPTY;
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.stackTagCompound, true);
        }
        return this.tag;
    }

    @Override
    public int getMaxDamage() {
        return this.stack.getMaxDamage();
    }

    @Override
    public ILiquidStack getLiquid() {
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.stack);
        return liquid == null ? null : new MCLiquidStack(liquid);
    }

    @Override
    public IIngredient anyDamage() {
        if (this.stack.getItem().getHasSubtypes()) {
            MineTweakerAPI.logWarning("subitems don't have damaged states");
            return this;
        }
        ItemStack result = new ItemStack(this.stack.getItem(), this.stack.stackSize, Short.MAX_VALUE);
        result.stackTagCompound = this.stack.stackTagCompound;
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack withDamage(int damage) {
        if (this.stack.getItem().getHasSubtypes()) {
            MineTweakerAPI.logWarning("subitems don't have damaged states");
            return this;
        }
        ItemStack result = new ItemStack(this.stack.getItem(), this.stack.stackSize, damage);
        result.stackTagCompound = this.stack.stackTagCompound;
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack anyAmount() {
        ItemStack result = new ItemStack(this.stack.getItem(), 1, this.stack.getItemDamage());
        result.stackTagCompound = this.stack.stackTagCompound;
        return new MCItemStack(result, this.tag, true);
    }

    @Override
    public IItemStack withAmount(int amount) {
        ItemStack result = new ItemStack(this.stack.getItem(), amount, this.stack.getItemDamage());
        result.stackTagCompound = this.stack.stackTagCompound;
        return new MCItemStack(result, this.tag);
    }

    @Override
    public IItemStack withTag(IData tag) {
        ItemStack result = new ItemStack(this.stack.getItem(), this.stack.stackSize, this.stack.getItemDamage());
        result.stackTagCompound = tag == null ? null : (NBTTagCompound)NBTConverter.from(tag);
        return new MCItemStack(result, tag);
    }

    @Override
    public IItemStack withEmptyTag() {
        ItemStack itemStack = new ItemStack(this.stack.getItem(), this.stack.stackSize, this.stack.getItemDamage());
        itemStack.stackTagCompound = null;
        return new MCItemStack(itemStack);
    }

    @Override
    public IItemStack updateTag(IData tagUpdate) {
        if (this.tag == null) {
            if (this.stack.stackTagCompound == null) {
                return this.withTag(tagUpdate);
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.stackTagCompound, true);
        }
        IData updated = this.tag.update(tagUpdate);
        return this.withTag(updated);
    }

    @Override
    public IItemStack removeTag(String tag) {
        ItemStack result = new ItemStack(this.stack.getItem(), this.stack.stackSize, this.stack.getItemDamage());
        if (tag == null) {
            result.stackTagCompound = null;
        } else {
            result.stackTagCompound.removeTag(tag);
        }
        IData dataTag = NBTConverter.from((NBTBase)result.stackTagCompound, false);
        return new MCItemStack(result, dataTag);
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public int getAmount() {
        return this.stack.stackSize;
    }

    @Override
    public List<IItemStack> getItems() {
        return this.items;
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IItemStack amount(int amount) {
        return this.withAmount(amount);
    }

    @Override
    public WeightedItemStack percent(float chance) {
        return new WeightedItemStack(this, chance * 0.01f);
    }

    @Override
    public WeightedItemStack weight(float chance) {
        return new WeightedItemStack(this, chance);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientItem(this, null, ArrayUtil.EMPTY_CONDITIONS, new IItemTransformer[]{transformer});
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientItem(this, null, new IItemCondition[]{condition}, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientItem(this, mark, ArrayUtil.EMPTY_CONDITIONS, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        ItemStack internal = MineTweakerMC.getItemStack(item);
        return internal != null && this.stack != null && internal.getItem() == this.stack.getItem() && (this.wildcardSize || internal.stackSize >= this.stack.stackSize) && (this.stack.getItemDamage() == Short.MAX_VALUE || this.stack.getItemDamage() == internal.getItemDamage() || !this.stack.getHasSubtypes() && !this.stack.getItem().isDamageable());
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        ItemStack internal = MineTweakerMC.getItemStack(item);
        if (internal.getTagCompound() != null && this.stack.getTagCompound() == null) {
            return false;
        }
        if (internal.getTagCompound() == null && this.stack.getTagCompound() != null) {
            return false;
        }
        if (internal.getTagCompound() == null && this.stack.getTagCompound() == null) {
            return this.stack.getItem() == internal.getItem() && (internal.getItemDamage() == Short.MAX_VALUE || this.stack.getItemDamage() == internal.getItemDamage());
        }
        if (internal.getTagCompound().func_150296_c().equals(this.stack.getTagCompound().func_150296_c())) {
            for (String s : internal.getTagCompound().func_150296_c()) {
                if (internal.getTagCompound().getTag(s).equals((Object)this.stack.getTagCompound().getTag(s))) continue;
                return false;
            }
        }
        return this.stack.getItem() == internal.getItem() && (internal.getItemDamage() == Short.MAX_VALUE || this.stack.getItemDamage() == internal.getItemDamage());
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> iitems = ingredient.getItems();
        if (iitems == null || iitems.size() != 1) {
            return false;
        }
        return this.matches(iitems.get(0));
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return false;
    }

    @Override
    public Object getInternal() {
        return this.stack;
    }

    @Override
    public IBlock asBlock() {
        String name = Block.blockRegistry.getNameForObject((Object)Block.getBlockFromItem((Item)this.stack.getItem()));
        if (Block.blockRegistry.containsKey(name)) {
            return new MCItemBlock(this.stack);
        }
        throw new ClassCastException("This item is not a block");
    }

    @Override
    public List<IOreDictEntry> getOres() {
        ArrayList<IOreDictEntry> result = new ArrayList<IOreDictEntry>();
        block0: for (String key : OreDictionary.getOreNames()) {
            for (ItemStack is : OreDictionary.getOres((String)key)) {
                if (is.getItem() != this.stack.getItem() || is.getItemDamage() != Short.MAX_VALUE && is.getItemDamage() != this.stack.getItemDamage()) continue;
                result.add(MineTweakerAPI.oreDict.get(key));
                continue block0;
            }
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.stack.getItem().hashCode();
        hash = 41 * hash + this.stack.getItemDamage();
        hash = 41 * hash + this.stack.stackSize;
        hash = 41 * hash + (this.stack.stackTagCompound == null ? 0 : this.stack.stackTagCompound.hashCode());
        hash = 41 * hash + (this.wildcardSize ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MCItemStack other = (MCItemStack)obj;
        if (this.stack.getItem() != other.stack.getItem()) {
            return false;
        }
        if (this.stack.getItemDamage() != other.stack.getItemDamage()) {
            return false;
        }
        if (this.stack.stackSize != other.stack.stackSize) {
            return false;
        }
        if (this.stack.stackTagCompound != other.stack.stackTagCompound && (this.stack == null || this.stack.equals(other.stack))) {
            return false;
        }
        return this.wildcardSize == other.wildcardSize;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        result.append(Item.itemRegistry.getNameForObject((Object)this.stack.getItem()));
        if (this.stack.getItemDamage() == Short.MAX_VALUE) {
            result.append(":*");
        } else if (this.stack.getItemDamage() > 0) {
            result.append(':').append(this.stack.getItemDamage());
        }
        result.append('>');
        if (this.stack.getTagCompound() != null) {
            result.append(".withTag(");
            result.append(NBTConverter.from((NBTBase)this.stack.getTagCompound(), this.wildcardSize).toString());
            result.append(")");
        }
        return result.toString();
    }
}

