/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.recipes.ICraftingRecipe;
import minetweaker.api.recipes.ShapedRecipe;
import minetweaker.api.recipes.ShapelessRecipe;
import minetweaker.api.recipes.UnknownRecipe;
import minetweaker.mc1710.recipes.ShapedRecipeAdvanced;
import minetweaker.mc1710.recipes.ShapedRecipeBasic;
import minetweaker.mc1710.recipes.ShapedRecipeOre;
import minetweaker.mc1710.recipes.ShapelessRecipeAdvanced;
import minetweaker.mc1710.recipes.ShapelessRecipeBasic;
import minetweaker.mc1710.recipes.ShapelessRecipeOre;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeConverter {
    public static final int TYPE_ADVANCED = 0;
    public static final int TYPE_ORE = 1;
    public static final int TYPE_BASIC = 2;

    private RecipeConverter() {
    }

    private static int getIngredientType(IIngredient pattern) {
        Object internal = pattern.getInternal();
        if (internal == null) {
            return 0;
        }
        if (internal instanceof ItemStack) {
            return 2;
        }
        return 1;
    }

    private static int getRecipeType(IIngredient[] ingredients) {
        int type = 2;
        for (IIngredient ingredient : ingredients) {
            type = Math.min(type, RecipeConverter.getIngredientType(ingredient));
        }
        return type;
    }

    public static IRecipe convert(ICraftingRecipe recipe) {
        if (recipe instanceof ShapedRecipe) {
            return RecipeConverter.convert((ShapedRecipe)recipe);
        }
        return RecipeConverter.convert((ShapelessRecipe)recipe);
    }

    public static IRecipe convert(ShapelessRecipe recipe) {
        IIngredient[] ingredients = recipe.getIngredients();
        int type = RecipeConverter.getRecipeType(ingredients);
        if (type == 2) {
            ItemStack[] items = new ItemStack[ingredients.length];
            for (int i = 0; i < ingredients.length; ++i) {
                items[i] = MineTweakerMC.getItemStack(ingredients[i]);
            }
            return new ShapelessRecipeBasic(items, recipe);
        }
        if (type == 1) {
            Object[] items = new Object[ingredients.length];
            for (int i = 0; i < ingredients.length; ++i) {
                items[i] = ingredients[i].getInternal();
            }
            return new ShapelessRecipeOre(items, recipe);
        }
        return new ShapelessRecipeAdvanced(recipe);
    }

    public static IRecipe convert(ShapedRecipe recipe) {
        IIngredient[] ingredients = recipe.getIngredients();
        byte[] posx = recipe.getIngredientsX();
        byte[] posy = recipe.getIngredientsY();
        int type = RecipeConverter.getRecipeType(ingredients);
        if (type == 2) {
            ItemStack[] basicIngredients = new ItemStack[recipe.getHeight() * recipe.getWidth()];
            for (int i = 0; i < ingredients.length; ++i) {
                basicIngredients[posx[i] + posy[i] * recipe.getWidth()] = MineTweakerMC.getItemStack(ingredients[i]);
            }
            return new ShapedRecipeBasic(basicIngredients, recipe);
        }
        if (type == 1) {
            Object[] converted = new Object[recipe.getHeight() * recipe.getWidth()];
            for (int i = 0; i < ingredients.length; ++i) {
                converted[posx[i] + posy[i] * recipe.getWidth()] = ingredients[i].getInternal();
            }
            int counter = 0;
            String[] parts = new String[recipe.getHeight()];
            ArrayList<Object> rarguments = new ArrayList<Object>();
            for (int i = 0; i < recipe.getHeight(); ++i) {
                char[] pattern = new char[recipe.getWidth()];
                for (int j = 0; j < recipe.getWidth(); ++j) {
                    int off = i * recipe.getWidth() + j;
                    if (converted[off] == null) {
                        pattern[j] = 32;
                        continue;
                    }
                    pattern[j] = (char)(65 + counter);
                    rarguments.add(Character.valueOf(pattern[j]));
                    rarguments.add(converted[off]);
                    ++counter;
                }
                parts[i] = new String(pattern);
            }
            rarguments.addAll(0, Arrays.asList(parts));
            return new ShapedRecipeOre(rarguments.toArray(), recipe);
        }
        return new ShapedRecipeAdvanced(recipe);
    }

    public static ICraftingRecipe toCraftingRecipe(IRecipe recipe) {
        IItemStack output = MineTweakerMC.getIItemStack(recipe.getRecipeOutput());
        if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes shapeless = (ShapelessRecipes)recipe;
            IIngredient[] ingredients = new IIngredient[shapeless.recipeItems.size()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = MineTweakerMC.getIIngredient(shapeless.recipeItems.get(i));
            }
            return new ShapelessRecipe(output, ingredients, null, null);
        }
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shaped = (ShapedRecipes)recipe;
            IIngredient[][] ingredients = new IIngredient[shaped.recipeHeight][shaped.recipeWidth];
            for (int i = 0; i < shaped.recipeHeight; ++i) {
                for (int j = 0; j < shaped.recipeWidth; ++j) {
                    ingredients[i][j] = MineTweakerMC.getIItemStack(shaped.recipeItems[i * shaped.recipeWidth + j]);
                }
            }
            return new ShapedRecipe(output, ingredients, null, null, false);
        }
        if (recipe instanceof ShapedOreRecipe) {
            ShapedOreRecipe shaped = (ShapedOreRecipe)recipe;
            int width = (int)Math.sqrt(recipe.getRecipeSize());
            int height = recipe.getRecipeSize() / width;
            IIngredient[][] recipeIngredients = new IIngredient[height][width];
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    recipeIngredients[i][j] = MineTweakerMC.getIIngredient(shaped.getInput()[i * width + j]);
                }
            }
            return new ShapedRecipe(output, recipeIngredients, null, null, false);
        }
        if (recipe instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe shapeless = (ShapelessOreRecipe)recipe;
            IIngredient[] ingredients = new IIngredient[shapeless.getRecipeSize()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = MineTweakerMC.getIIngredient(shapeless.getInput().get(i));
            }
            return new ShapelessRecipe(output, ingredients, null, null);
        }
        return new UnknownRecipe(output);
    }
}

