/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.EnderWidget;
import com.google.common.collect.Lists;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.ArrayUtils;

public class ToggleButton
extends IconButton {
    private boolean selected;
    private final IWidgetIcon unselectedIcon;
    private final IWidgetIcon selectedIcon;
    private GuiToolTip selectedTooltip;
    private GuiToolTip unselectedTooltip;
    private boolean paintSelectionBorder;

    public ToggleButton(IGuiScreen gui, int id, int x, int y, IWidgetIcon unselectedIcon, IWidgetIcon selectedIcon) {
        super(gui, id, x, y, unselectedIcon);
        this.unselectedIcon = unselectedIcon;
        this.selectedIcon = selectedIcon;
        this.selected = false;
        this.paintSelectionBorder = true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public ToggleButton setSelected(boolean selected) {
        this.selected = selected;
        IWidgetIcon iWidgetIcon = this.icon = selected ? this.selectedIcon : this.unselectedIcon;
        if (selected && this.selectedTooltip != null) {
            this.setToolTip(this.selectedTooltip);
        } else if (!selected && this.unselectedTooltip != null) {
            this.setToolTip(this.unselectedTooltip);
        }
        return this;
    }

    @Override
    protected IWidgetIcon getIconForHoverState(int hoverState) {
        if (!this.selected || !this.paintSelectionBorder) {
            return super.getIconForHoverState(hoverState);
        }
        if (hoverState == 0) {
            return EnderWidget.BUTTON_DISABLED;
        }
        if (hoverState == 2) {
            return EnderWidget.BUTTON_DOWN_HIGHLIGHT;
        }
        return EnderWidget.BUTTON_DOWN;
    }

    public boolean mousePressed(Minecraft par1Minecraft, int par2, int par3) {
        if (super.mousePressed(par1Minecraft, par2, par3)) {
            return this.toggleSelected();
        }
        return false;
    }

    protected boolean toggleSelected() {
        this.setSelected(!this.selected);
        return true;
    }

    public void setSelectedToolTip(String ... tt) {
        Object[] combinedTooltip = (String[])ArrayUtils.addAll((Object[])this.toolTipText, (Object[])tt);
        this.selectedTooltip = new GuiToolTip(this.getBounds(), Lists.newArrayList((Object[])combinedTooltip));
        this.setSelected(this.selected);
    }

    public void setUnselectedToolTip(String ... tt) {
        Object[] combinedTooltip = (String[])ArrayUtils.addAll((Object[])this.toolTipText, (Object[])tt);
        this.unselectedTooltip = new GuiToolTip(this.getBounds(), Lists.newArrayList((Object[])combinedTooltip));
        this.setSelected(this.selected);
    }

    public void setPaintSelectedBorder(boolean b) {
        this.paintSelectionBorder = b;
    }
}

