/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.render.IRenderFace;
import com.enderio.core.common.vecmath.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class CustomRenderBlocks
extends RenderBlocks {
    boolean translateToXYZ = true;
    boolean shouldRenderBaseTexture = true;
    private final List<IRenderFace> renderFaceCallbacks = new ArrayList<IRenderFace>();
    private IIcon overrideTexture;

    public CustomRenderBlocks() {
    }

    public CustomRenderBlocks(IBlockAccess par1iBlockAccess) {
        super(par1iBlockAccess);
    }

    public void addFaceRenderer(IRenderFace renderer) {
        this.renderFaceCallbacks.add(renderer);
    }

    public void setFaceRenderers(Collection<IRenderFace> renderers) {
        this.renderFaceCallbacks.clear();
        if (renderers != null) {
            this.renderFaceCallbacks.addAll(renderers);
        }
    }

    public void removeFaceRenderer(IRenderFace renderer) {
        this.renderFaceCallbacks.remove(renderer);
    }

    public boolean isTranslateToXYZ() {
        return this.translateToXYZ;
    }

    public void setTranslateToXYZ(boolean translateToXYZ) {
        this.translateToXYZ = translateToXYZ;
    }

    public IIcon getOverrideTexture() {
        return this.overrideTexture;
    }

    public void setOverrideTexture(IIcon overrideTexture) {
        this.overrideTexture = overrideTexture;
    }

    public void setShouldRenderBaseTexture(boolean val) {
        this.shouldRenderBaseTexture = val;
    }

    private void renderFace(ForgeDirection face, Block par1Block, double x, double y, double z, IIcon texture) {
        if (this.renderFaceCallbacks.isEmpty()) {
            this.doDefaultRenderFace(face, par1Block, x, y, z, this.overrideTexture == null ? texture : this.overrideTexture);
        } else {
            List<Vertex> faceVertices = this.createVerticesForFace(face, par1Block, x, y, z, this.overrideTexture == null ? texture : this.overrideTexture);
            for (IRenderFace rf : this.renderFaceCallbacks) {
                rf.renderFace(this, face, par1Block, x, y, z, this.overrideTexture == null ? texture : this.overrideTexture, faceVertices, this.translateToXYZ);
            }
        }
    }

    public List<Vertex> createVerticesForFace(ForgeDirection face, Block par1Block, double x, double y, double z, IIcon icon) {
        switch (face) {
            case DOWN: {
                return this.calcFaceYNeg(par1Block, x, y, z, icon);
            }
            case EAST: {
                return this.calcFaceXPos(par1Block, x, y, z, icon);
            }
            case NORTH: {
                return this.calcFaceZNeg(par1Block, x, y, z, icon);
            }
            case SOUTH: {
                return this.calcFaceZPos(par1Block, x, y, z, icon);
            }
            case UP: {
                return this.calcFaceYPos(par1Block, x, y, z, icon);
            }
            case WEST: {
                return this.calcFaceXNeg(par1Block, x, y, z, icon);
            }
        }
        return Collections.emptyList();
    }

    public void doDefaultRenderFace(ForgeDirection face, Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        switch (face) {
            case DOWN: {
                super.renderFaceYNeg(par1Block, par2, par4, par6, par8Icon);
                break;
            }
            case EAST: {
                super.renderFaceXPos(par1Block, par2, par4, par6, par8Icon);
                break;
            }
            case NORTH: {
                super.renderFaceZNeg(par1Block, par2, par4, par6, par8Icon);
                break;
            }
            case SOUTH: {
                super.renderFaceZPos(par1Block, par2, par4, par6, par8Icon);
                break;
            }
            case UP: {
                super.renderFaceYPos(par1Block, par2, par4, par6, par8Icon);
                break;
            }
            case WEST: {
                super.renderFaceXNeg(par1Block, par2, par4, par6, par8Icon);
                break;
            }
        }
    }

    public void renderFaceYNeg(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.DOWN, par1Block, par2, par4, par6, par8Icon);
    }

    public void renderFaceYPos(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.UP, par1Block, par2, par4, par6, par8Icon);
    }

    public void renderFaceZNeg(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.NORTH, par1Block, par2, par4, par6, par8Icon);
    }

    public void renderFaceZPos(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.SOUTH, par1Block, par2, par4, par6, par8Icon);
    }

    public void renderFaceXNeg(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.WEST, par1Block, par2, par4, par6, par8Icon);
    }

    public void renderFaceXPos(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        this.renderFace(ForgeDirection.EAST, par1Block, par2, par4, par6, par8Icon);
    }

    private List<Vertex> calcFaceXNeg(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        if (this.hasOverrideBlockTexture()) {
            par8Icon = this.overrideBlockTexture;
        }
        double d3 = par8Icon.getInterpolatedU(this.renderMinZ * 16.0);
        double d4 = par8Icon.getInterpolatedU(this.renderMaxZ * 16.0);
        double d5 = par8Icon.getInterpolatedV(16.0 - this.renderMaxY * 16.0);
        double d6 = par8Icon.getInterpolatedV(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d3 = par8Icon.getMinU();
            d4 = par8Icon.getMaxU();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = par8Icon.getMinV();
            d6 = par8Icon.getMaxV();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateNorth == 1) {
            d3 = par8Icon.getInterpolatedU(this.renderMinY * 16.0);
            d5 = par8Icon.getInterpolatedV(16.0 - this.renderMaxZ * 16.0);
            d4 = par8Icon.getInterpolatedU(this.renderMaxY * 16.0);
            d6 = par8Icon.getInterpolatedV(16.0 - this.renderMinZ * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateNorth == 2) {
            d3 = par8Icon.getInterpolatedU(16.0 - this.renderMaxY * 16.0);
            d5 = par8Icon.getInterpolatedV(this.renderMinZ * 16.0);
            d4 = par8Icon.getInterpolatedU(16.0 - this.renderMinY * 16.0);
            d6 = par8Icon.getInterpolatedV(this.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateNorth == 3) {
            d3 = par8Icon.getInterpolatedU(16.0 - this.renderMinZ * 16.0);
            d4 = par8Icon.getInterpolatedU(16.0 - this.renderMaxZ * 16.0);
            d5 = par8Icon.getInterpolatedV(this.renderMaxY * 16.0);
            d6 = par8Icon.getInterpolatedV(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + this.renderMinX;
        double d12 = par4 + this.renderMinY;
        double d13 = par4 + this.renderMaxY;
        double d14 = par6 + this.renderMinZ;
        double d15 = par6 + this.renderMaxZ;
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        if (this.enableAO) {
            result.add(new Vertex(d11, d13, d15, d7, d9, this.brightnessTopLeft, this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft, 1.0f));
            result.add(new Vertex(d11, d13, d14, d3, d5, this.brightnessBottomLeft, this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft, 1.0f));
            result.add(new Vertex(d11, d12, d14, d8, d10, this.brightnessBottomRight, this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight, 1.0f));
            result.add(new Vertex(d11, d12, d15, d4, d6, this.brightnessTopRight, this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight, 1.0f));
        } else {
            result.add(new Vertex(d11, d13, d15, d7, d9));
            result.add(new Vertex(d11, d13, d14, d3, d5));
            result.add(new Vertex(d11, d12, d14, d8, d10));
            result.add(new Vertex(d11, d12, d15, d4, d6));
        }
        return result;
    }

    private List<Vertex> calcFaceYPos(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        if (this.hasOverrideBlockTexture()) {
            par8Icon = this.overrideBlockTexture;
        }
        double d3 = par8Icon.getInterpolatedU(this.renderMinX * 16.0);
        double d4 = par8Icon.getInterpolatedU(this.renderMaxX * 16.0);
        double d5 = par8Icon.getInterpolatedV(this.renderMinZ * 16.0);
        double d6 = par8Icon.getInterpolatedV(this.renderMaxZ * 16.0);
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = par8Icon.getMinU();
            d4 = par8Icon.getMaxU();
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d5 = par8Icon.getMinV();
            d6 = par8Icon.getMaxV();
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateTop == 1) {
            d3 = par8Icon.getInterpolatedU(this.renderMinZ * 16.0);
            d5 = par8Icon.getInterpolatedV(16.0 - this.renderMaxX * 16.0);
            d4 = par8Icon.getInterpolatedU(this.renderMaxZ * 16.0);
            d6 = par8Icon.getInterpolatedV(16.0 - this.renderMinX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateTop == 2) {
            d3 = par8Icon.getInterpolatedU(16.0 - this.renderMaxZ * 16.0);
            d5 = par8Icon.getInterpolatedV(this.renderMinX * 16.0);
            d4 = par8Icon.getInterpolatedU(16.0 - this.renderMinZ * 16.0);
            d6 = par8Icon.getInterpolatedV(this.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateTop == 3) {
            d3 = par8Icon.getInterpolatedU(16.0 - this.renderMinX * 16.0);
            d4 = par8Icon.getInterpolatedU(16.0 - this.renderMaxX * 16.0);
            d5 = par8Icon.getInterpolatedV(16.0 - this.renderMinZ * 16.0);
            d6 = par8Icon.getInterpolatedV(16.0 - this.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + this.renderMinX;
        double d12 = par2 + this.renderMaxX;
        double d13 = par4 + this.renderMaxY;
        double d14 = par6 + this.renderMinZ;
        double d15 = par6 + this.renderMaxZ;
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        if (this.enableAO) {
            Vertex v = new Vertex(d12, d13, d15, d4, d6, this.brightnessTopLeft, this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft, 1.0f);
            result.add(v);
            v = new Vertex(d12, d13, d14, d7, d9, this.brightnessBottomLeft, this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft, 1.0f);
            result.add(v);
            v = new Vertex(d11, d13, d14, d3, d5, this.brightnessBottomRight, this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight, 1.0f);
            result.add(v);
            v = new Vertex(d11, d13, d15, d8, d10, this.brightnessTopRight, this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight, 1.0f);
            result.add(v);
        } else {
            Vertex v = new Vertex(d12, d13, d15, d4, d6);
            result.add(v);
            v = new Vertex(d12, d13, d14, d7, d9);
            result.add(v);
            v = new Vertex(d11, d13, d14, d3, d5);
            result.add(v);
            v = new Vertex(d11, d13, d15, d8, d10);
            result.add(v);
        }
        return result;
    }

    private List<Vertex> calcFaceZPos(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.instance;
        if (this.hasOverrideBlockTexture()) {
            par8Icon = this.overrideBlockTexture;
        }
        double d3 = par8Icon.getInterpolatedU(this.renderMinX * 16.0);
        double d4 = par8Icon.getInterpolatedU(this.renderMaxX * 16.0);
        double d5 = par8Icon.getInterpolatedV(16.0 - this.renderMaxY * 16.0);
        double d6 = par8Icon.getInterpolatedV(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = par8Icon.getMinU();
            d4 = par8Icon.getMaxU();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = par8Icon.getMinV();
            d6 = par8Icon.getMaxV();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateWest == 1) {
            d3 = par8Icon.getInterpolatedU(this.renderMinY * 16.0);
            d6 = par8Icon.getInterpolatedV(16.0 - this.renderMinX * 16.0);
            d4 = par8Icon.getInterpolatedU(this.renderMaxY * 16.0);
            d9 = d5 = (double)par8Icon.getInterpolatedV(16.0 - this.renderMaxX * 16.0);
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateWest == 2) {
            d3 = par8Icon.getInterpolatedU(16.0 - this.renderMaxY * 16.0);
            d5 = par8Icon.getInterpolatedV(this.renderMinX * 16.0);
            d4 = par8Icon.getInterpolatedU(16.0 - this.renderMinY * 16.0);
            d6 = par8Icon.getInterpolatedV(this.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateWest == 3) {
            d3 = par8Icon.getInterpolatedU(16.0 - this.renderMinX * 16.0);
            d4 = par8Icon.getInterpolatedU(16.0 - this.renderMaxX * 16.0);
            d5 = par8Icon.getInterpolatedV(this.renderMaxY * 16.0);
            d6 = par8Icon.getInterpolatedV(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + this.renderMinX;
        double d12 = par2 + this.renderMaxX;
        double d13 = par4 + this.renderMinY;
        double d14 = par4 + this.renderMaxY;
        double d15 = par6 + this.renderMaxZ;
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        if (this.enableAO) {
            result.add(new Vertex(d11, d14, d15, d3, d5, this.brightnessTopLeft, this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft, 1.0f));
            result.add(new Vertex(d11, d13, d15, d8, d10, this.brightnessBottomLeft, this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft, 1.0f));
            result.add(new Vertex(d12, d13, d15, d4, d6, this.brightnessBottomRight, this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight, 1.0f));
            result.add(new Vertex(d12, d14, d15, d7, d9, this.brightnessTopRight, this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight, 1.0f));
        } else {
            result.add(new Vertex(d11, d14, d15, d3, d5));
            result.add(new Vertex(d11, d13, d15, d8, d10));
            result.add(new Vertex(d12, d13, d15, d4, d6));
            result.add(new Vertex(d12, d14, d15, d7, d9));
        }
        return result;
    }

    private List<Vertex> calcFaceZNeg(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        if (this.hasOverrideBlockTexture()) {
            par8Icon = this.overrideBlockTexture;
        }
        double d3 = par8Icon.getInterpolatedU(this.renderMinX * 16.0);
        double d4 = par8Icon.getInterpolatedU(this.renderMaxX * 16.0);
        double d5 = par8Icon.getInterpolatedV(16.0 - this.renderMaxY * 16.0);
        double d6 = par8Icon.getInterpolatedV(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = par8Icon.getMinU();
            d4 = par8Icon.getMaxU();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = par8Icon.getMinV();
            d6 = par8Icon.getMaxV();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateEast == 2) {
            d3 = par8Icon.getInterpolatedU(this.renderMinY * 16.0);
            d5 = par8Icon.getInterpolatedV(16.0 - this.renderMinX * 16.0);
            d4 = par8Icon.getInterpolatedU(this.renderMaxY * 16.0);
            d6 = par8Icon.getInterpolatedV(16.0 - this.renderMaxX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateEast == 1) {
            d3 = par8Icon.getInterpolatedU(16.0 - this.renderMaxY * 16.0);
            d5 = par8Icon.getInterpolatedV(this.renderMaxX * 16.0);
            d4 = par8Icon.getInterpolatedU(16.0 - this.renderMinY * 16.0);
            d6 = par8Icon.getInterpolatedV(this.renderMinX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateEast == 3) {
            d3 = par8Icon.getInterpolatedU(16.0 - this.renderMinX * 16.0);
            d4 = par8Icon.getInterpolatedU(16.0 - this.renderMaxX * 16.0);
            d5 = par8Icon.getInterpolatedV(this.renderMaxY * 16.0);
            d6 = par8Icon.getInterpolatedV(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + this.renderMinX;
        double d12 = par2 + this.renderMaxX;
        double d13 = par4 + this.renderMinY;
        double d14 = par4 + this.renderMaxY;
        double d15 = par6 + this.renderMinZ;
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        if (this.enableAO) {
            result.add(new Vertex(d11, d14, d15, d7, d9, this.brightnessTopLeft, this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft, 1.0f));
            result.add(new Vertex(d12, d14, d15, d3, d5, this.brightnessBottomLeft, this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft, 1.0f));
            result.add(new Vertex(d12, d13, d15, d8, d10, this.brightnessBottomRight, this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight, 1.0f));
            result.add(new Vertex(d11, d13, d15, d4, d6, this.brightnessTopRight, this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight, 1.0f));
        } else {
            result.add(new Vertex(d11, d14, d15, d7, d9));
            result.add(new Vertex(d12, d14, d15, d3, d5));
            result.add(new Vertex(d12, d13, d15, d8, d10));
            result.add(new Vertex(d11, d13, d15, d4, d6));
        }
        return result;
    }

    private List<Vertex> calcFaceXPos(Block par1Block, double par2, double par4, double par6, IIcon par8Icon) {
        double d7;
        Tessellator tessellator = Tessellator.instance;
        if (this.hasOverrideBlockTexture()) {
            par8Icon = this.overrideBlockTexture;
        }
        double d3 = par8Icon.getInterpolatedU(this.renderMinZ * 16.0);
        double d4 = par8Icon.getInterpolatedU(this.renderMaxZ * 16.0);
        double d5 = par8Icon.getInterpolatedV(16.0 - this.renderMaxY * 16.0);
        double d6 = par8Icon.getInterpolatedV(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d3 = par8Icon.getMinU();
            d4 = par8Icon.getMaxU();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = par8Icon.getMinV();
            d6 = par8Icon.getMaxV();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateSouth == 2) {
            d3 = par8Icon.getInterpolatedU(this.renderMinY * 16.0);
            d5 = par8Icon.getInterpolatedV(16.0 - this.renderMinZ * 16.0);
            d4 = par8Icon.getInterpolatedU(this.renderMaxY * 16.0);
            d6 = par8Icon.getInterpolatedV(16.0 - this.renderMaxZ * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateSouth == 1) {
            d3 = par8Icon.getInterpolatedU(16.0 - this.renderMaxY * 16.0);
            d5 = par8Icon.getInterpolatedV(this.renderMaxZ * 16.0);
            d4 = par8Icon.getInterpolatedU(16.0 - this.renderMinY * 16.0);
            d6 = par8Icon.getInterpolatedV(this.renderMinZ * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateSouth == 3) {
            d3 = par8Icon.getInterpolatedU(16.0 - this.renderMinZ * 16.0);
            d4 = par8Icon.getInterpolatedU(16.0 - this.renderMaxZ * 16.0);
            d5 = par8Icon.getInterpolatedV(this.renderMaxY * 16.0);
            d6 = par8Icon.getInterpolatedV(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = par2 + this.renderMaxX;
        double d12 = par4 + this.renderMinY;
        double d13 = par4 + this.renderMaxY;
        double d14 = par6 + this.renderMinZ;
        double d15 = par6 + this.renderMaxZ;
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        if (this.enableAO) {
            result.add(new Vertex(d11, d12, d15, d8, d10, this.brightnessTopLeft, this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft, 1.0f));
            result.add(new Vertex(d11, d12, d14, d4, d6, this.brightnessBottomLeft, this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft, 1.0f));
            result.add(new Vertex(d11, d13, d14, d7, d9, this.brightnessBottomRight, this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight, 1.0f));
            result.add(new Vertex(d11, d13, d15, d3, d5, this.brightnessTopRight, this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight, 1.0f));
        } else {
            result.add(new Vertex(d11, d12, d15, d8, d10));
            result.add(new Vertex(d11, d12, d14, d4, d6));
            result.add(new Vertex(d11, d13, d14, d7, d9));
            result.add(new Vertex(d11, d13, d15, d3, d5));
        }
        return result;
    }

    private List<Vertex> calcFaceYNeg(Block par1Block, double x, double y, double z, IIcon icon) {
        if (this.hasOverrideBlockTexture()) {
            icon = this.overrideBlockTexture;
        }
        double minU = icon.getInterpolatedU(this.renderMinX * 16.0);
        double maxU = icon.getInterpolatedU(this.renderMaxX * 16.0);
        double minV = icon.getInterpolatedV(this.renderMinZ * 16.0);
        double maxV = icon.getInterpolatedV(this.renderMaxZ * 16.0);
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            minU = icon.getMinU();
            maxU = icon.getMaxU();
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            minV = icon.getMinV();
            maxV = icon.getMaxV();
        }
        double d7 = maxU;
        double d8 = minU;
        double d9 = minV;
        double d10 = maxV;
        if (this.uvRotateBottom == 2) {
            minU = icon.getInterpolatedU(this.renderMinZ * 16.0);
            minV = icon.getInterpolatedV(16.0 - this.renderMaxX * 16.0);
            maxU = icon.getInterpolatedU(this.renderMaxZ * 16.0);
            maxV = icon.getInterpolatedV(16.0 - this.renderMinX * 16.0);
            d9 = minV;
            d10 = maxV;
            d7 = minU;
            d8 = maxU;
            minV = maxV;
            maxV = d9;
        } else if (this.uvRotateBottom == 1) {
            minU = icon.getInterpolatedU(16.0 - this.renderMaxZ * 16.0);
            minV = icon.getInterpolatedV(this.renderMinX * 16.0);
            maxU = icon.getInterpolatedU(16.0 - this.renderMinZ * 16.0);
            maxV = icon.getInterpolatedV(this.renderMaxX * 16.0);
            d7 = maxU;
            d8 = minU;
            minU = maxU;
            maxU = d8;
            d9 = maxV;
            d10 = minV;
        } else if (this.uvRotateBottom == 3) {
            minU = icon.getInterpolatedU(16.0 - this.renderMinX * 16.0);
            maxU = icon.getInterpolatedU(16.0 - this.renderMaxX * 16.0);
            minV = icon.getInterpolatedV(16.0 - this.renderMinZ * 16.0);
            maxV = icon.getInterpolatedV(16.0 - this.renderMaxZ * 16.0);
            d7 = maxU;
            d8 = minU;
            d9 = minV;
            d10 = maxV;
        }
        double minX = x + this.renderMinX;
        double maxX = x + this.renderMaxX;
        double minY = y + this.renderMinY;
        double minZ = z + this.renderMinZ;
        double maxZ = z + this.renderMaxZ;
        ArrayList<Vertex> result = new ArrayList<Vertex>(4);
        if (this.enableAO) {
            Vertex v = new Vertex(minX, minY, maxZ, d8, d10, this.brightnessTopLeft, this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft, 1.0f);
            result.add(v);
            v = new Vertex(minX, minY, minZ, minU, minV, this.brightnessBottomLeft, this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft, 1.0f);
            result.add(v);
            v = new Vertex(maxX, minY, minZ, d7, d9, this.brightnessBottomRight, this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight, 1.0f);
            result.add(v);
            v = new Vertex(maxX, minY, maxZ, maxU, maxV, this.brightnessTopRight, this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight, 1.0f);
            result.add(v);
        } else {
            Vertex v = new Vertex(minX, minY, maxZ, d8, d10);
            result.add(v);
            v = new Vertex(minX, minY, minZ, minU, minV);
            result.add(v);
            v = new Vertex(maxX, minY, minZ, d7, d9);
            result.add(v);
            v = new Vertex(maxX, minY, maxZ, maxU, maxV);
            result.add(v);
        }
        return result;
    }
}

