/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.command;

import com.enderio.core.EnderCore;
import com.enderio.core.common.event.ConfigFileChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.commons.lang3.ArrayUtils;

public class CommandReloadConfigs
extends CommandBase {
    public static final CommandReloadConfigs SERVER = new CommandReloadConfigs(Side.SERVER);
    public static final CommandReloadConfigs CLIENT = new CommandReloadConfigs(Side.CLIENT);
    private static List<String> validModIDs = new ArrayList<String>();
    private final Side side;

    public String getCommandName() {
        return this.side == Side.SERVER ? "reloadServerConfigs" : "reloadConfigs";
    }

    public String getCommandUsage(ICommandSender p_71518_1_) {
        return "/" + this.getCommandName() + " <modid> (<modid2> <modid3> ...)";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public boolean canCommandSenderUseCommand(ICommandSender player) {
        return player.getEntityWorld().isRemote || super.canCommandSenderUseCommand(player);
    }

    public List addTabCompletionOptions(ICommandSender player, String[] args) {
        if (args.length >= 1) {
            Object[] avail = validModIDs.toArray(new String[validModIDs.size()]);
            for (int i = 0; i < args.length - 1; ++i) {
                avail = (String[])ArrayUtils.removeElement((Object[])avail, (Object)args[i]);
            }
            return CommandReloadConfigs.getListOfStringsMatchingLastWord((String[])args, (String[])avail);
        }
        return null;
    }

    public void processCommand(ICommandSender player, String[] args) {
        if (this.side == Side.CLIENT == player.getEntityWorld().isRemote) {
            for (String s : args) {
                boolean validModid = false;
                for (ModContainer mod : Loader.instance().getModObjectList().keySet()) {
                    if (!mod.getModId().equals(s)) continue;
                    validModid = true;
                }
                if (validModid) {
                    ConfigFileChangedEvent event = new ConfigFileChangedEvent(s);
                    FMLCommonHandler.instance().bus().post((Event)event);
                    if (event.isSuccessful()) {
                        this.sendResult(player, s, "success");
                        continue;
                    }
                    this.sendResult(player, s, "fail");
                    continue;
                }
                this.sendResult(player, s, "invalid");
            }
        }
    }

    private void sendResult(ICommandSender player, String modid, String result) {
        player.addChatMessage((IChatComponent)new ChatComponentText(EnderCore.lang.localize("command.config.result." + result, modid)));
    }

    private CommandReloadConfigs(Side side) {
        this.side = side;
    }

    static {
        EnderCore.logger.info("Sending dummy event to all mods");
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            ConfigFileChangedEvent event = new ConfigFileChangedEvent(mod.getModId());
            FMLCommonHandler.instance().bus().post((Event)event);
            if (!event.isSuccessful()) continue;
            validModIDs.add(mod.getModId());
        }
    }
}

