/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandScoreboardInfo
extends CommandBase {
    public String getCommandName() {
        return "scoreboardinfo";
    }

    public String getCommandUsage(ICommandSender p_71518_1_) {
        return "/scoreboardinfo <board> <name>";
    }

    public int getRequiredPermissionLevel() {
        return 0;
    }

    public boolean canCommandSenderUseCommand(ICommandSender p_71519_1_) {
        return true;
    }

    public void processCommand(ICommandSender player, String[] args) {
        if (args.length < 2) {
            throw new WrongUsageException("This command requires 2 args: <board> <name>", new Object[0]);
        }
        Scoreboard board = player.getEntityWorld().getScoreboard();
        ScoreObjective obj = board.getObjective(args[0]);
        if (obj == null) {
            player.addChatMessage((IChatComponent)new ChatComponentText("No such board " + args[0]));
        }
        Collection collection = board.func_96534_i(obj);
        for (Score score : collection) {
            if (!score.getPlayerName().equals(args[1])) continue;
            player.addChatMessage((IChatComponent)new ChatComponentText(args[1] + "'s score on board \"" + args[0] + "\": " + score.getScorePoints()));
            return;
        }
        player.addChatMessage((IChatComponent)new ChatComponentText("No score for " + args[1] + " on board \"" + args[0] + "\""));
    }

    public List addTabCompletionOptions(ICommandSender player, String[] args) {
        if (args.length == 1) {
            ArrayList<String> boards = new ArrayList<String>();
            for (ScoreObjective obj : player.getEntityWorld().getScoreboard().getScoreObjectives()) {
                boards.add(obj.getName());
            }
            return CommandScoreboardInfo.getListOfStringsFromIterableMatchingLastWord((String[])args, boards);
        }
        if (args.length == 2) {
            ArrayList<String> players = new ArrayList<String>();
            for (EntityPlayer p : player.getEntityWorld().playerEntities) {
                players.add(p.getCommandSenderName());
            }
            return CommandScoreboardInfo.getListOfStringsFromIterableMatchingLastWord((String[])args, players);
        }
        return null;
    }
}

