/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.handlers;

import com.enderio.core.common.Handlers;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

@Handlers.Handler
public class RightClickCropHandler {
    private List<PlantInfo> plants = Lists.newArrayList();
    private PlantInfo currentPlant = null;
    public static final RightClickCropHandler INSTANCE = new RightClickCropHandler();

    private RightClickCropHandler() {
    }

    public void addCrop(PlantInfo info) {
        this.plants.add(info);
    }

    @SubscribeEvent
    public void handleCropRightClick(PlayerInteractEvent event) {
        int x = event.x;
        int y = event.y;
        int z = event.z;
        Block block = event.world.getBlock(x, y, z);
        int meta = event.world.getBlockMetadata(x, y, z);
        if (ConfigHandler.allowCropRC && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (event.entityPlayer.getHeldItem() == null || !event.entityPlayer.isSneaking())) {
            for (PlantInfo info : this.plants) {
                if (info.blockInst != block || meta != info.meta) continue;
                if (event.world.isRemote) {
                    event.entityPlayer.swingItem();
                    break;
                }
                this.currentPlant = info;
                block.dropBlockAsItem(event.world, x, y, z, meta, 0);
                this.currentPlant = null;
                event.world.setBlockMetadataWithNotify(x, y, z, info.resetMeta, 3);
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onHarvestDrop(BlockEvent.HarvestDropsEvent event) {
        if (this.currentPlant != null) {
            for (int i = 0; i < event.drops.size(); ++i) {
                ItemStack stack = (ItemStack)event.drops.get(i);
                if (stack.getItem() != this.currentPlant.seedStack.getItem() || this.currentPlant.seedStack.getItemDamage() != Short.MAX_VALUE && stack.getItemDamage() != this.currentPlant.seedStack.getItemDamage()) continue;
                event.drops.remove(i);
                break;
            }
        }
    }

    public static class PlantInfo {
        public String seed;
        public String block;
        public int meta = 7;
        public int resetMeta = 0;
        private transient ItemStack seedStack;
        private transient Block blockInst;

        public PlantInfo(String seed, String block, int meta, int resetMeta) {
            this.seed = seed;
            this.block = block;
            this.meta = meta;
            this.resetMeta = resetMeta;
        }

        public void init() {
            this.seedStack = ItemUtil.parseStringIntoItemStack(this.seed);
            String[] blockinfo = this.block.split(":");
            this.blockInst = GameRegistry.findBlock((String)blockinfo[0], (String)blockinfo[1]);
        }

        public PlantInfo() {
        }
    }
}

