/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCoord {
    public final int x;
    public final int y;
    public final int z;

    public BlockCoord() {
        this(0, 0, 0);
    }

    public BlockCoord(double x, double y, double z) {
        this(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public BlockCoord(TileEntity tile) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public BlockCoord(Entity e) {
        this(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public BlockCoord(BlockCoord bc) {
        this(bc.x, bc.y, bc.z);
    }

    public BlockCoord getLocation(ForgeDirection dir) {
        return new BlockCoord(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
    }

    public BlockCoord(String x, String y, String z) {
        this(Strings.isNullOrEmpty((String)x) ? 0 : Integer.parseInt(x), Strings.isNullOrEmpty((String)y) ? 0 : Integer.parseInt(y), Strings.isNullOrEmpty((String)z) ? 0 : Integer.parseInt(z));
    }

    public BlockCoord(MovingObjectPosition mop) {
        this(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public int getMetadata(IBlockAccess world) {
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public int getDistSq(BlockCoord other) {
        int xDiff = this.x - other.x;
        int yDiff = this.y - other.y;
        int zDiff = this.z - other.z;
        return xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
    }

    public int getDistSq(TileEntity other) {
        return this.getDistSq(new BlockCoord(other));
    }

    public int getDist(BlockCoord other) {
        double dsq = this.getDistSq(other);
        return (int)Math.ceil(Math.sqrt(dsq));
    }

    public int getDist(TileEntity other) {
        return this.getDist(new BlockCoord(other));
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static BlockCoord readFromBuf(ByteBuf buf) {
        return new BlockCoord(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("bc:x", this.x);
        tag.func_74768_a("bc:y", this.y);
        tag.func_74768_a("bc:z", this.z);
    }

    public static BlockCoord readFromNBT(NBTTagCompound tag) {
        return new BlockCoord(tag.func_74762_e("bc:x"), tag.func_74762_e("bc:y"), tag.func_74762_e("bc:z"));
    }

    public String chatString() {
        return this.chatString(EnumChatFormatting.WHITE);
    }

    public String chatString(EnumChatFormatting defaultColor) {
        return String.format("x%s%d%s y%s%d%s z%s%d", EnumChatFormatting.GREEN, this.x, defaultColor, EnumChatFormatting.GREEN, this.y, defaultColor, EnumChatFormatting.GREEN, this.z);
    }

    public boolean equals(int x, int y, int z) {
        return this.equals(new BlockCoord(x, y, z));
    }

    public String toString() {
        return "X: " + this.x + "  Y: " + this.y + "  Z: " + this.z;
    }

    @ConstructorProperties(value={"x", "y", "z"})
    public BlockCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockCoord)) {
            return false;
        }
        BlockCoord other = (BlockCoord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockCoord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.x;
        result = result * 59 + this.y;
        result = result * 59 + this.z;
        return result;
    }

    public BlockCoord withX(int x) {
        return this.x == x ? this : new BlockCoord(x, this.y, this.z);
    }

    public BlockCoord withY(int y) {
        return this.y == y ? this : new BlockCoord(this.x, y, this.z);
    }

    public BlockCoord withZ(int z) {
        return this.z == z ? this : new BlockCoord(this.x, this.y, z);
    }
}

