/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.bettermodlist;

import com.enderio.core.EnderCore;
import com.enderio.core.common.config.ConfigHandler;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.client.GuiScrollingList;
import cpw.mods.fml.client.GuiSlotModList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.StringUtils;

public class GuiEnhancedModList
extends GuiModList {
    private static Field _mods;
    private static Field _selected;
    private static Field _selectedMod;
    private static Field _modList;
    private static Field _modListRight;
    private static Field _modListBottom;
    private static Field _modListMods;
    private static Field _listWidth;
    private static Field _scrollDistance;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private GuiTextField search;
    private boolean sorted = false;
    private SortType sortType = SortType.values()[ConfigHandler.defaultModSort];

    public GuiEnhancedModList(GuiScreen mainMenu) {
        super(mainMenu);
    }

    public void initGui() {
        float scroll = 0.0f;
        if (this.getGuiModList() != null) {
            scroll = this.getGuiModListScroll();
        }
        super.initGui();
        for (GuiButton button : this.buttonList) {
            if (button.id == 6) {
                int min = this.getGuiModListRight();
                int max = this.width;
                button.xPosition = (min + max) / 2 - button.width / 2;
                button.yPosition += 10;
                continue;
            }
            if (button.id != 20 && button.id != 21) continue;
            button.yPosition += 10;
        }
        this.setGuiModListBottom(this.getGuiModListBottom() - 25);
        if (this.search == null) {
            this.search = new GuiTextField(this.mc.fontRenderer, 12, this.getGuiModListBottom() + 17, this.getListWidth() - 4, 14);
            this.search.setFocused(true);
            this.search.setCanLoseFocus(true);
        }
        int width = this.getListWidth() / this.numButtons;
        int x = 10;
        int y = 10;
        GuiButton normalSort = new GuiButton(SortType.NORMAL.buttonID, x, y, width - this.buttonMargin, 20, EnderCore.lang.localize("gui.normal"));
        normalSort.enabled = false;
        this.buttonList.add(normalSort);
        this.buttonList.add(new GuiButton(SortType.A_TO_Z.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "A-Z"));
        this.buttonList.add(new GuiButton(SortType.Z_TO_A.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "Z-A"));
        this.buttonList.add(new InfoButton());
        this.reloadMods();
        this.disableButton();
        this.setGuiModListScroll(scroll);
    }

    public int drawLine(String line, int offset, int shifty) {
        String before = line.substring(0, line.indexOf(58) + 2);
        int followingLineOffset = this.fontRendererObj.getStringWidth(before);
        String[] manualSplit = line.split("\n");
        ArrayList split = Lists.newArrayList();
        for (String s : manualSplit) {
            split.addAll(this.fontRendererObj.listFormattedStringToWidth(s, this.width - offset));
        }
        for (int i = 0; i < split.size(); ++i) {
            this.fontRendererObj.drawString((String)split.get(i), offset + (i > 0 ? followingLineOffset : 0), shifty, 14151146);
            shifty += 10;
        }
        if (split.size() > 1) {
            shifty += 10;
        }
        return shifty;
    }

    protected void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        this.search.mouseClicked(x, y, button);
        if (button == 1 && x >= this.search.xPosition && x < this.search.xPosition + this.search.width && y >= this.search.yPosition && y < this.search.yPosition + this.search.height) {
            this.search.setText("");
        }
    }

    protected void keyTyped(char p_73869_1_, int p_73869_2_) {
        super.keyTyped(p_73869_1_, p_73869_2_);
        this.search.textboxKeyTyped(p_73869_1_, p_73869_2_);
    }

    public void updateScreen() {
        super.updateScreen();
        this.search.updateCursorCounter();
        if (!this.search.getText().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            Collections.sort(this.getMods(), this.sortType.comparator);
            this.setMods();
            this.sorted = true;
        }
    }

    private void reloadMods() {
        List<ModContainer> mods = this.getMods();
        mods.clear();
        for (ModContainer m : Loader.instance().getActiveModList()) {
            if (!m.getName().toLowerCase(Locale.US).contains(this.search.getText().toLowerCase(Locale.US)) || m.getMetadata().parentMod != null) continue;
            mods.add(m);
        }
        this.setMods();
        this.lastFilterText = this.search.getText();
    }

    public void drawScreen(int p_571_1_, int p_571_2_, float p_571_3_) {
        super.drawScreen(p_571_1_, p_571_2_, p_571_3_);
        String text = EnderCore.lang.localize("gui.search");
        int x = (10 + this.getGuiModListRight()) / 2 - this.mc.fontRenderer.getStringWidth(text) / 2;
        this.mc.fontRenderer.drawString(text, x, this.getGuiModListBottom() + 5, 0xFFFFFF);
        this.search.drawTextBox();
    }

    protected void actionPerformed(GuiButton button) {
        SortType type;
        super.actionPerformed(button);
        if (button.id == 30) {
            this.search.setText("");
            this.reloadMods();
            for (ModContainer m : this.getMods()) {
                if (!m.getName().equals("EnderCore")) continue;
                this.setSelectedMod(m);
                this.setMods();
            }
        }
        if ((type = SortType.getTypeForButton(button)) == null) {
            return;
        }
        this.sorted = false;
        this.sortType = type;
        this.disableButton();
        this.setMods();
    }

    private void disableButton() {
        for (GuiButton b : this.buttonList) {
            if (SortType.getTypeForButton(b) != null) {
                b.enabled = true;
            }
            if (b.id != this.sortType.buttonID) continue;
            b.enabled = false;
        }
    }

    private void setMods() {
        List<ModContainer> mods = this.getMods();
        ModContainer sel = this.getSelectedMod();
        boolean found = false;
        try {
            for (int i = 0; !found && i < mods.size(); ++i) {
                if (sel != mods.get(i)) continue;
                _selected.setInt((Object)this, i);
                found = true;
            }
            if (!found) {
                _selected.setInt((Object)this, -1);
                _selectedMod.set((Object)this, null);
            }
            _mods.set((Object)this, this.getMods());
            this.sorted = false;
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private GuiSlotModList getGuiModList() {
        try {
            return (GuiSlotModList)_modList.get((Object)this);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private int getGuiModListRight() {
        try {
            return _modListRight.getInt(this.getGuiModList());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void setGuiModListBottom(int bottom) {
        try {
            _modListBottom.set(this.getGuiModList(), bottom);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private int getGuiModListBottom() {
        try {
            return _modListBottom.getInt(this.getGuiModList());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private float getGuiModListScroll() {
        try {
            return _scrollDistance.getFloat(this.getGuiModList());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void setGuiModListScroll(float scroll) {
        try {
            _scrollDistance.setFloat(this.getGuiModList(), scroll);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private List<ModContainer> getMods() {
        try {
            return (List)_modListMods.get(_modList.get((Object)this));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private int getListWidth() {
        try {
            return _listWidth.getInt((Object)this);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private ModContainer getSelectedMod() {
        try {
            return (ModContainer)_selectedMod.get((Object)this);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void setSelectedMod(ModContainer mod) {
        try {
            _selectedMod.set((Object)this, mod);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    static {
        try {
            _mods = GuiModList.class.getDeclaredField("mods");
            _mods.setAccessible(true);
            _selected = GuiModList.class.getDeclaredField("selected");
            _selected.setAccessible(true);
            _selectedMod = GuiModList.class.getDeclaredField("selectedMod");
            _selectedMod.setAccessible(true);
            _modList = GuiModList.class.getDeclaredField("modList");
            _modList.setAccessible(true);
            _modListRight = GuiScrollingList.class.getDeclaredField("right");
            _modListRight.setAccessible(true);
            _modListBottom = GuiScrollingList.class.getDeclaredField("bottom");
            _modListBottom.setAccessible(true);
            _modListMods = GuiSlotModList.class.getDeclaredField("mods");
            _modListMods.setAccessible(true);
            _listWidth = GuiModList.class.getDeclaredField("listWidth");
            _listWidth.setAccessible(true);
            _scrollDistance = GuiScrollingList.class.getDeclaredField("scrollDistance");
            _scrollDistance.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class InfoButton
    extends GuiButton {
        public InfoButton() {
            super(30, GuiEnhancedModList.this.width - 22, 2, 20, 20, "?");
        }

        public void drawButton(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146123_n) {
                ModContainer sel = GuiEnhancedModList.this.getSelectedMod();
                this.displayString = sel != null && sel.getName().equals("EnderCore") ? EnderCore.lang.localize("gui.modlistinfo2") : EnderCore.lang.localize("gui.modlistinfo1");
                this.width = p_146112_1_.fontRenderer.getStringWidth(this.displayString) + 10;
                if (this.width % 2 != 0) {
                    ++this.width;
                }
                this.xPosition = GuiEnhancedModList.this.width - this.width - 2;
            } else {
                this.displayString = "?";
                this.width = 20;
                this.xPosition = GuiEnhancedModList.this.width - this.width - 2;
            }
            super.drawButton(p_146112_1_, p_146112_2_, p_146112_3_);
        }
    }

    private static class ModComparator
    implements Comparator<ModContainer> {
        private SortType type;

        private ModComparator(SortType type) {
            this.type = type;
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            String name1 = StringUtils.stripControlCodes((String)o1.getName()).toLowerCase(Locale.US);
            String name2 = StringUtils.stripControlCodes((String)o2.getName()).toLowerCase(Locale.US);
            switch (this.type) {
                case A_TO_Z: {
                    return name1.compareTo(name2);
                }
                case Z_TO_A: {
                    return name2.compareTo(name1);
                }
            }
            return 0;
        }
    }

    private static enum SortType {
        NORMAL(24),
        A_TO_Z(25),
        Z_TO_A(26);

        private final int buttonID;
        private final ModComparator comparator;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
            this.comparator = new ModComparator(this);
        }

        public static SortType getTypeForButton(GuiButton button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.id) continue;
                return t;
            }
            return null;
        }
    }
}

