/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.model.IEnderModel;
import com.enderio.core.common.util.ItemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class DirectionalModelRenderer<T extends TileEntity>
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private IModelCustom model;
    private ResourceLocation texture;
    private IEnderModel modelSMT;

    public DirectionalModelRenderer(ResourceLocation model, ResourceLocation texture) {
        this.model = AdvancedModelLoader.loadModel((ResourceLocation)model);
        this.texture = texture;
    }

    public DirectionalModelRenderer(IEnderModel model, ResourceLocation texture) {
        this.modelSMT = model;
        this.texture = texture;
    }

    private void renderDirectionalTileEntityAt(T tile, double x, double y, double z, int metaOverride) {
        int meta = this.getMetadata(tile, metaOverride);
        this.setup(x, y, z, metaOverride);
        this.rotate(this.getRotation(tile, metaOverride));
        this.renderModel(tile, meta);
    }

    protected final int getMetadata(T tile, int metaOverride) {
        return metaOverride >= 0 ? metaOverride : tile.getBlockMetadata();
    }

    protected void setup(double x, double y, double z, int metaOverride) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y - (metaOverride >= 0 ? 0.1f : 0.0f)), (float)((float)z + 0.5f));
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.texture);
    }

    protected int getRotation(T tile, int metaOverride) {
        return this.getMetadata(tile, metaOverride);
    }

    protected void rotate(int rotation) {
        switch (rotation) {
            case 1: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.5f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.5f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.5f, (float)-0.5f, (float)0.0f);
            }
        }
    }

    protected void renderModel(T tile, int meta) {
        if (this.model != null) {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.model.renderAll();
        } else {
            GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
            this.modelSMT.render(0.0625f);
        }
        GL11.glPopMatrix();
    }

    public void renderTileEntityAt(TileEntity tile, double x, double y, double z, float yaw) {
        this.renderDirectionalTileEntityAt(tile, x, y, z, -1);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK || helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        switch (type) {
            case ENTITY: {
                GL11.glTranslatef((float)-0.4f, (float)0.1f, (float)-0.4f);
                GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                break;
            }
            case EQUIPPED: {
                GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                GL11.glTranslatef((float)-0.1f, (float)0.2f, (float)0.5f);
                GL11.glRotatef((float)-40.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                break;
            }
            case FIRST_PERSON_MAP: {
                break;
            }
        }
        this.renderDirectionalTileEntityAt(null, 0.0, 0.0, 0.0, ItemUtil.getNBTTag(item).getInteger("storedMetaData"));
        GL11.glPopMatrix();
    }
}

