/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.tweaks;

import com.enderio.core.common.tweaks.InfiniBow;
import com.enderio.core.common.tweaks.SlabRecipes;
import com.enderio.core.common.tweaks.Tweak;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class Tweaks {
    private static final List<Tweak> tweaks = new ArrayList<Tweak>();

    public static void loadIngameTweaks() {
        tweaks.add(new Tweak("fixBedSound", "Makes the bed stepSound wool instead of stone"){

            @Override
            public void load() {
                Blocks.bed.setStepSound(Block.soundTypeCloth);
            }
        });
        tweaks.add(new Tweak("changeBoatStackSize", "Makes boats stack to 16"){

            @Override
            public void load() {
                Items.boat.setMaxStackSize(16);
            }
        });
        tweaks.add(new Tweak("fixPackedIceTool", "Allows packed ice to be mined with a pickaxe"){

            @Override
            public void load() {
                Blocks.packed_ice.setHarvestLevel("pickaxe", 0);
            }
        });
    }

    public static void loadNonIngameTweaks() {
        tweaks.add(new SlabRecipes());
        tweaks.add(new InfiniBow());
        tweaks.add(new Tweak("bookToPaperRecipe", "Adds shapeless recipe from 1 book to 2 paper"){

            @Override
            public void load() {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.paper, 2), (Object[])new Object[]{Items.book});
            }
        });
        tweaks.add(new Tweak("shapelessPaperRecipe", "Adds a shapeless recipe for paper"){

            @Override
            public void load() {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.paper, 3), (Object[])new Object[]{Items.reeds, Items.reeds, Items.reeds});
            }
        });
    }
}

