/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.button.CycleButton;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterContainer;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.item.filter.FuzzyMode;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.gui.IconEIO;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class BasicItemFilterGui
implements IItemFilterGui {
    private static final int ID_WHITELIST = GuiExternalConnection.nextButtonId();
    private static final int ID_NBT = GuiExternalConnection.nextButtonId();
    private static final int ID_META = GuiExternalConnection.nextButtonId();
    private static final int ID_ORE_DICT = GuiExternalConnection.nextButtonId();
    private static final int ID_STICKY = GuiExternalConnection.nextButtonId();
    private static final int ID_FUZZY = GuiExternalConnection.nextButtonId();
    private final GuiContainerBase gui;
    private final ToggleButton useMetaB;
    private final ToggleButton useNbtB;
    private final IconButton whiteListB;
    private final ToggleButton useOreDictB;
    private final ToggleButton stickyB;
    private final CycleButton<FuzzyMode> fuzzyB;
    final boolean isAdvanced;
    final boolean isStickyModeAvailable;
    private final IItemFilterContainer filterContainer;
    private final ItemFilter filter;
    private int buttonIdOffset;
    private int xOffset;
    private int yOffset;

    public BasicItemFilterGui(GuiContainerBase gui, IItemFilterContainer filterContainer, boolean isStickyModeAvailable) {
        this(gui, filterContainer, isStickyModeAvailable, 32, 68, 0);
    }

    public BasicItemFilterGui(GuiContainerBase gui, IItemFilterContainer filterContainer, boolean isStickyModeAvailable, int xOffset, int yOffset, int buttonIdOffset) {
        int butLeft;
        this.gui = gui;
        this.isStickyModeAvailable = isStickyModeAvailable;
        this.filterContainer = filterContainer;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.buttonIdOffset = buttonIdOffset;
        this.filter = filterContainer.getItemFilter();
        this.isAdvanced = this.filter.isAdvanced();
        int x = butLeft = xOffset + 92;
        int y = yOffset + 1;
        this.whiteListB = new IconButton((IGuiScreen)gui, ID_WHITELIST + buttonIdOffset, x, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.whitelist")});
        this.useMetaB = new ToggleButton((IGuiScreen)gui, ID_META + buttonIdOffset, x += 20, y, (IWidgetIcon)IconEIO.FILTER_META_OFF, (IWidgetIcon)IconEIO.FILTER_META);
        this.useMetaB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.matchMetaData")});
        this.useMetaB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.ignoreMetaData")});
        this.useMetaB.setPaintSelectedBorder(false);
        this.stickyB = new ToggleButton((IGuiScreen)gui, ID_STICKY + buttonIdOffset, x += 20, y, (IWidgetIcon)IconEIO.FILTER_STICKY_OFF, (IWidgetIcon)IconEIO.FILTER_STICKY);
        this.stickyB.setSelectedToolTip(EnderIO.lang.localizeList("gui.conduit.item.stickyEnabled"));
        this.stickyB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.stickyDisbaled")});
        this.stickyB.setPaintSelectedBorder(false);
        x = butLeft;
        this.useOreDictB = new ToggleButton((IGuiScreen)gui, ID_ORE_DICT + buttonIdOffset, x, y += 20, (IWidgetIcon)IconEIO.FILTER_ORE_DICT_OFF, (IWidgetIcon)IconEIO.FILTER_ORE_DICT);
        this.useOreDictB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.oreDicEnabled")});
        this.useOreDictB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.oreDicDisabled")});
        this.useOreDictB.setPaintSelectedBorder(false);
        this.useNbtB = new ToggleButton((IGuiScreen)gui, ID_NBT + buttonIdOffset, x += 20, y, (IWidgetIcon)IconEIO.FILTER_NBT_OFF, (IWidgetIcon)IconEIO.FILTER_NBT);
        this.useNbtB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.matchNBT")});
        this.useNbtB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.ignoreNBT")});
        this.useNbtB.setPaintSelectedBorder(false);
        this.fuzzyB = new CycleButton((IGuiScreen)gui, ID_FUZZY + buttonIdOffset, x += 20, y, FuzzyMode.class);
    }

    public void createFilterSlots() {
        this.filter.createGhostSlots(this.gui.getGhostSlots(), this.xOffset + 1, this.yOffset + 1, new Runnable(){

            @Override
            public void run() {
                BasicItemFilterGui.this.sendFilterChange();
            }
        });
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
    }

    @Override
    public void updateButtons() {
        ItemFilter activeFilter = this.filter;
        if (this.isAdvanced) {
            this.useNbtB.onGuiInit();
            this.useNbtB.setSelected(activeFilter.isMatchNBT());
            this.useOreDictB.onGuiInit();
            this.useOreDictB.setSelected(activeFilter.isUseOreDict());
            if (this.isStickyModeAvailable) {
                this.stickyB.onGuiInit();
                this.stickyB.setSelected(activeFilter.isSticky());
            }
            this.fuzzyB.onGuiInit();
            this.fuzzyB.setMode((Enum)activeFilter.getFuzzyMode());
        }
        this.useMetaB.onGuiInit();
        this.useMetaB.setSelected(activeFilter.isMatchMeta());
        this.whiteListB.onGuiInit();
        if (activeFilter.isBlacklist()) {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.blacklist")});
        } else {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.whitelist")});
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        if (guiButton.field_146127_k == ID_META + this.buttonIdOffset) {
            this.filter.setMatchMeta(this.useMetaB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_NBT + this.buttonIdOffset) {
            this.filter.setMatchNBT(this.useNbtB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_STICKY + this.buttonIdOffset) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_ORE_DICT + this.buttonIdOffset) {
            this.filter.setUseOreDict(this.useOreDictB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_FUZZY + this.buttonIdOffset) {
            this.filter.setFuzzyMode((FuzzyMode)this.fuzzyB.getMode());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_WHITELIST + this.buttonIdOffset) {
            this.filter.setBlacklist(!this.filter.isBlacklist());
            this.sendFilterChange();
        }
    }

    private void sendFilterChange() {
        this.updateButtons();
        this.filterContainer.onFilterChanged();
    }

    @Override
    public void deactivate() {
        this.useNbtB.detach();
        this.useMetaB.detach();
        this.useOreDictB.detach();
        this.whiteListB.detach();
        this.stickyB.detach();
        this.fuzzyB.detach();
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)"enderio:textures/gui/itemFilter.png");
        this.gui.func_73729_b(this.gui.getGuiLeft() + this.xOffset, this.gui.getGuiTop() + this.yOffset, 0, 238, 90, 18);
        if (this.filter.isAdvanced()) {
            this.gui.func_73729_b(this.gui.getGuiLeft() + this.xOffset, this.gui.getGuiTop() + this.yOffset + 20, 0, 238, 90, 18);
        }
    }
}

