/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.AbstractMachineRecipe;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.vat.VatRecipe;
import crazypants.enderio.machine.vat.VatRecipeManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class VatMachineRecipe
extends AbstractMachineRecipe {
    @Override
    public String getUid() {
        return "StillRecipe";
    }

    @Override
    public IRecipe getRecipeForInputs(MachineRecipeInput[] inputs) {
        return VatRecipeManager.instance.getRecipeForInput(inputs);
    }

    @Override
    public boolean isValidInput(MachineRecipeInput input) {
        if (input == null) {
            return false;
        }
        return VatRecipeManager.instance.isValidInput(input);
    }

    @Override
    public String getMachineName() {
        return ModObject.blockVat.unlocalisedName;
    }

    @Override
    public List<MachineRecipeInput> getQuantitiesConsumed(MachineRecipeInput[] inputs) {
        ArrayList<MachineRecipeInput> result = new ArrayList<MachineRecipeInput>();
        VatRecipe rec = (VatRecipe)this.getRecipeForInputs(inputs);
        FluidStack inputFluidStack = rec.getRequiredFluidInput(inputs);
        result.add(new MachineRecipeInput(0, inputFluidStack));
        for (MachineRecipeInput ri : inputs) {
            if (ri.isFluid() || ri.item == null) continue;
            ItemStack st = ri.item.func_77946_l();
            st.field_77994_a = rec.getNumConsumed(ri.item);
            result.add(new MachineRecipeInput(ri.slotNumber, st));
        }
        return result;
    }

    @Override
    public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return new IMachineRecipe.ResultStack[0];
        }
        VatRecipe recipe = (VatRecipe)this.getRecipeForInputs(inputs);
        if (recipe == null || !recipe.isValid()) {
            return new IMachineRecipe.ResultStack[0];
        }
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(recipe.getFluidOutput(inputs))};
    }
}

