/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api.array;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class AlchemyArray
implements Comparable<AlchemyArray> {
    private ResourceLocation texture;
    private String unlocalizedName;
    private String className;
    private int lightLevel;
    private int chalkPerBlockCost;

    private AlchemyArray() {
    }

    public AlchemyArray(ResourceLocation texture, String unlocalizedName) {
        this.texture = texture;
        this.unlocalizedName = unlocalizedName;
        this.chalkPerBlockCost = 1;
        this.lightLevel = 0;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public void setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
    }

    public String getDisplayName() {
        return StatCollector.translateToLocal((String)this.unlocalizedName);
    }

    public int getChalkCostPerBlock() {
        return this.chalkPerBlockCost;
    }

    public void setChalkPerBlockCost(int chalkPerBlockCost) {
        this.chalkPerBlockCost = Math.abs(chalkPerBlockCost);
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public String getClassName() {
        return this.className;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null) {
            this.texture = nbtTagCompound.hasKey("textureDomain") && nbtTagCompound.hasKey("texturePath") ? new ResourceLocation(nbtTagCompound.getString("textureDomain"), nbtTagCompound.getString("texturePath")) : new ResourceLocation("");
            this.unlocalizedName = nbtTagCompound.hasKey("unlocalizedName") ? nbtTagCompound.getString("unlocalizedName") : "";
            this.className = nbtTagCompound.hasKey("className") ? nbtTagCompound.getString("className") : "";
            this.lightLevel = nbtTagCompound.hasKey("lightLevel") ? nbtTagCompound.getInteger("lightLevel") : 0;
        } else {
            this.texture = new ResourceLocation("");
            this.unlocalizedName = "";
            this.className = "";
            this.lightLevel = 0;
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.setString("textureDomain", this.texture.getResourceDomain());
        nbtTagCompound.setString("texturePath", this.texture.getResourcePath());
        nbtTagCompound.setString("unlocalizedName", this.unlocalizedName);
        nbtTagCompound.setString("className", this.getClass().getCanonicalName());
        nbtTagCompound.setInteger("lightLevel", this.lightLevel);
    }

    public static AlchemyArray readArrayFromNBT(NBTTagCompound nbtTagCompound) {
        AlchemyArray alchemyArray = new AlchemyArray();
        alchemyArray.readFromNBT(nbtTagCompound);
        return alchemyArray;
    }

    public void onArrayPlacedBy(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityLivingBase entityLiving, ItemStack itemStack) {
    }

    public void onArrayActivated(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
    }

    public void onArrayClicked(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityPlayer entityPlayer) {
    }

    public void onArrayDestroyedByExplosion(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Explosion explosion) {
    }

    public void onArrayDestroyedByPlayer(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, int metaData) {
    }

    public void onEntityCollidedWithArray(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Entity entity) {
    }

    public void onArrayFallenUpon(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Entity entity, float fallDistance) {
    }

    public void onUpdate(World world, int arrayX, int arrayY, int arrayZ, int tickCount) {
    }

    public boolean equals(Object object) {
        if (object instanceof AlchemyArray) {
            return this.compareTo((AlchemyArray)object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(AlchemyArray alchemyArray) {
        if (this.texture.getResourceDomain().equalsIgnoreCase(alchemyArray.getTexture().getResourceDomain())) {
            if (this.texture.getResourcePath().equalsIgnoreCase(alchemyArray.getTexture().getResourcePath())) {
                return 0;
            }
            return this.texture.getResourcePath().compareToIgnoreCase(alchemyArray.getTexture().getResourcePath());
        }
        return this.texture.getResourceDomain().compareToIgnoreCase(alchemyArray.getTexture().getResourceDomain());
    }
}

