/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.array;

import com.pahimar.ee3.api.array.AlchemyArray;
import com.pahimar.ee3.init.ModBlocks;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.tileentity.TileEntityAlchemyArray;
import com.pahimar.ee3.tileentity.TileEntityTransmutationTablet;
import com.pahimar.ee3.util.CommonParticleHelper;
import com.pahimar.ee3.util.CommonSoundHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TransmutationAlchemyArray
extends AlchemyArray
implements IInventory {
    private ItemStack[] inventory = new ItemStack[25];

    public TransmutationAlchemyArray() {
        super(Textures.AlchemyArray.TRANSMUTATION_ALCHEMY_ARRAY, "arrays.ee3:transmutation");
    }

    @Override
    public void onArrayActivated(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        block13: {
            if (world.isRemote || !entityPlayer.isSneaking()) break block13;
            boolean successFlag = false;
            if (world.getTileEntity(arrayX, arrayY, arrayZ) instanceof TileEntityAlchemyArray) {
                TileEntityAlchemyArray tileEntityAlchemyArray = (TileEntityAlchemyArray)world.getTileEntity(arrayX, arrayY, arrayZ);
                if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.UP && tileEntityAlchemyArray.getSize() == 2 && this.areBlocksValidForTransmutationTablet(world, arrayX, arrayY, arrayZ)) {
                    world.setBlock(arrayX - 1, arrayY - 1, arrayZ - 1, ModBlocks.ashInfusedStoneSlab, 1, 3);
                    world.setBlock(arrayX, arrayY - 1, arrayZ - 1, ModBlocks.ashInfusedStoneSlab, 2, 3);
                    world.setBlock(arrayX + 1, arrayY - 1, arrayZ - 1, ModBlocks.ashInfusedStoneSlab, 3, 3);
                    world.setBlock(arrayX - 1, arrayY - 1, arrayZ, ModBlocks.ashInfusedStoneSlab, 4, 3);
                    world.setBlock(arrayX, arrayY - 1, arrayZ, (Block)ModBlocks.transmutationTablet, 0, 3);
                    world.setBlock(arrayX + 1, arrayY - 1, arrayZ, ModBlocks.ashInfusedStoneSlab, 5, 3);
                    world.setBlock(arrayX - 1, arrayY - 1, arrayZ + 1, ModBlocks.ashInfusedStoneSlab, 6, 3);
                    world.setBlock(arrayX, arrayY - 1, arrayZ + 1, ModBlocks.ashInfusedStoneSlab, 7, 3);
                    world.setBlock(arrayX + 1, arrayY - 1, arrayZ + 1, ModBlocks.ashInfusedStoneSlab, 8, 3);
                    if (world.getTileEntity(arrayX, arrayY - 1, arrayZ) instanceof TileEntityTransmutationTablet) {
                        ((TileEntityTransmutationTablet)world.getTileEntity(arrayX, arrayY - 1, arrayZ)).setOrientation(tileEntityAlchemyArray.getOrientation());
                    }
                    this.ejectInventory(world, arrayX, arrayY, arrayZ);
                    successFlag = true;
                }
                if (successFlag) {
                    CommonSoundHelper.playSoundAtLocation(world.provider.dimensionId, arrayX, arrayY, arrayZ, "transmute", 1.0f, 1.0f);
                    if (tileEntityAlchemyArray.getSize() == 1) {
                        CommonParticleHelper.spawnParticleAtLocation("largesmoke", world.provider.dimensionId, (double)arrayX + 0.5, arrayY, (double)arrayZ + 0.5, 0.0, 0.1, 0.0);
                    } else if (tileEntityAlchemyArray.getSize() == 2) {
                        for (int i = -1; i <= 1; ++i) {
                            for (int j = -1; j <= 1; ++j) {
                                CommonParticleHelper.spawnParticleAtLocation("largesmoke", world.provider.dimensionId, (double)(arrayX + i) + 0.5, arrayY, (double)(arrayZ + j) + 0.5, 0.0, 0.1, 0.0);
                            }
                        }
                    } else if (tileEntityAlchemyArray.getSize() == 3) {
                        for (int i = -2; i <= 2; ++i) {
                            for (int j = -2; j <= 2; ++j) {
                                CommonParticleHelper.spawnParticleAtLocation("largesmoke", world.provider.dimensionId, (double)(arrayX + i) + 0.5, arrayY, (double)(arrayZ + j) + 0.5, 0.0, 0.1, 0.0);
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean areBlocksValidForTransmutationTablet(World world, int arrayX, int arrayY, int arrayZ) {
        boolean areBlocksValid = true;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (world.getBlock(arrayX + i, arrayY - 1, arrayZ + j) == ModBlocks.ashInfusedStone) continue;
                areBlocksValid = false;
            }
        }
        return areBlocksValid;
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        if (slotIndex < this.getSizeInventory()) {
            return this.inventory[slotIndex];
        }
        return null;
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            this.setInventorySlotContents(slotIndex, null);
        }
        return itemStack;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        if (slotIndex < this.getSizeInventory()) {
            this.inventory[slotIndex] = itemStack;
            if (itemStack != null && itemStack.stackSize > this.getInventoryStackLimit()) {
                itemStack.stackSize = this.getInventoryStackLimit();
            }
        }
    }

    public String getInventoryName() {
        return "arrays.ee3:transmutation";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        if (slotIndex < this.getSizeInventory()) {
            return itemStack.getItem() instanceof ItemBlock;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        NBTTagList tagList = nbtTagCompound.getTagList("Items", 10);
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
            byte slotIndex = tagCompound.getByte("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.getSizeInventory(); ++currentIndex) {
            if (this.getStackInSlot(currentIndex) == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setByte("Slot", (byte)currentIndex);
            this.getStackInSlot(currentIndex).writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag("Items", (NBTBase)tagList);
    }

    protected void ejectInventory(World world, int x, int y, int z) {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack itemStack = this.getStackInSlot(i);
            if (itemStack == null || itemStack.stackSize <= 0) continue;
            Random rand = new Random();
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), itemStack.copy());
            if (itemStack.hasTagCompound()) {
                entityItem.getEntityItem().setTagCompound((NBTTagCompound)itemStack.getTagCompound().copy());
            }
            float factor = 0.05f;
            entityItem.motionX = rand.nextGaussian() * (double)factor;
            entityItem.motionY = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.motionZ = rand.nextGaussian() * (double)factor;
            world.spawnEntityInWorld((Entity)entityItem);
            itemStack.stackSize = 0;
        }
    }
}

