/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.block.BlockEE;
import com.pahimar.ee3.reference.GUIs;
import com.pahimar.ee3.reference.RenderIds;
import com.pahimar.ee3.tileentity.TileEntityAlchemicalChest;
import com.pahimar.ee3.tileentity.TileEntityAlchemicalChestLarge;
import com.pahimar.ee3.tileentity.TileEntityAlchemicalChestMedium;
import com.pahimar.ee3.tileentity.TileEntityAlchemicalChestSmall;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAlchemicalChest
extends BlockEE
implements ITileEntityProvider {
    public BlockAlchemicalChest() {
        super(Material.wood);
        this.setHardness(2.5f);
        this.setBlockName("alchemicalChest");
        this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public TileEntity createNewTileEntity(World world, int metaData) {
        if (metaData == 0) {
            return new TileEntityAlchemicalChestSmall();
        }
        if (metaData == 1) {
            return new TileEntityAlchemicalChestMedium();
        }
        if (metaData == 2) {
            return new TileEntityAlchemicalChestLarge();
        }
        return null;
    }

    public int damageDropped(int metaData) {
        return metaData;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return RenderIds.alchemicalChest;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.isSneaking() && player.getCurrentEquippedItem() != null || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            return true;
        }
        if (!world.isRemote && world.getTileEntity(x, y, z) instanceof TileEntityAlchemicalChest) {
            player.openGui((Object)EquivalentExchange3.instance, GUIs.ALCHEMICAL_CHEST.ordinal(), world, x, y, z);
        }
        return true;
    }

    public boolean onBlockEventReceived(World world, int x, int y, int z, int eventId, int eventData) {
        super.onBlockEventReceived(world, x, y, z, eventId, eventData);
        TileEntity tileentity = world.getTileEntity(x, y, z);
        return tileentity != null && tileentity.receiveClientEvent(eventId, eventData);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < 3; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }
}

