/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.block.BlockEE;
import com.pahimar.ee3.reference.Names;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAlchemicalFuel
extends BlockEE {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] blockTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] blockSide;

    public BlockAlchemicalFuel() {
        this.setBlockName("alchemicalFuelBlock");
        this.setHardness(5.0f);
        this.setResistance(10.0f);
    }

    public Item getItemDropped(int par1, Random random, int par2) {
        return Item.getItemFromBlock((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < Names.Items.ALCHEMICAL_FUEL_SUBTYPES.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public int damageDropped(int metaData) {
        return metaData;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockTop = new IIcon[Names.Items.ALCHEMICAL_FUEL_SUBTYPES.length];
        this.blockSide = new IIcon[Names.Items.ALCHEMICAL_FUEL_SUBTYPES.length];
        for (int i = 0; i < Names.Items.ALCHEMICAL_FUEL_SUBTYPES.length; ++i) {
            this.blockTop[i] = iconRegister.registerIcon(String.format("%s.%s_top", this.getUnwrappedUnlocalizedName(this.getUnlocalizedName()), Names.Items.ALCHEMICAL_FUEL_SUBTYPES[i]));
            this.blockSide[i] = iconRegister.registerIcon(String.format("%s.%s_side", this.getUnwrappedUnlocalizedName(this.getUnlocalizedName()), Names.Items.ALCHEMICAL_FUEL_SUBTYPES[i]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metaData) {
        metaData = MathHelper.clamp_int((int)metaData, (int)0, (int)(Names.Items.ALCHEMICAL_FUEL_SUBTYPES.length - 1));
        if (ForgeDirection.getOrientation((int)side) == ForgeDirection.UP || ForgeDirection.getOrientation((int)side) == ForgeDirection.DOWN) {
            return this.blockTop[metaData];
        }
        return this.blockSide[metaData];
    }
}

