/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.block.BlockEE;
import com.pahimar.ee3.init.ModBlocks;
import com.pahimar.ee3.reference.GUIs;
import com.pahimar.ee3.reference.RenderIds;
import com.pahimar.ee3.tileentity.TileEntityAludel;
import com.pahimar.ee3.tileentity.TileEntityGlassBell;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAludel
extends BlockEE
implements ITileEntityProvider {
    public BlockAludel() {
        super(Material.anvil);
        this.setHardness(5.0f);
        this.setBlockName("aludel");
        this.setBlockBounds(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
    }

    public TileEntity createNewTileEntity(World world, int metaData) {
        return new TileEntityAludel();
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return RenderIds.aludel;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEntityAludel && ((TileEntityAludel)tile).getState() == 1) {
            switch (((TileEntityAludel)tile).getOrientation()) {
                case NORTH: {
                    world.spawnParticle("flame", (double)x + 0.5, (double)y + (double)0.33f, (double)z + (double)0.175f, 0.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    world.spawnParticle("flame", (double)x + 0.5, (double)y + (double)0.33f, (double)z + (double)0.825f, 0.0, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    world.spawnParticle("flame", (double)x + (double)0.175f, (double)y + (double)0.33f, (double)z + 0.5, 0.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    world.spawnParticle("flame", (double)x + (double)0.825f, (double)y + (double)0.33f, (double)z + 0.5, 0.0, 0.0, 0.0);
                }
            }
            world.spawnParticle("smoke", (double)x + 0.5, (double)y + (double)0.7f, (double)z + 0.0, 0.0, 0.05, 0.0);
            world.spawnParticle("smoke", (double)x + 0.5, (double)y + (double)0.7f, (double)z + 1.0, 0.0, 0.05, 0.0);
            world.spawnParticle("smoke", (double)x + 0.0, (double)y + (double)0.7f, (double)z + 0.5, 0.0, 0.05, 0.0);
            world.spawnParticle("smoke", (double)x + 1.0, (double)y + (double)0.7f, (double)z + 0.5, 0.0, 0.05, 0.0);
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        TileEntityAludel tileEntityAludel = (TileEntityAludel)world.getTileEntity(x, y, z);
        tileEntityAludel.hasGlassBell = world.getTileEntity(x, y + 1, z) instanceof TileEntityGlassBell;
        super.onNeighborBlockChange(world, x, y, z, block);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int faceHit, float par7, float par8, float par9) {
        if (player.isSneaking()) {
            return false;
        }
        if (!world.isRemote && world.getTileEntity(x, y, z) instanceof TileEntityAludel && world.getTileEntity(x, y + 1, z) instanceof TileEntityGlassBell) {
            player.openGui((Object)EquivalentExchange3.instance, GUIs.ALUDEL.ordinal(), world, x, y, z);
        }
        return !(world.getTileEntity(x, y, z) instanceof TileEntityAludel) || !ModBlocks.glassBell.canPlaceBlockAt(world, x, y + 1, z) || faceHit != ForgeDirection.UP.ordinal() || player.getHeldItem() == null || !(player.getHeldItem().getItem() instanceof ItemBlock) || ((ItemBlock)player.getHeldItem().getItem()).field_150939_a != ModBlocks.glassBell;
    }

    public boolean onBlockEventReceived(World world, int x, int y, int z, int eventId, int eventData) {
        super.onBlockEventReceived(world, x, y, z, eventId, eventData);
        TileEntity tileentity = world.getTileEntity(x, y, z);
        return tileentity != null && tileentity.receiveClientEvent(eventId, eventData);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityAludel && ((TileEntityAludel)world.getTileEntity(x, y, z)).getState() == 1) {
            return 15;
        }
        return super.getLightValue(world, x, y, z);
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        if (world.getTileEntity(x, y + 1, z) instanceof TileEntityGlassBell) {
            world.markBlockForUpdate(x, y + 1, z);
            world.func_147451_t(x, y + 1, z);
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.onBlockPlacedBy(world, x, y, z, entityLiving, itemStack);
        if (world.getTileEntity(x, y + 1, z) instanceof TileEntityGlassBell) {
            TileEntityGlassBell tileEntityGlassBell = (TileEntityGlassBell)world.getTileEntity(x, y + 1, z);
            tileEntityGlassBell.setOrientation(ForgeDirection.UP);
            if (world.getTileEntity(x, y, z) instanceof TileEntityAludel) {
                TileEntityAludel tileEntityAludel = (TileEntityAludel)world.getTileEntity(x, y, z);
                ItemStack itemStackGlassBell = tileEntityGlassBell.getStackInSlot(0);
                tileEntityGlassBell.setInventorySlotContents(0, null);
                tileEntityAludel.setInventorySlotContents(1, itemStackGlassBell);
                tileEntityAludel.hasGlassBell = true;
            }
        }
    }
}

