/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.block.BlockEE;
import com.pahimar.ee3.reference.GUIs;
import com.pahimar.ee3.reference.RenderIds;
import com.pahimar.ee3.tileentity.TileEntityCalcinator;
import java.util.Random;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCalcinator
extends BlockEE
implements ITileEntityProvider {
    public BlockCalcinator() {
        super(Material.rock);
        this.setHardness(2.0f);
        this.setBlockName("calcinator");
        this.setBlockBounds(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
    }

    public TileEntity createNewTileEntity(World world, int metaData) {
        return new TileEntityCalcinator();
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return RenderIds.calcinator;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityCalcinator && ((TileEntityCalcinator)world.getTileEntity(x, y, z)).getState() == 1) {
            world.spawnParticle("smoke", (double)x + 0.5, (double)y + (double)0.4f, (double)((float)z + 0.5f + (random.nextFloat() * 0.5f - 0.3f)), 0.0, 0.0, 0.0);
            world.spawnParticle("flame", (double)x + 0.5, (double)y + (double)0.4f, (double)z + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean onBlockEventReceived(World world, int x, int y, int z, int eventId, int eventData) {
        super.onBlockEventReceived(world, x, y, z, eventId, eventData);
        TileEntity tileentity = world.getTileEntity(x, y, z);
        return tileentity != null && tileentity.receiveClientEvent(eventId, eventData);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.isSneaking()) {
            return false;
        }
        if (!world.isRemote && world.getTileEntity(x, y, z) instanceof TileEntityCalcinator) {
            player.openGui((Object)EquivalentExchange3.instance, GUIs.CALCINATOR.ordinal(), world, x, y, z);
        }
        return true;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityCalcinator && ((TileEntityCalcinator)world.getTileEntity(x, y, z)).getState() == 1) {
            return 15;
        }
        return super.getLightValue(world, x, y, z);
    }
}

