/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.block.BlockEE;
import com.pahimar.ee3.reference.RenderIds;
import com.pahimar.ee3.tileentity.TileEntityAlchemyArray;
import com.pahimar.ee3.tileentity.TileEntityDummyArray;
import com.pahimar.ee3.tileentity.TileEntityEE;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDummyArray
extends BlockEE
implements ITileEntityProvider {
    public BlockDummyArray() {
        super(Material.circuits);
        this.setCreativeTab(null);
        this.setBlockName("dummyArray");
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return RenderIds.dummyArray;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityDummyArray) {
            TileEntityDummyArray tileEntityDummyArray = (TileEntityDummyArray)world.getTileEntity(x, y, z);
            return tileEntityDummyArray.getLightLevel();
        }
        return 0;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.getBlock(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) && (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN));
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int sideHit) {
        ForgeDirection side = ForgeDirection.getOrientation((int)sideHit);
        return world.getBlock(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) && (side == ForgeDirection.DOWN && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) || side == ForgeDirection.UP && world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || side == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || side == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || side == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || side == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST));
    }

    public int onBlockPlaced(World world, int x, int y, int z, int sideHit, float hitX, float hitY, float hitZ, int metaData) {
        return sideHit;
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        ((TileEntityEE)world.getTileEntity(x, y, z)).setOrientation(world.getBlockMetadata(x, y, z));
        world.setBlockMetadataWithNotify(x, y, z, world.getBlockMetadata(x, y, z), 3);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        TileEntityAlchemyArray tileEntityAlchemyArray;
        if (world.getTileEntity(x, y, z) instanceof TileEntityDummyArray && (tileEntityAlchemyArray = ((TileEntityDummyArray)world.getTileEntity(x, y, z)).getAssociatedTileEntity()) != null) {
            tileEntityAlchemyArray.onBlockActivated(world, x, y, z, tileEntityAlchemyArray.xCoord, tileEntityAlchemyArray.yCoord, tileEntityAlchemyArray.zCoord, entityPlayer, sideHit, hitX, hitY, hitZ);
        }
        return false;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        TileEntityAlchemyArray tileEntityAlchemyArray;
        if (world.getTileEntity(x, y, z) instanceof TileEntityDummyArray && (tileEntityAlchemyArray = ((TileEntityDummyArray)world.getTileEntity(x, y, z)).getAssociatedTileEntity()) != null) {
            tileEntityAlchemyArray.onBlockClicked(world, x, y, z, tileEntityAlchemyArray.xCoord, tileEntityAlchemyArray.yCoord, tileEntityAlchemyArray.zCoord, entityPlayer);
        }
    }

    public void onBlockDestroyedByExplosion(World world, int x, int y, int z, Explosion explosion) {
        TileEntityAlchemyArray tileEntityAlchemyArray;
        if (world.getTileEntity(x, y, z) instanceof TileEntityDummyArray && (tileEntityAlchemyArray = ((TileEntityDummyArray)world.getTileEntity(x, y, z)).getAssociatedTileEntity()) != null) {
            tileEntityAlchemyArray.onBlockDestroyedByExplosion(world, x, y, z, tileEntityAlchemyArray.xCoord, tileEntityAlchemyArray.yCoord, tileEntityAlchemyArray.zCoord, explosion);
        }
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, int metaData) {
        TileEntityAlchemyArray tileEntityAlchemyArray;
        if (world.getTileEntity(x, y, z) instanceof TileEntityDummyArray && (tileEntityAlchemyArray = ((TileEntityDummyArray)world.getTileEntity(x, y, z)).getAssociatedTileEntity()) != null) {
            tileEntityAlchemyArray.onBlockDestroyedByPlayer(world, x, y, z, tileEntityAlchemyArray.xCoord, tileEntityAlchemyArray.yCoord, tileEntityAlchemyArray.zCoord, metaData);
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        TileEntityAlchemyArray tileEntityAlchemyArray;
        if (world.getTileEntity(x, y, z) instanceof TileEntityDummyArray && (tileEntityAlchemyArray = ((TileEntityDummyArray)world.getTileEntity(x, y, z)).getAssociatedTileEntity()) != null) {
            tileEntityAlchemyArray.onEntityCollidedWithBlock(world, x, y, z, tileEntityAlchemyArray.xCoord, tileEntityAlchemyArray.yCoord, tileEntityAlchemyArray.zCoord, entity);
        }
    }

    public void onFallenUpon(World world, int x, int y, int z, Entity entity, float fallDistance) {
        TileEntityAlchemyArray tileEntityAlchemyArray;
        if (world.getTileEntity(x, y, z) instanceof TileEntityDummyArray && (tileEntityAlchemyArray = ((TileEntityDummyArray)world.getTileEntity(x, y, z)).getAssociatedTileEntity()) != null) {
            tileEntityAlchemyArray.onFallenUpon(world, x, y, z, tileEntityAlchemyArray.xCoord, tileEntityAlchemyArray.yCoord, tileEntityAlchemyArray.zCoord, entity, fallDistance);
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        int trueZCoord;
        int trueYCoord;
        int trueXCoord;
        if (!world.isRemote && world.getTileEntity(x, y, z) instanceof TileEntityDummyArray && world.getTileEntity(trueXCoord = ((TileEntityDummyArray)world.getTileEntity(x, y, z)).getTrueXCoord(), trueYCoord = ((TileEntityDummyArray)world.getTileEntity(x, y, z)).getTrueYCoord(), trueZCoord = ((TileEntityDummyArray)world.getTileEntity(x, y, z)).getTrueZCoord()) instanceof TileEntityAlchemyArray) {
            TileEntityAlchemyArray tileEntityAlchemyArray = (TileEntityAlchemyArray)world.getTileEntity(trueXCoord, trueYCoord, trueZCoord);
            boolean invalidateAlchemyArray = false;
            if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.UP && !world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.DOWN && !world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.NORTH && !world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.SOUTH && !world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.EAST && !world.isSideSolid(x - 1, y, z, ForgeDirection.EAST, true)) {
                invalidateAlchemyArray = true;
            } else if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.WEST && !world.isSideSolid(x + 1, y, z, ForgeDirection.WEST, true)) {
                invalidateAlchemyArray = true;
            }
            if (invalidateAlchemyArray) {
                world.getTileEntity(x, y, z).invalidate();
                tileEntityAlchemyArray.invalidate();
                world.setBlockToAir(x, y, z);
                world.setBlockToAir(trueXCoord, trueYCoord, trueZCoord);
            }
        }
    }

    public Item getItemDropped(int par1, Random random, int par2) {
        return null;
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityDummyArray) {
            TileEntityDummyArray tileEntityDummyArray = (TileEntityDummyArray)world.getTileEntity(x, y, z);
            switch (tileEntityDummyArray.getOrientation()) {
                case DOWN: {
                    this.setBlockBounds(0.0f, 1.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
                    break;
                }
                case UP: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                    break;
                }
                case NORTH: {
                    this.setBlockBounds(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case SOUTH: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0625f);
                    break;
                }
                case EAST: {
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.0625f, 1.0f, 1.0f);
                    break;
                }
                case WEST: {
                    this.setBlockBounds(1.0f, 0.0f, 0.0f, 0.9375f, 1.0f, 1.0f);
                    break;
                }
            }
        }
        return super.collisionRayTrace(world, x, y, z, startVec, endVec);
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, Block block, int metaData) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityDummyArray) {
            TileEntity tileEntity = world.getTileEntity(x, y, z);
            super.breakBlock(world, ((TileEntityDummyArray)tileEntity).getTrueXCoord(), ((TileEntityDummyArray)tileEntity).getTrueYCoord(), ((TileEntityDummyArray)tileEntity).getTrueZCoord(), block, metaData);
        }
        super.breakBlock(world, x, y, z, block, metaData);
    }

    public TileEntity createNewTileEntity(World world, int metaData) {
        return new TileEntityDummyArray();
    }
}

