/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.block;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.block.BlockEE;
import com.pahimar.ee3.reference.GUIs;
import com.pahimar.ee3.reference.RenderIds;
import com.pahimar.ee3.tileentity.TileEntityAludel;
import com.pahimar.ee3.tileentity.TileEntityEE;
import com.pahimar.ee3.tileentity.TileEntityGlassBell;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGlassBell
extends BlockEE
implements ITileEntityProvider {
    public BlockGlassBell() {
        super(Material.glass);
        this.setHardness(1.0f);
        this.setBlockName("glassBell");
    }

    public TileEntity createNewTileEntity(World world, int metaData) {
        return new TileEntityGlassBell();
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return RenderIds.glassBell;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityGlassBell) {
            TileEntityGlassBell tileEntityGlassBell = (TileEntityGlassBell)world.getTileEntity(x, y, z);
            return tileEntityGlassBell.getState();
        }
        return 0;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.isSneaking()) {
            return false;
        }
        if (!world.isRemote && world.getTileEntity(x, y, z) instanceof TileEntityGlassBell) {
            if (world.getTileEntity(x, y - 1, z) instanceof TileEntityAludel) {
                player.openGui((Object)EquivalentExchange3.instance, GUIs.ALUDEL.ordinal(), world, x, y - 1, z);
            } else {
                player.openGui((Object)EquivalentExchange3.instance, GUIs.GLASS_BELL.ordinal(), world, x, y, z);
            }
        }
        return true;
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        if (itemStack.hasDisplayName()) {
            ((TileEntityEE)world.getTileEntity(x, y, z)).setCustomName(itemStack.getDisplayName());
        }
        if (world.getTileEntity(x, y - 1, z) != null && world.getTileEntity(x, y - 1, z) instanceof TileEntityAludel) {
            ((TileEntityEE)world.getTileEntity(x, y, z)).setOrientation(ForgeDirection.UP);
        } else {
            ((TileEntityEE)world.getTileEntity(x, y, z)).setOrientation(world.getBlockMetadata(x, y, z));
        }
        world.setBlockMetadataWithNotify(x, y, z, 0, 3);
    }

    public int onBlockPlaced(World world, int x, int y, int z, int sideHit, float hitX, float hitY, float hitZ, int metaData) {
        return sideHit;
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityGlassBell) {
            TileEntityGlassBell tileGlassBell = (TileEntityGlassBell)world.getTileEntity(x, y, z);
            switch (tileGlassBell.getOrientation()) {
                case DOWN: {
                    this.setBlockBounds(0.125f, 0.33f, 0.125f, 0.875f, 1.0f, 0.875f);
                    break;
                }
                case UP: {
                    this.setBlockBounds(0.125f, 0.0f, 0.125f, 0.875f, 0.66f, 0.875f);
                    break;
                }
                case NORTH: {
                    this.setBlockBounds(0.125f, 0.125f, 0.33f, 0.875f, 0.875f, 1.0f);
                    break;
                }
                case SOUTH: {
                    this.setBlockBounds(0.125f, 0.125f, 0.0f, 0.875f, 0.875f, 0.66f);
                    break;
                }
                case EAST: {
                    this.setBlockBounds(0.0f, 0.125f, 0.125f, 0.66f, 0.875f, 0.875f);
                    break;
                }
                case WEST: {
                    this.setBlockBounds(0.33f, 0.125f, 0.125f, 1.0f, 0.875f, 0.875f);
                    break;
                }
            }
        }
        return super.collisionRayTrace(world, x, y, z, startVec, endVec);
    }
}

