/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.gui.inventory;

import com.pahimar.ee3.client.gui.element.ElementSearchField;
import com.pahimar.ee3.inventory.ContainerAlchemicalTome;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageGuiElementClicked;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.repackage.cofh.lib.gui.GuiBase;
import com.pahimar.repackage.cofh.lib.gui.GuiColor;
import com.pahimar.repackage.cofh.lib.gui.element.ElementButton;
import com.pahimar.repackage.cofh.lib.gui.element.ElementTextField;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiAlchemicalTome
extends GuiBase {
    private ElementButton prevPageButton;
    private ElementButton nextPageButton;
    private ElementTextField searchTextField;

    public GuiAlchemicalTome(InventoryPlayer inventoryPlayer, ItemStack itemStack) {
        super(new ContainerAlchemicalTome(inventoryPlayer.player, itemStack), Textures.Gui.ALCHEMICAL_TOME);
        this.xSize = 256;
        this.ySize = 226;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.drawTitle = false;
        this.drawInventory = false;
        this.prevPageButton = new ElementButton((GuiBase)this, 15, 177, "prev", 0, 0, 20, 0, 40, 0, 20, 10, 60, 10, Textures.Gui.Elements.ARROW_LEFT);
        this.nextPageButton = new ElementButton((GuiBase)this, 223, 177, "next", 0, 0, 22, 0, 44, 0, 22, 10, 66, 10, Textures.Gui.Elements.ARROW_RIGHT);
        this.searchTextField = new ElementSearchField((GuiBase)this, 64, 205, "searchField", 128, 20);
        this.searchTextField.setPadding(6, 3, 0, 3);
        this.searchTextField.borderColor = new GuiColor(160, 160, 160).getColor();
        this.searchTextField.backgroundColor = new GuiColor(0, 0, 0).getColor();
        this.addElement(this.prevPageButton);
        this.addElement(this.nextPageButton);
        this.addElement(this.searchTextField);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int x, int y) {
        super.drawGuiContainerForegroundLayer(x, y);
        int pageOffset = ((ContainerAlchemicalTome)this.inventorySlots).getPageOffset();
        if (this.inventorySlots.getSlot(0).getHasStack()) {
            this.fontRendererObj.drawString(pageOffset * 2 + 1 + "", 64, 178, new GuiColor(50, 50, 50).getColor());
        } else if (((ContainerAlchemicalTome)this.inventorySlots).getKnownTransmutationsCount() == 0) {
            this.fontRendererObj.drawSplitString(StatCollector.translateToLocal((String)"container.ee3:alchemicalTome.noTransmutationsKnown"), 142, 20, 100, new GuiColor(50, 50, 50).getColor());
        }
        if (this.inventorySlots.getSlot(40).getHasStack()) {
            this.fontRendererObj.drawString(pageOffset * 2 + 2 + "", 186, 178, new GuiColor(50, 50, 50).getColor());
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int x, int y) {
        this.mouseX = x - this.guiLeft;
        this.mouseY = y - this.guiTop;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        this.drawSizedTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, 256.0f, 256.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.drawElements(partialTicks, false);
        this.drawTabs(partialTicks, false);
        GL11.glPopMatrix();
    }

    @Override
    protected void updateElementInformation() {
        if (((ContainerAlchemicalTome)this.inventorySlots).getPageOffset() == 0) {
            this.prevPageButton.setDisabled();
        } else if (!this.prevPageButton.isEnabled()) {
            this.prevPageButton.setEnabled(true);
        }
        if (((ContainerAlchemicalTome)this.inventorySlots).getPageOffset() == ((ContainerAlchemicalTome)this.inventorySlots).getMaxPageOffset()) {
            this.nextPageButton.setDisabled();
        } else if (!this.nextPageButton.isEnabled()) {
            this.nextPageButton.setEnabled(true);
        }
    }

    protected void handleMouseClick(Slot slot, int p_146984_2_, int p_146984_3_, int p_146984_4_) {
    }

    @Override
    public void handleElementButtonClick(String buttonName, int mouseButton) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiElementClicked(buttonName, mouseButton));
    }
}

