/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.renderer.tileentity;

import com.pahimar.ee3.client.renderer.model.ModelCalcinator;
import com.pahimar.ee3.client.util.ColorUtils;
import com.pahimar.ee3.reference.Colors;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.tileentity.TileEntityCalcinator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityRendererCalcinator
extends TileEntitySpecialRenderer {
    private final ModelCalcinator modelCalcinator = new ModelCalcinator();

    private static float[] getBlendedDustColour(int leftStackSize, int leftStackMeta, int rightStackSize, int rightStackMeta) {
        int totalDustStacksSize = leftStackSize + rightStackSize;
        if (totalDustStacksSize > 0) {
            int leftStackColour = Integer.parseInt(Colors.DUST_COLOURS[MathHelper.clamp_int((int)leftStackMeta, (int)0, (int)Colors.DUST_COLOURS.length)], 16);
            int rightStackColour = Integer.parseInt(Colors.DUST_COLOURS[MathHelper.clamp_int((int)rightStackMeta, (int)0, (int)Colors.DUST_COLOURS.length)], 16);
            float leftStackRatio = (float)leftStackSize * 1.0f / (float)totalDustStacksSize;
            float rightStackRatio = (float)rightStackSize * 1.0f / (float)totalDustStacksSize;
            float[][] blendedColours = ColorUtils.getFloatBlendedColours(leftStackColour, rightStackColour, 32);
            if (blendedColours.length > 0) {
                if (Float.compare(leftStackRatio, rightStackRatio) > 0) {
                    return blendedColours[Math.round((1.0f - leftStackRatio) * (float)(blendedColours.length - 1))];
                }
                return blendedColours[Math.round(rightStackRatio * (float)(blendedColours.length - 1))];
            }
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public void renderTileEntityAt(TileEntity tileEntity, double x, double y, double z, float tick) {
        if (tileEntity instanceof TileEntityCalcinator) {
            TileEntityCalcinator tileEntityCalcinator = (TileEntityCalcinator)tileEntity;
            GL11.glPushMatrix();
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.0f), (float)((float)z + 1.2f));
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (tileEntityCalcinator.getState() == 1) {
                this.bindTexture(Textures.Model.CALCINATOR_ACTIVE);
            } else {
                this.bindTexture(Textures.Model.CALCINATOR_IDLE);
            }
            this.modelCalcinator.renderPart("Calcinator");
            int dustStackSize = tileEntityCalcinator.leftStackSize + tileEntityCalcinator.rightStackSize;
            if (dustStackSize > 0) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                float[] dustColour = TileEntityRendererCalcinator.getBlendedDustColour(tileEntityCalcinator.leftStackSize, tileEntityCalcinator.leftStackMeta, tileEntityCalcinator.rightStackSize, tileEntityCalcinator.rightStackMeta);
                GL11.glColor4f((float)dustColour[0], (float)dustColour[1], (float)dustColour[2], (float)1.0f);
                if (dustStackSize <= 32) {
                    GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
                    GL11.glTranslatef((float)0.0f, (float)2.2f, (float)-2.1125f);
                } else if (dustStackSize <= 64) {
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    GL11.glTranslatef((float)-0.0125f, (float)0.75f, (float)-0.7125f);
                }
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                this.modelCalcinator.renderPart("Dust");
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
    }
}

