/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.command;

import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.knowledge.TransmutationKnowledgeRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class CommandPlayerLearnCurrentItem
extends CommandBase {
    public String getCommandName() {
        return "player-learn-current-item";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public String getCommandUsage(ICommandSender commandSender) {
        return "commands.ee3.player-learn-current-item.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCommand(ICommandSender commandSender, String[] args) {
        if (args.length < 2) {
            throw new WrongUsageException("commands.ee3.player-learn-current-item.usage", new Object[0]);
        }
        EntityPlayerMP entityPlayer = CommandPlayerLearnCurrentItem.getPlayer((ICommandSender)commandSender, (String)args[1]);
        if (entityPlayer == null) throw new WrongUsageException("commands.ee3.player-not-found.error", new Object[0]);
        ItemStack itemStack = ((EntityPlayer)commandSender).getCurrentEquippedItem();
        if (itemStack == null) throw new WrongUsageException("commands.ee3.no-item.error", new Object[0]);
        if (!AbilityRegistry.getInstance().isLearnable(itemStack)) return;
        TransmutationKnowledgeRegistry.getInstance().teachPlayer((EntityPlayer)entityPlayer, itemStack);
        CommandPlayerLearnCurrentItem.func_152373_a((ICommandSender)commandSender, (ICommand)this, (String)"commands.ee3.player-learn-current-item.success", (Object[])new Object[]{commandSender.getCommandSenderName(), entityPlayer.getCommandSenderName(), itemStack.func_151000_E()});
    }

    public List addTabCompletionOptions(ICommandSender commandSender, String[] args) {
        if (args.length == 2) {
            return CommandPlayerLearnCurrentItem.getListOfStringsMatchingLastWord((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().getAllUsernames());
        }
        return null;
    }
}

