/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.command;

import com.pahimar.ee3.command.CommandEE;
import com.pahimar.ee3.reference.Reference;
import com.pahimar.ee3.test.EnergyValueMappingsTestSuite;
import com.pahimar.ee3.util.LogHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CommandRunTest
extends CommandEE {
    @Override
    public String getCommandName() {
        return "run-tests";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandUsage(ICommandSender commandSender) {
        return "commands.ee3.run-tests.usage";
    }

    @Override
    public void processCommand(ICommandSender commandSender, String[] args) {
        if (args.length == 2) {
            File testCaseDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().getEntityWorld().getSaveHandler().getWorldDirectory(), "data" + File.separator + Reference.LOWERCASE_MOD_ID + File.separator + "energyvalues" + File.separator + "testcases");
            testCaseDirectory.mkdirs();
            boolean testFound = false;
            for (File testCaseFile : testCaseDirectory.listFiles()) {
                if (!testCaseFile.isFile() || !testCaseFile.getName().equalsIgnoreCase(args[1])) continue;
                testFound = true;
                EnergyValueMappingsTestSuite energyValueMappingsTestSuite = new EnergyValueMappingsTestSuite(testCaseFile);
                LogHelper.info(String.format("BEGIN TEST (%s)", testCaseFile.getName()));
                energyValueMappingsTestSuite.runTestSuite();
                LogHelper.info(String.format("END TEST (%s)", testCaseFile.getName()));
            }
            if (testFound) {
                commandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("commands.ee3.run-tests.success", new Object[]{args[1]}));
            } else {
                commandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("commands.ee3.run-tests.notfound", new Object[]{args[1]}));
            }
        } else {
            throw new WrongUsageException("commands.ee3.run-tests.usage", new Object[0]);
        }
    }

    @Override
    public List addTabCompletionOptions(ICommandSender commandSender, String[] args) {
        if (args.length == 2) {
            File testCaseDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().getEntityWorld().getSaveHandler().getWorldDirectory(), "data" + File.separator + Reference.LOWERCASE_MOD_ID + File.separator + "energyvalues" + File.separator + "testcases");
            testCaseDirectory.mkdirs();
            ArrayList<String> fileNames = new ArrayList<String>();
            for (File testCaseFile : testCaseDirectory.listFiles()) {
                if (!testCaseFile.isFile() || !testCaseFile.getAbsolutePath().endsWith(".json")) continue;
                fileNames.add(testCaseFile.getName());
            }
            return CommandRunTest.getListOfStringsMatchingLastWord((String[])args, (String[])fileNames.toArray(new String[0]));
        }
        return null;
    }
}

