/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.command;

import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageSyncEnergyValues;
import com.pahimar.ee3.reference.Settings;
import com.pahimar.ee3.util.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CommandSyncEnergyValues
extends CommandBase {
    private static Map<UUID, Long> requesterMap = new HashMap<UUID, Long>();

    public String getCommandName() {
        return "sync-energy-values";
    }

    public int getRequiredPermissionLevel() {
        return 4;
    }

    public String getCommandUsage(ICommandSender commandSender) {
        return "commands.ee3.sync-energy-values.usage";
    }

    public void processCommand(ICommandSender commandSender, String[] args) {
        boolean shouldSync = true;
        float coolDown = 0.0f;
        UUID commandSenderUUID = ((EntityPlayer)commandSender).getUniqueID();
        if (requesterMap.containsKey(commandSenderUUID)) {
            long timeDifference = System.currentTimeMillis() - requesterMap.get(commandSenderUUID);
            if (timeDifference >= (long)(Settings.General.syncThreshold * 1000)) {
                requesterMap.remove(commandSenderUUID);
            } else {
                coolDown = (long)(Settings.General.syncThreshold * 1000) - timeDifference;
                shouldSync = false;
            }
        } else {
            requesterMap.put(commandSenderUUID, System.currentTimeMillis());
        }
        if (!shouldSync) {
            throw new WrongUsageException("commands.ee3.sync-energy-values.denied", new Object[]{Float.valueOf(coolDown / 1000.0f)});
        }
        LogHelper.info(String.format("Syncing energy values with player '%s' at their request", commandSender.getCommandSenderName()));
        PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncEnergyValues(EnergyValueRegistry.getInstance()), (EntityPlayerMP)commandSender);
        commandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("commands.ee3.sync-energy-values.success", new Object[0]));
    }
}

