/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.exchange;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.pahimar.ee3.exchange.JsonFluidStack;
import com.pahimar.ee3.exchange.JsonItemStack;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.util.FluidHelper;
import com.pahimar.ee3.util.ItemHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class WrappedStack
implements Comparable<WrappedStack>,
JsonDeserializer<WrappedStack>,
JsonSerializer<WrappedStack> {
    public static final Gson jsonSerializer = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(WrappedStack.class, (Object)new WrappedStack()).create();
    private final String objectType;
    private final Object wrappedStack;
    private int stackSize;
    public static Comparator<WrappedStack> comparator = new Comparator<WrappedStack>(){

        @Override
        public int compare(WrappedStack wrappedStack1, WrappedStack wrappedStack2) {
            if (wrappedStack1.wrappedStack instanceof ItemStack) {
                if (wrappedStack2.wrappedStack instanceof ItemStack) {
                    return ItemHelper.compare((ItemStack)wrappedStack1.wrappedStack, (ItemStack)wrappedStack2.wrappedStack);
                }
                return 1;
            }
            if (wrappedStack1.wrappedStack instanceof OreStack) {
                if (wrappedStack2.wrappedStack instanceof ItemStack) {
                    return -1;
                }
                if (wrappedStack2.wrappedStack instanceof OreStack) {
                    return OreStack.compare((OreStack)wrappedStack1.wrappedStack, (OreStack)wrappedStack2.wrappedStack);
                }
                return 1;
            }
            if (wrappedStack1.wrappedStack instanceof FluidStack) {
                if (wrappedStack2.wrappedStack instanceof ItemStack || wrappedStack2.wrappedStack instanceof OreStack) {
                    return -1;
                }
                if (wrappedStack2.wrappedStack instanceof FluidStack) {
                    return FluidHelper.compare((FluidStack)wrappedStack1.wrappedStack, (FluidStack)wrappedStack2.wrappedStack);
                }
                return 1;
            }
            if (wrappedStack1.wrappedStack == null) {
                if (wrappedStack2.wrappedStack != null) {
                    return -1;
                }
                return 0;
            }
            return 0;
        }
    };

    public WrappedStack() {
        this.objectType = null;
        this.stackSize = -1;
        this.wrappedStack = null;
    }

    private WrappedStack(Object object) {
        if (object instanceof Item) {
            object = new ItemStack((Item)object);
        } else if (object instanceof Block) {
            object = new ItemStack((Block)object);
        } else if (object instanceof Fluid) {
            object = new FluidStack((Fluid)object, 1000);
        }
        if (object instanceof ItemStack) {
            if (((ItemStack)object).getItem() != null) {
                ItemStack itemStackObject = (ItemStack)object;
                ItemStack itemStack = new ItemStack(itemStackObject.getItem(), itemStackObject.stackSize, itemStackObject.getItemDamage());
                if (itemStackObject.stackTagCompound != null) {
                    itemStack.stackTagCompound = (NBTTagCompound)itemStackObject.stackTagCompound.copy();
                }
                this.objectType = "itemstack";
                this.stackSize = itemStack.stackSize;
                itemStack.stackSize = 1;
                this.wrappedStack = itemStack;
            } else {
                this.objectType = null;
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else if (object instanceof OreStack) {
            OreStack oreStack = (OreStack)object;
            this.objectType = "orestack";
            this.stackSize = oreStack.stackSize;
            oreStack.stackSize = 1;
            this.wrappedStack = oreStack;
        } else if (object instanceof ArrayList) {
            ArrayList objectList = (ArrayList)object;
            OreStack possibleOreStack = OreStack.getOreStackFromList(objectList);
            if (possibleOreStack != null) {
                this.objectType = "orestack";
                this.stackSize = possibleOreStack.stackSize;
                possibleOreStack.stackSize = 1;
                this.wrappedStack = possibleOreStack;
            } else {
                this.objectType = null;
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else if (object instanceof FluidStack) {
            FluidStack fluidStack = ((FluidStack)object).copy();
            this.objectType = "fluidstack";
            this.stackSize = fluidStack.amount;
            fluidStack.amount = 1;
            this.wrappedStack = fluidStack;
        } else if (object instanceof WrappedStack) {
            WrappedStack wrappedStackObject = (WrappedStack)object;
            if (wrappedStackObject.getWrappedObject() != null) {
                this.objectType = wrappedStackObject.objectType;
                this.stackSize = wrappedStackObject.stackSize;
                this.wrappedStack = wrappedStackObject.wrappedStack;
            } else {
                this.objectType = null;
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else {
            this.objectType = null;
            this.stackSize = -1;
            this.wrappedStack = null;
        }
    }

    private WrappedStack(Object object, int stackSize) {
        if (object instanceof Item) {
            object = new ItemStack((Item)object);
        } else if (object instanceof Block) {
            object = new ItemStack((Block)object);
        } else if (object instanceof Fluid) {
            object = new FluidStack((Fluid)object, 1000);
        }
        if (object instanceof ItemStack) {
            ItemStack itemStack = ((ItemStack)object).copy();
            this.objectType = "itemstack";
            this.stackSize = stackSize;
            itemStack.stackSize = 1;
            this.wrappedStack = itemStack;
        } else if (object instanceof OreStack) {
            OreStack oreStack = (OreStack)object;
            this.objectType = "orestack";
            this.stackSize = stackSize;
            oreStack.stackSize = 1;
            this.wrappedStack = oreStack;
        } else if (object instanceof ArrayList) {
            ArrayList objectList = (ArrayList)object;
            OreStack possibleOreStack = OreStack.getOreStackFromList(objectList);
            if (possibleOreStack != null) {
                this.objectType = "orestack";
                this.stackSize = stackSize;
                possibleOreStack.stackSize = 1;
                this.wrappedStack = possibleOreStack;
            } else {
                this.objectType = null;
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else if (object instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)object;
            this.objectType = "fluidstack";
            this.stackSize = stackSize;
            fluidStack.amount = 1;
            this.wrappedStack = fluidStack;
        } else if (object instanceof WrappedStack) {
            WrappedStack wrappedStackObject = (WrappedStack)object;
            if (wrappedStackObject.getWrappedObject() != null) {
                this.objectType = wrappedStackObject.objectType;
                this.stackSize = stackSize;
                this.wrappedStack = wrappedStackObject.wrappedStack;
            } else {
                this.objectType = null;
                this.stackSize = -1;
                this.wrappedStack = null;
            }
        } else {
            this.objectType = null;
            this.stackSize = -1;
            this.wrappedStack = null;
        }
    }

    public Object getWrappedObject() {
        return this.wrappedStack;
    }

    public static boolean canBeWrapped(Object object) {
        if (object instanceof WrappedStack) {
            return true;
        }
        if (object instanceof Item || object instanceof Block) {
            return true;
        }
        if (object instanceof ItemStack) {
            if (((ItemStack)object).getItem() != null) {
                return true;
            }
        } else {
            if (object instanceof OreStack) {
                return true;
            }
            if (object instanceof List ? OreStack.getOreStackFromList((List)object) != null : object instanceof Fluid || object instanceof FluidStack) {
                return true;
            }
        }
        return false;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(int stackSize) {
        this.stackSize = stackSize;
    }

    public static NBTTagCompound toNBTTagCompound(WrappedStack wrappedStack) {
        if (wrappedStack != null && wrappedStack.getWrappedObject() != null) {
            NBTTagCompound wrappedStackTagCompound = new NBTTagCompound();
            if (wrappedStack.getWrappedObject() instanceof ItemStack) {
                NBTTagCompound wrappedItemTagCompound = new NBTTagCompound();
                ((ItemStack)wrappedStack.getWrappedObject()).writeToNBT(wrappedItemTagCompound);
                wrappedStackTagCompound.setInteger("type", 0);
                wrappedStackTagCompound.setTag("objectData", (NBTBase)wrappedItemTagCompound);
                wrappedStackTagCompound.setInteger("stackSize", wrappedStack.getStackSize());
                return wrappedStackTagCompound;
            }
            if (wrappedStack.getWrappedObject() instanceof OreStack) {
                NBTTagCompound wrappedOreTagCompound = new NBTTagCompound();
                ((OreStack)wrappedStack.getWrappedObject()).writeToNBT(wrappedOreTagCompound);
                wrappedStackTagCompound.setInteger("type", 1);
                wrappedStackTagCompound.setTag("objectData", (NBTBase)wrappedOreTagCompound);
                wrappedStackTagCompound.setInteger("stackSize", wrappedStack.getStackSize());
                return wrappedStackTagCompound;
            }
            if (wrappedStack.getWrappedObject() instanceof FluidStack) {
                NBTTagCompound wrappedFluidTagCompound = new NBTTagCompound();
                ((FluidStack)wrappedStack.getWrappedObject()).writeToNBT(wrappedFluidTagCompound);
                wrappedStackTagCompound.setInteger("type", 2);
                wrappedStackTagCompound.setTag("objectData", (NBTBase)wrappedFluidTagCompound);
                wrappedStackTagCompound.setInteger("stackSize", wrappedStack.getStackSize());
                return wrappedStackTagCompound;
            }
        }
        return null;
    }

    public static WrappedStack fromNBTTagCompound(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.hasKey("type") && nbtTagCompound.hasKey("objectData") && nbtTagCompound.hasKey("stackSize")) {
            int objectType = nbtTagCompound.getInteger("type");
            int stackSize = nbtTagCompound.getInteger("stackSize");
            if (objectType == 0) {
                ItemStack itemStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbtTagCompound.getCompoundTag("objectData"));
                return new WrappedStack(itemStack, stackSize);
            }
            if (objectType == 1) {
                OreStack oreStack = OreStack.loadOreStackFromNBT(nbtTagCompound.getCompoundTag("objectData"));
                return new WrappedStack(oreStack, stackSize);
            }
            if (objectType == 2) {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTagCompound.getCompoundTag("objectData"));
                return new WrappedStack(fluidStack, stackSize);
            }
            return new WrappedStack();
        }
        return new WrappedStack();
    }

    public static WrappedStack wrap(Object object) {
        if (WrappedStack.canBeWrapped(object)) {
            return new WrappedStack(object);
        }
        return null;
    }

    public static WrappedStack wrap(Object object, int stackSize) {
        if (WrappedStack.canBeWrapped(object)) {
            return new WrappedStack(object, stackSize);
        }
        return null;
    }

    public static WrappedStack createFromJson(String jsonWrappedObject) throws JsonParseException {
        try {
            return (WrappedStack)jsonSerializer.fromJson(jsonWrappedObject, WrappedStack.class);
        }
        catch (JsonSyntaxException exception) {
            exception.printStackTrace();
        }
        catch (JsonParseException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public String toJson() {
        return jsonSerializer.toJson((Object)this);
    }

    public WrappedStack deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!jsonElement.isJsonPrimitive()) {
            JsonObject jsonWrappedStack = (JsonObject)jsonElement;
            int stackSize = 1;
            String objectType = null;
            OreStack stackObject = null;
            if (jsonWrappedStack.get("type") != null) {
                objectType = jsonWrappedStack.get("type").getAsString();
            }
            if (jsonWrappedStack.get("stackSize") != null) {
                stackSize = jsonWrappedStack.get("stackSize").getAsInt();
            }
            if (jsonWrappedStack.get("objectData") != null && !jsonWrappedStack.get("objectData").isJsonPrimitive() && objectType != null) {
                if (objectType.equalsIgnoreCase("ItemStack")) {
                    JsonItemStack jsonItemStack = (JsonItemStack)JsonItemStack.jsonSerializer.fromJson(jsonWrappedStack.get("objectData"), JsonItemStack.class);
                    ItemStack itemStack = null;
                    Item item = (Item)Item.itemRegistry.getObject(jsonItemStack.itemName);
                    if (stackSize > 0 && item != null) {
                        itemStack = new ItemStack(item, stackSize, jsonItemStack.itemDamage);
                        if (jsonItemStack.itemNBTTagCompound != null) {
                            itemStack.stackTagCompound = jsonItemStack.itemNBTTagCompound;
                        }
                    }
                    stackObject = itemStack;
                } else if (objectType.equalsIgnoreCase("OreStack")) {
                    OreStack oreStack = (OreStack)jsonSerializer.fromJson(jsonWrappedStack.get("objectData"), OreStack.class);
                    if (stackSize > 0) {
                        oreStack.stackSize = stackSize;
                    }
                    stackObject = oreStack;
                } else if (objectType.equalsIgnoreCase("FluidStack")) {
                    JsonFluidStack jsonFluidStack = (JsonFluidStack)JsonFluidStack.jsonSerializer.fromJson(jsonWrappedStack.get("objectData"), JsonFluidStack.class);
                    FluidStack fluidStack = new FluidStack(jsonFluidStack.fluid, jsonFluidStack.amount, jsonFluidStack.tag);
                    if (stackSize > 0) {
                        fluidStack.amount = stackSize;
                    }
                    stackObject = fluidStack;
                }
            }
            if (stackObject != null) {
                return new WrappedStack(stackObject);
            }
            throw new JsonParseException(String.format("Unable to parse a wrappable stack object from the provided json: %s", jsonElement.toString()));
        }
        throw new JsonParseException(String.format("Unable to parse a wrappable stack object from the provided json: %s", jsonElement.toString()));
    }

    public JsonElement serialize(WrappedStack wrappedStack, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonWrappedStack = new JsonObject();
        Gson gson = new Gson();
        jsonWrappedStack.addProperty("type", wrappedStack.objectType);
        jsonWrappedStack.addProperty("stackSize", (Number)wrappedStack.stackSize);
        if (wrappedStack.wrappedStack instanceof ItemStack) {
            JsonItemStack jsonItemStack = new JsonItemStack();
            jsonItemStack.itemName = Item.itemRegistry.getNameForObject((Object)((ItemStack)wrappedStack.wrappedStack).getItem());
            jsonItemStack.itemDamage = ((ItemStack)wrappedStack.wrappedStack).getItemDamage();
            if (((ItemStack)wrappedStack.wrappedStack).stackTagCompound != null) {
                jsonItemStack.itemNBTTagCompound = ((ItemStack)wrappedStack.wrappedStack).stackTagCompound;
            }
            jsonWrappedStack.add("objectData", JsonItemStack.jsonSerializer.toJsonTree((Object)jsonItemStack, JsonItemStack.class));
        } else if (wrappedStack.wrappedStack instanceof OreStack) {
            jsonWrappedStack.add("objectData", gson.toJsonTree(wrappedStack.wrappedStack, OreStack.class));
        } else if (wrappedStack.wrappedStack instanceof FluidStack) {
            JsonFluidStack jsonFluidStack = new JsonFluidStack((FluidStack)wrappedStack.wrappedStack);
            jsonWrappedStack.add("objectData", JsonFluidStack.jsonSerializer.toJsonTree((Object)jsonFluidStack, JsonFluidStack.class));
        }
        return jsonWrappedStack;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 37 * hashCode + this.stackSize;
        if (this.wrappedStack instanceof ItemStack) {
            hashCode = 37 * hashCode + Item.getIdFromItem((Item)((ItemStack)this.wrappedStack).getItem());
            hashCode = 37 * hashCode + ((ItemStack)this.wrappedStack).getItemDamage();
            if (((ItemStack)this.wrappedStack).getTagCompound() != null) {
                hashCode = 37 * hashCode + ((ItemStack)this.wrappedStack).getTagCompound().hashCode();
            }
        } else if (this.wrappedStack instanceof OreStack) {
            if (((OreStack)this.wrappedStack).oreName != null) {
                hashCode = 37 * hashCode + ((OreStack)this.wrappedStack).oreName.hashCode();
            }
        } else if (this.wrappedStack instanceof FluidStack) {
            hashCode = 37 * hashCode + this.wrappedStack.hashCode();
            if (((FluidStack)this.wrappedStack).tag != null) {
                hashCode = 37 * hashCode + ((FluidStack)this.wrappedStack).tag.hashCode();
            }
        }
        return hashCode;
    }

    public boolean equals(Object object) {
        return object instanceof WrappedStack && this.compareTo((WrappedStack)object) == 0;
    }

    @Override
    public int compareTo(WrappedStack wrappedStack) {
        return comparator.compare(this, wrappedStack);
    }

    public String toString() {
        if (this.wrappedStack instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)this.wrappedStack;
            String unlocalizedName = "";
            try {
                unlocalizedName = itemStack.getUnlocalizedName();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                unlocalizedName = "no-name";
            }
            if (itemStack.hasTagCompound()) {
                return String.format("%sxitemStack[%s@%s:%s]", this.stackSize, unlocalizedName, itemStack.getItemDamage(), itemStack.getTagCompound());
            }
            return String.format("%sxitemStack[%s@%s]", this.stackSize, unlocalizedName, itemStack.getItemDamage());
        }
        if (this.wrappedStack instanceof OreStack) {
            OreStack oreStack = (OreStack)this.wrappedStack;
            return String.format("%sxoreStack.%s", this.stackSize, oreStack.oreName);
        }
        if (this.wrappedStack instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)this.wrappedStack;
            return String.format("%sxfluidStack.%s", this.stackSize, fluidStack.getFluid().getName());
        }
        return "null-wrappedstack";
    }
}

