/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.inventory.ContainerEE;
import com.pahimar.ee3.inventory.InventoryAlchemicalBag;
import com.pahimar.ee3.item.ItemAlchemicalBag;
import com.pahimar.ee3.util.NBTHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerAlchemicalBag
extends ContainerEE {
    public static final int SMALL_BAG_INVENTORY_ROWS = 4;
    public static final int SMALL_BAG_INVENTORY_COLUMNS = 12;
    public static final int MEDIUM_BAG_INVENTORY_ROWS = 7;
    public static final int MEDIUM_BAG_INVENTORY_COLUMNS = 12;
    public static final int LARGE_BAG_INVENTORY_ROWS = 9;
    public static final int LARGE_BAG_INVENTORY_COLUMNS = 13;
    private final EntityPlayer entityPlayer;
    public final InventoryAlchemicalBag inventoryAlchemicalBag;
    private int bagInventoryRows;
    private int bagInventoryColumns;

    public ContainerAlchemicalBag(EntityPlayer entityPlayer, InventoryAlchemicalBag inventoryAlchemicalBag) {
        this.entityPlayer = entityPlayer;
        this.inventoryAlchemicalBag = inventoryAlchemicalBag;
        if (inventoryAlchemicalBag.parentItemStack.getItemDamage() == 0) {
            this.bagInventoryRows = 4;
            this.bagInventoryColumns = 12;
        } else if (inventoryAlchemicalBag.parentItemStack.getItemDamage() == 1) {
            this.bagInventoryRows = 7;
            this.bagInventoryColumns = 12;
        } else if (inventoryAlchemicalBag.parentItemStack.getItemDamage() == 2) {
            this.bagInventoryRows = 9;
            this.bagInventoryColumns = 13;
        }
        for (int bagRowIndex = 0; bagRowIndex < this.bagInventoryRows; ++bagRowIndex) {
            for (int bagColumnIndex = 0; bagColumnIndex < this.bagInventoryColumns; ++bagColumnIndex) {
                if (inventoryAlchemicalBag.parentItemStack.getItemDamage() == 0) {
                    this.addSlotToContainer(new SlotAlchemicalBag(this, inventoryAlchemicalBag, entityPlayer, bagColumnIndex + bagRowIndex * this.bagInventoryColumns, 8 + bagColumnIndex * 18, 18 + bagRowIndex * 18));
                    continue;
                }
                if (inventoryAlchemicalBag.parentItemStack.getItemDamage() == 1) {
                    this.addSlotToContainer(new SlotAlchemicalBag(this, inventoryAlchemicalBag, entityPlayer, bagColumnIndex + bagRowIndex * this.bagInventoryColumns, 8 + bagColumnIndex * 18, 18 + bagRowIndex * 18));
                    continue;
                }
                if (inventoryAlchemicalBag.parentItemStack.getItemDamage() != 2) continue;
                this.addSlotToContainer(new SlotAlchemicalBag(this, inventoryAlchemicalBag, entityPlayer, bagColumnIndex + bagRowIndex * this.bagInventoryColumns, 8 + bagColumnIndex * 18, 8 + bagRowIndex * 18));
            }
        }
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                if (inventoryAlchemicalBag.parentItemStack.getItemDamage() == 0) {
                    this.addSlotToContainer(new Slot((IInventory)entityPlayer.inventory, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 35 + inventoryColumnIndex * 18, 104 + inventoryRowIndex * 18));
                    continue;
                }
                if (inventoryAlchemicalBag.parentItemStack.getItemDamage() == 1) {
                    this.addSlotToContainer(new Slot((IInventory)entityPlayer.inventory, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 35 + inventoryColumnIndex * 18, 158 + inventoryRowIndex * 18));
                    continue;
                }
                if (inventoryAlchemicalBag.parentItemStack.getItemDamage() != 2) continue;
                this.addSlotToContainer(new Slot((IInventory)entityPlayer.inventory, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 44 + inventoryColumnIndex * 18, 174 + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            if (inventoryAlchemicalBag.parentItemStack.getItemDamage() == 0) {
                this.addSlotToContainer(new Slot((IInventory)entityPlayer.inventory, actionBarSlotIndex, 35 + actionBarSlotIndex * 18, 162));
                continue;
            }
            if (inventoryAlchemicalBag.parentItemStack.getItemDamage() == 1) {
                this.addSlotToContainer(new Slot((IInventory)entityPlayer.inventory, actionBarSlotIndex, 35 + actionBarSlotIndex * 18, 216));
                continue;
            }
            if (inventoryAlchemicalBag.parentItemStack.getItemDamage() != 2) continue;
            this.addSlotToContainer(new Slot((IInventory)entityPlayer.inventory, actionBarSlotIndex, 44 + actionBarSlotIndex * 18, 232));
        }
    }

    public void onContainerClosed(EntityPlayer entityPlayer) {
        super.onContainerClosed(entityPlayer);
        if (!entityPlayer.worldObj.isRemote) {
            InventoryPlayer invPlayer = entityPlayer.inventory;
            for (ItemStack itemStack : invPlayer.mainInventory) {
                if (itemStack == null || !NBTHelper.hasTag(itemStack, "alchemicalBagGuiOpen")) continue;
                NBTHelper.removeTag(itemStack, "alchemicalBagGuiOpen");
            }
            this.saveInventory(entityPlayer);
        }
    }

    public boolean isItemStackParent(ItemStack itemStack) {
        if (NBTHelper.hasUUID(itemStack)) {
            UUID stackUUID = new UUID(itemStack.getTagCompound().getLong("UUIDMostSig"), itemStack.getTagCompound().getLong("UUIDLeastSig"));
            return this.inventoryAlchemicalBag.matchesUUID(stackUUID);
        }
        return false;
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack newItemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemStack = slot.getStack();
            newItemStack = itemStack.copy();
            if (slotIndex < this.bagInventoryRows * this.bagInventoryColumns ? !this.mergeItemStack(itemStack, this.bagInventoryRows * this.bagInventoryColumns, this.inventorySlots.size(), false) : (itemStack.getItem() instanceof ItemAlchemicalBag ? (slotIndex < this.bagInventoryRows * this.bagInventoryColumns + 27 ? !this.mergeItemStack(itemStack, this.bagInventoryRows * this.bagInventoryColumns + 27, this.inventorySlots.size(), false) : !this.mergeItemStack(itemStack, this.bagInventoryRows * this.bagInventoryColumns, this.bagInventoryRows * this.bagInventoryColumns + 27, false)) : !this.mergeItemStack(itemStack, 0, this.bagInventoryRows * this.bagInventoryColumns, false))) {
                return null;
            }
            if (itemStack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return newItemStack;
    }

    public void saveInventory(EntityPlayer entityPlayer) {
        this.inventoryAlchemicalBag.onGuiSaved(entityPlayer);
    }

    private class SlotAlchemicalBag
    extends Slot {
        private final EntityPlayer entityPlayer;
        private ContainerAlchemicalBag containerAlchemicalBag;

        public SlotAlchemicalBag(ContainerAlchemicalBag containerAlchemicalBag2, IInventory inventory, EntityPlayer entityPlayer, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
            this.entityPlayer = entityPlayer;
            this.containerAlchemicalBag = containerAlchemicalBag2;
        }

        public void onSlotChanged() {
            super.onSlotChanged();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                this.containerAlchemicalBag.saveInventory(this.entityPlayer);
            }
        }

        public boolean isItemValid(ItemStack itemStack) {
            return !(itemStack.getItem() instanceof ItemAlchemicalBag);
        }
    }
}

