/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.inventory.ContainerEE;
import com.pahimar.ee3.tileentity.TileEntityAlchemicalChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerAlchemicalChest
extends ContainerEE {
    public static final int SMALL_CHEST_INVENTORY_ROWS = 4;
    public static final int SMALL_CHEST_INVENTORY_COLUMNS = 12;
    public static final int SMALL_INVENTORY_SIZE = 48;
    public static final int MEDIUM_CHEST_INVENTORY_ROWS = 7;
    public static final int MEDIUM_CHEST_INVENTORY_COLUMNS = 12;
    public static final int MEDIUM_INVENTORY_SIZE = 84;
    public static final int LARGE_CHEST_INVENTORY_ROWS = 9;
    public static final int LARGE_CHEST_INVENTORY_COLUMNS = 13;
    public static final int LARGE_INVENTORY_SIZE = 117;
    private TileEntityAlchemicalChest tileEntityAlchemicalChest;
    private int chestInventoryRows;
    private int chestInventoryColumns;

    public ContainerAlchemicalChest(InventoryPlayer inventoryPlayer, TileEntityAlchemicalChest tileEntityAlchemicalChest) {
        this.tileEntityAlchemicalChest = tileEntityAlchemicalChest;
        tileEntityAlchemicalChest.openInventory();
        if (this.tileEntityAlchemicalChest.getState() == 0) {
            this.chestInventoryRows = 4;
            this.chestInventoryColumns = 12;
        } else if (this.tileEntityAlchemicalChest.getState() == 1) {
            this.chestInventoryRows = 7;
            this.chestInventoryColumns = 12;
        } else if (this.tileEntityAlchemicalChest.getState() == 2) {
            this.chestInventoryRows = 9;
            this.chestInventoryColumns = 13;
        }
        for (int chestRowIndex = 0; chestRowIndex < this.chestInventoryRows; ++chestRowIndex) {
            for (int chestColumnIndex = 0; chestColumnIndex < this.chestInventoryColumns; ++chestColumnIndex) {
                if (this.tileEntityAlchemicalChest.getState() == 0) {
                    this.addSlotToContainer(new Slot((IInventory)tileEntityAlchemicalChest, chestColumnIndex + chestRowIndex * this.chestInventoryColumns, 8 + chestColumnIndex * 18, 18 + chestRowIndex * 18));
                    continue;
                }
                if (this.tileEntityAlchemicalChest.getState() == 1) {
                    this.addSlotToContainer(new Slot((IInventory)tileEntityAlchemicalChest, chestColumnIndex + chestRowIndex * this.chestInventoryColumns, 8 + chestColumnIndex * 18, 18 + chestRowIndex * 18));
                    continue;
                }
                if (this.tileEntityAlchemicalChest.getState() != 2) continue;
                this.addSlotToContainer(new Slot((IInventory)tileEntityAlchemicalChest, chestColumnIndex + chestRowIndex * this.chestInventoryColumns, 8 + chestColumnIndex * 18, 8 + chestRowIndex * 18));
            }
        }
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                if (this.tileEntityAlchemicalChest.getState() == 0) {
                    this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 35 + inventoryColumnIndex * 18, 104 + inventoryRowIndex * 18));
                    continue;
                }
                if (this.tileEntityAlchemicalChest.getState() == 1) {
                    this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 35 + inventoryColumnIndex * 18, 158 + inventoryRowIndex * 18));
                    continue;
                }
                if (this.tileEntityAlchemicalChest.getState() != 2) continue;
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 44 + inventoryColumnIndex * 18, 174 + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            if (this.tileEntityAlchemicalChest.getState() == 0) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 35 + actionBarSlotIndex * 18, 162));
                continue;
            }
            if (this.tileEntityAlchemicalChest.getState() == 1) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 35 + actionBarSlotIndex * 18, 216));
                continue;
            }
            if (this.tileEntityAlchemicalChest.getState() != 2) continue;
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 44 + actionBarSlotIndex * 18, 232));
        }
    }

    public void onContainerClosed(EntityPlayer entityPlayer) {
        super.onContainerClosed(entityPlayer);
        this.tileEntityAlchemicalChest.closeInventory();
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack newItemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemStack = slot.getStack();
            newItemStack = itemStack.copy();
            if (slotIndex < this.chestInventoryRows * this.chestInventoryColumns ? !this.mergeItemStack(itemStack, this.chestInventoryRows * this.chestInventoryColumns, this.inventorySlots.size(), false) : !this.mergeItemStack(itemStack, 0, this.chestInventoryRows * this.chestInventoryColumns, false)) {
                return null;
            }
            if (itemStack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return newItemStack;
    }
}

