/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.inventory.ContainerEE;
import com.pahimar.ee3.item.ItemAlchemicalTome;
import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.tileentity.TileEntityResearchStation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerResearchStation
extends ContainerEE {
    private TileEntityResearchStation tileEntityResearchStation;
    private int lastItemLearnTime;
    private boolean isItemStackKnown;

    public ContainerResearchStation(InventoryPlayer inventoryPlayer, TileEntityResearchStation tileEntityResearchStation) {
        this.tileEntityResearchStation = tileEntityResearchStation;
        this.addSlotToContainer(new Slot(tileEntityResearchStation, 0, 79, 84){

            public int getSlotStackLimit() {
                return 1;
            }

            public boolean isItemValid(ItemStack itemStack) {
                return AbilityRegistry.getInstance().isLearnable(itemStack);
            }
        });
        this.addSlotToContainer(new Slot(tileEntityResearchStation, 1, 161, 84){

            public int getSlotStackLimit() {
                return 1;
            }

            public boolean isItemValid(ItemStack itemStack) {
                return itemStack.getItem() instanceof ItemAlchemicalTome;
            }
        });
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 50 + inventoryColumnIndex * 18, 152 + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 50 + actionBarSlotIndex * 18, 210));
        }
    }

    public void addCraftingToCrafters(ICrafting iCrafting) {
        super.addCraftingToCrafters(iCrafting);
        iCrafting.sendProgressBarUpdate((Container)this, 0, this.tileEntityResearchStation.itemLearnTime);
        if (this.tileEntityResearchStation.isItemKnown) {
            iCrafting.sendProgressBarUpdate((Container)this, 1, 1);
        } else {
            iCrafting.sendProgressBarUpdate((Container)this, 1, 0);
        }
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (Object crafter : this.crafters) {
            ICrafting iCrafting = (ICrafting)crafter;
            if (this.lastItemLearnTime != this.tileEntityResearchStation.itemLearnTime) {
                iCrafting.sendProgressBarUpdate((Container)this, 0, this.tileEntityResearchStation.itemLearnTime);
            }
            if (this.isItemStackKnown == this.tileEntityResearchStation.isItemKnown) continue;
            if (this.tileEntityResearchStation.isItemKnown) {
                iCrafting.sendProgressBarUpdate((Container)this, 1, 1);
                continue;
            }
            iCrafting.sendProgressBarUpdate((Container)this, 1, 0);
        }
        this.lastItemLearnTime = this.tileEntityResearchStation.itemLearnTime;
        this.isItemStackKnown = this.tileEntityResearchStation.isItemKnown;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int valueType, int updatedValue) {
        if (valueType == 0) {
            this.tileEntityResearchStation.itemLearnTime = updatedValue;
        } else if (valueType == 1) {
            this.tileEntityResearchStation.isItemKnown = updatedValue == 1;
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotItemStack = slot.getStack();
            itemStack = slotItemStack.copy();
            if (slotIndex < 2 ? !this.mergeItemStack(slotItemStack, 2, this.inventorySlots.size(), false) : (slotItemStack.getItem() instanceof ItemAlchemicalTome ? !this.mergeItemStack(slotItemStack, 1, 2, false) : !this.mergeItemStack(slotItemStack, 0, 1, false))) {
                return null;
            }
            if (slotItemStack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemStack;
    }
}

