/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.inventory.ContainerEE;
import com.pahimar.ee3.inventory.InventoryTransmutationTablet;
import com.pahimar.ee3.inventory.element.IElementButtonHandler;
import com.pahimar.ee3.inventory.element.IElementSliderHandler;
import com.pahimar.ee3.inventory.element.IElementTextFieldHandler;
import com.pahimar.ee3.item.ItemAlchemicalTome;
import com.pahimar.ee3.item.ItemMiniumStone;
import com.pahimar.ee3.item.ItemPhilosophersStone;
import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.knowledge.TransmutationKnowledge;
import com.pahimar.ee3.knowledge.TransmutationKnowledgeRegistry;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTransmutationKnowledgeUpdate;
import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.tileentity.TileEntityTransmutationTablet;
import com.pahimar.ee3.util.FilterUtils;
import com.pahimar.ee3.util.ItemHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerTransmutationTablet
extends ContainerEE
implements IElementTextFieldHandler,
IElementSliderHandler,
IElementButtonHandler {
    private InventoryTransmutationTablet inventoryTransmutationTablet;
    public final TileEntityTransmutationTablet tileEntityTransmutationTablet;
    private float energyValue;
    private String searchTerm;
    private int sortOption;
    private int sortOrder;
    private int scrollBarPosition;

    public ContainerTransmutationTablet(InventoryPlayer inventoryPlayer, TileEntityTransmutationTablet tileEntityTransmutationTablet) {
        ItemStack itemStack;
        this.tileEntityTransmutationTablet = tileEntityTransmutationTablet;
        TreeSet<ItemStack> knownTransmutations = new TreeSet<ItemStack>(Comparators.displayNameComparator);
        if (tileEntityTransmutationTablet.getStackInSlot(9) != null && (itemStack = tileEntityTransmutationTablet.getStackInSlot(9)).getItem() instanceof ItemAlchemicalTome && ItemHelper.hasOwnerUUID(itemStack)) {
            knownTransmutations.addAll(TransmutationKnowledgeRegistry.getInstance().getPlayersKnownTransmutations(ItemHelper.getOwnerUUID(itemStack)));
        }
        this.inventoryTransmutationTablet = new InventoryTransmutationTablet(knownTransmutations);
        this.sortOption = 0;
        this.scrollBarPosition = 0;
        this.energyValue = tileEntityTransmutationTablet.getAvailableEnergyValue().getValue();
        this.addSlotToContainer(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 0, 62, 24));
        this.addSlotToContainer(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 1, 35, 35));
        this.addSlotToContainer(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 2, 26, 61));
        this.addSlotToContainer(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 3, 35, 87));
        this.addSlotToContainer(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 4, 62, 99));
        this.addSlotToContainer(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 5, 89, 87));
        this.addSlotToContainer(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 6, 98, 61));
        this.addSlotToContainer(new SlotTabletInput(this, (IInventory)tileEntityTransmutationTablet, 7, 89, 35));
        this.addSlotToContainer(new Slot((IInventory)tileEntityTransmutationTablet, 8, 62, 61){

            public int getSlotStackLimit() {
                return 1;
            }

            public boolean isItemValid(ItemStack itemStack) {
                return itemStack.getItem() instanceof ItemMiniumStone || itemStack.getItem() instanceof ItemPhilosophersStone;
            }
        });
        this.addSlotToContainer(new SlotAlchemicalTome(this, (IInventory)tileEntityTransmutationTablet, 9, 152, 15));
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlotToContainer(new SlotTabletOutput(this, this.inventoryTransmutationTablet, i * 3 + j, 175 + j * 20, 38 + i * 20));
            }
        }
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 8 + inventoryColumnIndex * 18, 164 + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, 8 + actionBarSlotIndex * 18, 222));
        }
        this.updateInventory();
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return this.tileEntityTransmutationTablet != null && this.tileEntityTransmutationTablet.isStructureValid();
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (Object crafter : this.crafters) {
            ICrafting iCrafting = (ICrafting)crafter;
            if (this.energyValue == this.tileEntityTransmutationTablet.getAvailableEnergyValue().getValue()) continue;
            this.energyValue = this.tileEntityTransmutationTablet.getAvailableEnergyValue().getValue();
            this.updateInventory();
            int energyValueAsInt = Float.floatToRawIntBits(this.tileEntityTransmutationTablet.getAvailableEnergyValue().getValue());
            iCrafting.sendProgressBarUpdate((Container)this, 0, energyValueAsInt & 0xFFFF);
            iCrafting.sendProgressBarUpdate((Container)this, 1, energyValueAsInt >>> 16);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int valueType, int updatedValue) {
        if (valueType == 0) {
            int energyValueAsInt = Float.floatToRawIntBits(this.energyValue);
            energyValueAsInt = energyValueAsInt & 0xFFFF0000 | updatedValue;
            this.energyValue = Float.intBitsToFloat(energyValueAsInt);
        } else if (valueType == 1) {
            int energyValueAsInt = Float.floatToRawIntBits(this.energyValue);
            energyValueAsInt = energyValueAsInt & 0xFFFF | updatedValue << 16;
            this.energyValue = Float.intBitsToFloat(energyValueAsInt);
        } else if (valueType == 2) {
            this.sortOption = updatedValue;
        } else if (valueType == 3) {
            this.scrollBarPosition = updatedValue;
        } else if (valueType == 4) {
            this.sortOrder = updatedValue;
        }
        if (valueType >= 0 && valueType <= 4) {
            this.updateInventory();
        }
    }

    @Override
    public void handleElementTextFieldUpdate(String elementName, String updatedText) {
        if (elementName.equalsIgnoreCase("searchField")) {
            this.searchTerm = updatedText;
            this.updateInventory();
        }
    }

    @Override
    public void handleElementSliderUpdate(String elementName, int elementValue) {
        if (elementName.equals("scrollBar")) {
            this.scrollBarPosition = elementValue;
            this.updateInventory();
        }
    }

    public void handleTransmutationKnowledgeUpdate(TransmutationKnowledge transmutationKnowledge) {
        if (transmutationKnowledge != null) {
            this.inventoryTransmutationTablet = new InventoryTransmutationTablet(transmutationKnowledge.getKnownTransmutations());
            this.updateInventory();
        }
    }

    private void updateInventory() {
        ItemStack[] newInventory = new ItemStack[30];
        Set<ItemStack> filteredSet = FilterUtils.filterByNameContains(this.inventoryTransmutationTablet.getKnownTransmutations(), this.searchTerm);
        ArrayList<ItemStack> filteredList = new ArrayList<ItemStack>(FilterUtils.filterByEnergyValue(filteredSet, this.energyValue));
        int adjustedStartIndex = (int)((float)this.scrollBarPosition / 187.0f * (float)filteredList.size());
        if (this.sortOption == 0) {
            if (this.sortOrder == 0) {
                Collections.sort(filteredList, Comparators.displayNameComparator);
            } else {
                Collections.sort(filteredList, Comparators.reverseDisplayNameComparator);
            }
        } else if (this.sortOption == 1) {
            if (this.sortOrder == 0) {
                Collections.sort(filteredList, Comparators.energyValueItemStackComparator);
            } else {
                Collections.sort(filteredList, Comparators.reverseEnergyValueComparator);
            }
        } else if (this.sortOption == 2) {
            if (this.sortOrder == 0) {
                Collections.sort(filteredList, Comparators.idComparator);
            } else {
                Collections.sort(filteredList, Comparators.reverseIdComparator);
            }
        }
        newInventory = filteredList.size() <= 30 ? filteredList.toArray(newInventory) : (adjustedStartIndex + 30 <= filteredList.size() ? filteredList.subList(adjustedStartIndex, adjustedStartIndex + 30).toArray(newInventory) : filteredList.subList(filteredList.size() - 30, filteredList.size()).toArray(newInventory));
        for (int i = 0; i < 30; ++i) {
            this.getSlot(i + 10).putStack(newInventory[i]);
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotItemStack = slot.getStack();
            itemStack = slotItemStack.copy();
            if (slotIndex < 10 ? !this.mergeItemStack(slotItemStack, 10, this.inventorySlots.size(), false) : (slotIndex >= 10 && slotIndex < 40 ? !this.mergeTransmutatedItemStack(entityPlayer, slot, slotItemStack, 40, this.inventorySlots.size(), false) : (slotItemStack.getItem() instanceof ItemAlchemicalTome ? !this.mergeItemStack(slotItemStack, 9, 10, false) : (slotItemStack.getItem() instanceof ItemMiniumStone || slotItemStack.getItem() instanceof ItemPhilosophersStone ? !this.mergeItemStack(slotItemStack, 8, 10, false) : !this.mergeItemStack(slotItemStack, 0, 10, false))))) {
                return null;
            }
            if (slotItemStack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
        }
        return itemStack;
    }

    protected boolean mergeTransmutatedItemStack(EntityPlayer entityPlayer, Slot transmutationOutputSlot, ItemStack itemStack, int slotMin, int slotMax, boolean ascending) {
        ItemStack stackInSlot;
        Slot slot;
        int currentSlotIndex;
        if (this.tileEntityTransmutationTablet.getAvailableEnergyValue().compareTo(EnergyValueRegistryProxy.getEnergyValue(itemStack)) < 0) {
            return false;
        }
        transmutationOutputSlot.onPickupFromSlot(entityPlayer, itemStack);
        boolean slotFound = false;
        int n = currentSlotIndex = ascending ? slotMax - 1 : slotMin;
        if (itemStack.isStackable()) {
            while (itemStack.stackSize > 0 && (!ascending && currentSlotIndex < slotMax || ascending && currentSlotIndex >= slotMin)) {
                slot = (Slot)this.inventorySlots.get(currentSlotIndex);
                stackInSlot = slot.getStack();
                if (slot.isItemValid(itemStack) && ItemHelper.equalsIgnoreStackSize(itemStack, stackInSlot)) {
                    int combinedStackSize = stackInSlot.stackSize + itemStack.stackSize;
                    int slotStackSizeLimit = Math.min(stackInSlot.getMaxStackSize(), slot.getSlotStackLimit());
                    if (combinedStackSize <= slotStackSizeLimit) {
                        itemStack.stackSize = 0;
                        stackInSlot.stackSize = combinedStackSize;
                        slot.onSlotChanged();
                        slotFound = true;
                    } else if (stackInSlot.stackSize < slotStackSizeLimit) {
                        itemStack.stackSize -= slotStackSizeLimit - stackInSlot.stackSize;
                        stackInSlot.stackSize = slotStackSizeLimit;
                        slot.onSlotChanged();
                        slotFound = true;
                    }
                }
                currentSlotIndex += ascending ? -1 : 1;
            }
        }
        if (itemStack.stackSize > 0) {
            int n2 = currentSlotIndex = ascending ? slotMax - 1 : slotMin;
            while (!ascending && currentSlotIndex < slotMax || ascending && currentSlotIndex >= slotMin) {
                slot = (Slot)this.inventorySlots.get(currentSlotIndex);
                stackInSlot = slot.getStack();
                if (slot.isItemValid(itemStack) && stackInSlot == null) {
                    slot.putStack(ItemHelper.cloneItemStack(itemStack, Math.min(itemStack.stackSize, slot.getSlotStackLimit())));
                    slot.onSlotChanged();
                    if (slot.getStack() == null) break;
                    itemStack.stackSize = 0;
                    slotFound = true;
                    break;
                }
                currentSlotIndex += ascending ? -1 : 1;
            }
        }
        itemStack.stackSize = 1;
        return slotFound;
    }

    @Override
    public void handleElementButtonClick(String elementName, int mouseButton) {
        if (elementName.equals("sortOption")) {
            if (mouseButton == 0) {
                if (this.sortOption == 0) {
                    this.sortOption = 1;
                } else if (this.sortOption == 1) {
                    this.sortOption = 2;
                } else if (this.sortOption == 2) {
                    this.sortOption = 0;
                }
            } else if (mouseButton == 1) {
                if (this.sortOption == 0) {
                    this.sortOption = 2;
                } else if (this.sortOption == 1) {
                    this.sortOption = 0;
                } else if (this.sortOption == 2) {
                    this.sortOption = 1;
                }
            }
        } else if (elementName.equals("sortOrder")) {
            if (this.sortOrder == 0) {
                this.sortOrder = 1;
            } else if (this.sortOrder == 1) {
                this.sortOrder = 0;
            }
        }
        for (Object crafter : this.crafters) {
            ICrafting iCrafting = (ICrafting)crafter;
            iCrafting.sendProgressBarUpdate((Container)this, 2, this.sortOption);
            iCrafting.sendProgressBarUpdate((Container)this, 4, this.sortOrder);
        }
    }

    private class SlotTabletInput
    extends Slot {
        private ContainerTransmutationTablet containerTransmutationTablet;

        public SlotTabletInput(ContainerTransmutationTablet containerTransmutationTablet2, IInventory iInventory, int slotIndex, int x, int y) {
            super(iInventory, slotIndex, x, y);
            this.containerTransmutationTablet = containerTransmutationTablet2;
        }

        public boolean isItemValid(ItemStack itemStack) {
            return EnergyValueRegistry.getInstance().hasEnergyValue(itemStack) && AbilityRegistry.getInstance().isRecoverable(itemStack);
        }

        public void onPickupFromSlot(EntityPlayer entityPlayer, ItemStack itemStack) {
            super.onPickupFromSlot(entityPlayer, itemStack);
            this.containerTransmutationTablet.tileEntityTransmutationTablet.updateEnergyValueFromInventory();
            this.containerTransmutationTablet.updateInventory();
        }

        public void putStack(ItemStack itemStack) {
            super.putStack(itemStack);
            this.containerTransmutationTablet.tileEntityTransmutationTablet.updateEnergyValueFromInventory();
            this.containerTransmutationTablet.updateInventory();
        }
    }

    private class SlotTabletOutput
    extends Slot {
        private ContainerTransmutationTablet containerTransmutationTablet;

        public SlotTabletOutput(ContainerTransmutationTablet containerTransmutationTablet2, IInventory iInventory, int slotIndex, int x, int y) {
            super(iInventory, slotIndex, x, y);
            this.containerTransmutationTablet = containerTransmutationTablet2;
        }

        public boolean isItemValid(ItemStack itemStack) {
            return false;
        }

        public boolean canTakeStack(EntityPlayer entityPlayer) {
            return this.getHasStack();
        }

        public void onPickupFromSlot(EntityPlayer entityPlayer, ItemStack itemStack) {
            super.onPickupFromSlot(entityPlayer, itemStack);
            if (this.getHasStack()) {
                this.containerTransmutationTablet.tileEntityTransmutationTablet.consumeInventoryForEnergyValue(itemStack);
            }
        }

        public void onSlotChanged() {
            super.onSlotChanged();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                this.containerTransmutationTablet.tileEntityTransmutationTablet.updateEnergyValueFromInventory();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return this.getHasStack();
        }
    }

    private class SlotAlchemicalTome
    extends Slot {
        private ContainerTransmutationTablet containerTransmutationTablet;
        private TileEntityTransmutationTablet tileEntityTransmutationTablet;

        public SlotAlchemicalTome(ContainerTransmutationTablet containerTransmutationTablet2, IInventory iInventory, int slotIndex, int x, int y) {
            super(iInventory, slotIndex, x, y);
            this.containerTransmutationTablet = containerTransmutationTablet2;
            this.tileEntityTransmutationTablet = containerTransmutationTablet2.tileEntityTransmutationTablet;
        }

        public int getSlotStackLimit() {
            return 1;
        }

        public boolean isItemValid(ItemStack itemStack) {
            return itemStack.getItem() instanceof ItemAlchemicalTome;
        }

        public void onPickupFromSlot(EntityPlayer entityPlayer, ItemStack itemStack) {
            super.onPickupFromSlot(entityPlayer, itemStack);
            this.containerTransmutationTablet.inventoryTransmutationTablet = new InventoryTransmutationTablet();
            this.containerTransmutationTablet.updateInventory();
            if (!this.tileEntityTransmutationTablet.getWorldObj().isRemote && itemStack != null && itemStack.getItem() instanceof ItemAlchemicalTome && ItemHelper.hasOwnerUUID(itemStack)) {
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTransmutationKnowledgeUpdate(this.containerTransmutationTablet.tileEntityTransmutationTablet, null), new NetworkRegistry.TargetPoint(this.tileEntityTransmutationTablet.getWorldObj().provider.dimensionId, (double)this.tileEntityTransmutationTablet.xCoord, (double)this.tileEntityTransmutationTablet.yCoord, (double)this.tileEntityTransmutationTablet.zCoord, 5.0));
            }
        }

        public void putStack(ItemStack itemStack) {
            super.putStack(itemStack);
            if (!this.tileEntityTransmutationTablet.getWorldObj().isRemote && itemStack != null && itemStack.getItem() instanceof ItemAlchemicalTome && ItemHelper.hasOwnerUUID(itemStack)) {
                Set<ItemStack> knownTransmutations = TransmutationKnowledgeRegistry.getInstance().getPlayersKnownTransmutations(ItemHelper.getOwnerUUID(itemStack));
                this.containerTransmutationTablet.inventoryTransmutationTablet = new InventoryTransmutationTablet(knownTransmutations);
                this.containerTransmutationTablet.updateInventory();
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTransmutationKnowledgeUpdate(this.containerTransmutationTablet.tileEntityTransmutationTablet, knownTransmutations), new NetworkRegistry.TargetPoint(this.tileEntityTransmutationTablet.getWorldObj().provider.dimensionId, (double)this.tileEntityTransmutationTablet.xCoord, (double)this.tileEntityTransmutationTablet.yCoord, (double)this.tileEntityTransmutationTablet.zCoord, 5.0));
            }
        }
    }
}

