/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.util.INBTTaggable;
import com.pahimar.ee3.util.NBTHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryAlchemicalBag
implements IInventory,
INBTTaggable {
    public ItemStack parentItemStack;
    protected ItemStack[] inventory;
    protected String customName;

    public InventoryAlchemicalBag(ItemStack itemStack) {
        this.parentItemStack = itemStack;
        int size = itemStack.getItemDamage() == 1 ? 84 : (itemStack.getItemDamage() == 2 ? 117 : 48);
        this.inventory = new ItemStack[size];
        this.readFromNBT(itemStack.getTagCompound());
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        this.parentItemStack = this.findParentItemStack(entityPlayer);
        if (this.parentItemStack != null) {
            this.save();
        }
    }

    public ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (NBTHelper.hasUUID(this.parentItemStack)) {
            UUID parentItemStackUUID = new UUID(this.parentItemStack.getTagCompound().getLong("UUIDMostSig"), this.parentItemStack.getTagCompound().getLong("UUIDLeastSig"));
            for (int i = 0; i < entityPlayer.inventory.getSizeInventory(); ++i) {
                ItemStack itemStack = entityPlayer.inventory.getStackInSlot(i);
                if (!NBTHelper.hasUUID(itemStack) || itemStack.getTagCompound().getLong("UUIDMostSig") != parentItemStackUUID.getMostSignificantBits() || itemStack.getTagCompound().getLong("UUIDLeastSig") != parentItemStackUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
        }
        return null;
    }

    public boolean matchesUUID(UUID uuid) {
        return NBTHelper.hasUUID(this.parentItemStack) && this.parentItemStack.getTagCompound().getLong("UUIDLeastSig") == uuid.getLeastSignificantBits() && this.parentItemStack.getTagCompound().getLong("UUIDMostSig") == uuid.getMostSignificantBits();
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.parentItemStack.getTagCompound();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            UUID uuid = UUID.randomUUID();
            nbtTagCompound.setLong("UUIDMostSig", uuid.getMostSignificantBits());
            nbtTagCompound.setLong("UUIDLeastSig", uuid.getLeastSignificantBits());
        }
        this.writeToNBT(nbtTagCompound);
        this.parentItemStack.setTagCompound(nbtTagCompound);
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        if (this.inventory[slotIndex] != null) {
            ItemStack itemStack = this.inventory[slotIndex];
            this.inventory[slotIndex] = null;
            return itemStack;
        }
        return null;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
    }

    public String getInventoryName() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:alchemicalBag";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null && nbtTagCompound.hasKey("Items")) {
            if (nbtTagCompound.hasKey("Items")) {
                NBTTagList tagList = nbtTagCompound.getTagList("Items", 10);
                this.inventory = new ItemStack[this.getSizeInventory()];
                for (int i = 0; i < tagList.tagCount(); ++i) {
                    NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
                    byte slotIndex = tagCompound.getByte("Slot");
                    if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
                    this.inventory[slotIndex] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
                }
            }
            if (nbtTagCompound.hasKey("display") && nbtTagCompound.getTag("display").getClass().equals(NBTTagCompound.class) && nbtTagCompound.getCompoundTag("display").hasKey("Name")) {
                this.customName = nbtTagCompound.getCompoundTag("display").getString("Name");
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setByte("Slot", (byte)currentIndex);
            this.inventory[currentIndex].writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag("Items", (NBTBase)tagList);
    }

    @Override
    public String getTagLabel() {
        return "InventoryAlchemicalBag";
    }

    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public String getCustomName() {
        return this.customName;
    }
}

