/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.inventory;

import com.pahimar.ee3.reference.Comparators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryTransmutationTablet
implements IInventory {
    private ItemStack[] inventory = new ItemStack[30];
    private Set<ItemStack> knownTransmutations = new TreeSet<ItemStack>(Comparators.idComparator);

    public InventoryTransmutationTablet() {
        this(null);
    }

    public InventoryTransmutationTablet(Collection<ItemStack> knownTransmutations) {
        ArrayList<ItemStack> knownTransmutationsList;
        if (knownTransmutations != null) {
            this.knownTransmutations.addAll(knownTransmutations);
        }
        this.inventory = (knownTransmutationsList = new ArrayList<ItemStack>(this.knownTransmutations)).size() <= 30 ? knownTransmutationsList.toArray(this.inventory) : knownTransmutationsList.subList(0, 30).toArray(this.inventory);
        for (int i = 0; i < this.inventory.length; ++i) {
            if (!(this.inventory[i] instanceof ItemStack)) continue;
            this.inventory[i].stackSize = 1;
        }
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        if (slotIndex < this.getSizeInventory()) {
            return this.inventory[slotIndex];
        }
        return null;
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
            this.setInventorySlotContents(slotIndex, itemStack);
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        if (this.getStackInSlot(slotIndex) != null) {
            ItemStack itemStack = this.inventory[slotIndex];
            this.inventory[slotIndex] = null;
            return itemStack;
        }
        return null;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        if (slotIndex < this.inventory.length) {
            if (itemStack != null) {
                ItemStack copiedItemStack = itemStack.copy();
                copiedItemStack.stackSize = 1;
                this.inventory[slotIndex] = copiedItemStack;
            } else {
                this.inventory[slotIndex] = itemStack;
            }
        }
    }

    public String getInventoryName() {
        return "container.ee3:alchemicalTome";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return false;
    }

    public Set<ItemStack> getKnownTransmutations() {
        return this.knownTransmutations;
    }
}

